/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import org.testng.annotations.Test;

public class TestForceSingleNodeOutput
extends BasePlanTest {
    @Test
    public void testSimpleScan() {
        this.assertPlanWithSession("SELECT * FROM orders", this.singleNodeOutput(false), false, PlanMatchPattern.output(PlanMatchPattern.tableScan("orders")));
        this.assertPlanWithSession("SELECT * FROM orders", this.singleNodeOutput(true), false, PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.tableScan("orders"))));
    }

    @Test
    public void testGroupBy() {
        this.assertPlanWithSession("SELECT orderkey, count(*) FROM orders GROUP BY orderkey", this.singleNodeOutput(false), false, PlanMatchPattern.output(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.tableScan("orders"))));
        this.assertPlanWithSession("SELECT orderkey, count(*) FROM orders GROUP BY orderkey", this.singleNodeOutput(true), false, PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.tableScan("orders")))));
    }

    @Test
    public void testOrderBy() {
        this.assertPlanWithSession("SELECT orderkey FROM orders ORDER BY orderkey", this.singleNodeOutput(false), false, PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
        this.assertPlanWithSession("SELECT orderkey FROM orders ORDER BY orderkey", this.singleNodeOutput(true), false, PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
    }

    private Session singleNodeOutput(boolean force) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("force_single_node_output", Boolean.toString(force)).build();
    }
}

