/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.sanity.ValidateAggregationsWithDefaultValues;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestValidateAggregationsWithDefaultValues
extends BasePlanTest {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private Metadata metadata;
    private PlanBuilder builder;
    private Symbol symbol;
    private TableScanNode tableScanNode;

    @BeforeClass
    public void setup() {
        this.metadata = this.getQueryRunner().getMetadata();
        this.builder = new PlanBuilder(new PlanNodeIdAllocator(), this.metadata);
        ConnectorId connectorId = this.getCurrentConnectorId();
        TableHandle nationTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)new TpchTableHandle(connectorId.toString(), "nation", 1.0));
        TableLayoutHandle nationTableLayoutHandle = new TableLayoutHandle(connectorId, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorTableLayoutHandle)new TpchTableLayoutHandle((TpchTableHandle)nationTableHandle.getConnectorHandle(), TupleDomain.all()));
        TpchColumnHandle nationkeyColumnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.symbol = new Symbol("nationkey");
        this.tableScanNode = this.builder.tableScan(nationTableHandle, (List<Symbol>)ImmutableList.of((Object)this.symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)this.symbol, (Object)nationkeyColumnHandle), Optional.of(nationTableLayoutHandle));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Final aggregation with default value not separated from partial aggregation by remote hash exchange")
    public void testGloballyDistributedFinalAggregationInTheSameStageAsPartialAggregation() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))));
        this.validatePlan((PlanNode)root, false);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Final aggregation with default value not separated from partial aggregation by local hash exchange")
    public void testSingleNodeFinalAggregationInTheSameStageAsPartialAggregation() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))));
        this.validatePlan((PlanNode)root, true);
    }

    @Test
    public void testSingleThreadFinalAggregationInTheSameStageAsPartialAggregation() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.values(new Symbol[0])))));
        this.validatePlan((PlanNode)root, true);
    }

    @Test
    public void testGloballyDistributedFinalAggregationSeparatedFromPartialAggregationByRemoteHashExchange() {
        Symbol symbol = new Symbol("symbol");
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.exchange(e -> e.type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.REMOTE).fixedHashDistributionParitioningScheme((List<Symbol>)ImmutableList.of((Object)symbol), (List<Symbol>)ImmutableList.of((Object)symbol)).addInputsSet(symbol).addSource((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))))));
        this.validatePlan((PlanNode)root, false);
    }

    @Test
    public void testSingleNodeFinalAggregationSeparatedFromPartialAggregationByLocalHashExchange() {
        Symbol symbol = new Symbol("symbol");
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.exchange(e -> e.type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL).fixedHashDistributionParitioningScheme((List<Symbol>)ImmutableList.of((Object)symbol), (List<Symbol>)ImmutableList.of((Object)symbol)).addInputsSet(symbol).addSource((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))))));
        this.validatePlan((PlanNode)root, true);
    }

    @Test
    public void testWithPartialAggregationBelowJoin() {
        Symbol symbol = new Symbol("symbol");
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.exchange(e -> e.type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL).fixedHashDistributionParitioningScheme((List<Symbol>)ImmutableList.of((Object)symbol), (List<Symbol>)ImmutableList.of((Object)symbol)).addInputsSet(symbol).addSource((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode)))), (PlanNode)this.builder.values(new Symbol[0]), new JoinNode.EquiJoinClause[0])));
        this.validatePlan((PlanNode)root, true);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Final aggregation with default value not separated from partial aggregation by local hash exchange")
    public void testWithPartialAggregationBelowJoinWithoutSeparatingExchange() {
        Symbol symbol = new Symbol("symbol");
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode)), (PlanNode)this.builder.values(new Symbol[0]), new JoinNode.EquiJoinClause[0])));
        this.validatePlan((PlanNode)root, true);
    }

    private void validatePlan(PlanNode root, boolean forceSingleNode) {
        this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            new ValidateAggregationsWithDefaultValues(forceSingleNode).validate(root, session, this.metadata, SQL_PARSER, TypeProvider.empty());
            return null;
        });
    }
}

