/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.assertions.BasePlanTest;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.sanity.ValidateStreamingAggregations;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestValidateStreamingAggregations
extends BasePlanTest {
    private Metadata metadata;
    private SqlParser sqlParser;
    private PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
    private TableHandle nationTableHandle;
    private TableLayoutHandle nationTableLayoutHandle;

    @BeforeClass
    public void setup() {
        this.metadata = this.getQueryRunner().getMetadata();
        this.sqlParser = this.getQueryRunner().getSqlParser();
        ConnectorId connectorId = this.getCurrentConnectorId();
        this.nationTableHandle = new TableHandle(connectorId, (ConnectorTableHandle)new TpchTableHandle(connectorId.toString(), "nation", 1.0));
        this.nationTableLayoutHandle = new TableLayoutHandle(connectorId, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorTableLayoutHandle)new TpchTableLayoutHandle((TpchTableHandle)this.nationTableHandle.getConnectorHandle(), TupleDomain.all()));
    }

    @Test
    public void testValidateSuccessful() {
        this.validatePlan(p -> p.aggregation(a -> a.step(AggregationNode.Step.SINGLE).singleGroupingSet(p.symbol("nationkey")).source((PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), Optional.of(this.nationTableLayoutHandle)))));
        this.validatePlan(p -> p.aggregation(a -> a.step(AggregationNode.Step.SINGLE).singleGroupingSet(p.symbol("unique"), p.symbol("nationkey")).preGroupedSymbols(p.symbol("unique"), p.symbol("nationkey")).source((PlanNode)p.assignUniqueId(p.symbol("unique"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), Optional.of(this.nationTableLayoutHandle))))));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Streaming aggregation with input not grouped on the grouping keys")
    public void testValidateFailed() {
        this.validatePlan(p -> p.aggregation(a -> a.step(AggregationNode.Step.SINGLE).singleGroupingSet(p.symbol("nationkey")).preGroupedSymbols(p.symbol("nationkey")).source((PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), Optional.of(this.nationTableLayoutHandle)))));
    }

    private void validatePlan(Function<PlanBuilder, PlanNode> planProvider) {
        PlanBuilder builder = new PlanBuilder(this.idAllocator, this.metadata);
        PlanNode planNode = planProvider.apply(builder);
        TypeProvider types = builder.getTypes();
        this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            new ValidateStreamingAggregations().validate(planNode, session, this.metadata, this.sqlParser, types);
            return null;
        });
    }
}

