/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.query;

import com.facebook.presto.sql.query.QueryAssertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFilteredAggregations {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testGroupAll() {
        this.assertions.assertQuery("SELECT count(DISTINCT x) FILTER (WHERE x > 1) FROM (VALUES 1, 1, 1, 2, 3, 3) t(x)", "VALUES BIGINT '2'");
        this.assertions.assertQuery("SELECT count(DISTINCT x) FILTER (WHERE x > 1), sum(DISTINCT x) FROM (VALUES 1, 1, 1, 2, 3, 3) t(x)", "VALUES (BIGINT '2', BIGINT '6')");
        this.assertions.assertQuery("SELECT count(DISTINCT x) FILTER (WHERE x > 1), sum(DISTINCT y) FILTER (WHERE x < 3)FROM (VALUES (1, 10),(1, 20),(1, 20),(2, 20),(3, 30)) t(x, y)", "VALUES (BIGINT '2', BIGINT '30')");
        this.assertions.assertQuery("SELECT count(x) FILTER (WHERE x > 1), sum(DISTINCT x) FROM (VALUES 1, 2, 3, 3) t(x)", "VALUES (BIGINT '3', BIGINT '6')");
    }

    @Test
    public void testGroupingSets() {
        this.assertions.assertQuery("SELECT k, count(DISTINCT x) FILTER (WHERE y = 100), count(DISTINCT x) FILTER (WHERE y = 200) FROM (VALUES    (1, 1, 100),   (1, 1, 200),   (1, 2, 100),   (1, 3, 300),   (2, 1, 100),   (2, 10, 100),   (2, 20, 100),   (2, 20, 200),   (2, 30, 300),   (2, 40, 100)) t(k, x, y) GROUP BY GROUPING SETS ((), (k))", "VALUES (1, BIGINT '2', BIGINT '1'), (2, BIGINT '4', BIGINT '1'), (CAST(NULL AS INTEGER), BIGINT '5', BIGINT '2')");
    }
}

