/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.query;

import com.facebook.presto.Session;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.sql.SqlPath;
import com.facebook.presto.sql.query.QueryAssertions;
import com.facebook.presto.testing.TestingSession;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestSessionFunctions {
    @Test
    public void testCurrentUser() {
        Session session = TestingSession.testSessionBuilder().setIdentity(new Identity("test_current_user", Optional.empty())).build();
        try (QueryAssertions queryAssertions = new QueryAssertions(session);){
            queryAssertions.assertQuery("SELECT CURRENT_USER", "SELECT CAST('" + session.getUser() + "' AS VARCHAR)");
        }
    }

    @Test
    public void testCurrentPath() {
        Session session = TestingSession.testSessionBuilder().setPath(new SqlPath(Optional.of("testPath"))).build();
        try (QueryAssertions queryAssertions = new QueryAssertions(session);){
            queryAssertions.assertQuery("SELECT CURRENT_PATH", "SELECT CAST('" + session.getPath().toString() + "' AS VARCHAR)");
        }
        Session emptyPathSession = TestingSession.testSessionBuilder().setPath(new SqlPath(Optional.of("\"\""))).build();
        try (QueryAssertions queryAssertions = new QueryAssertions(emptyPathSession);){
            queryAssertions.assertQuery("SELECT CURRENT_PATH", "SELECT CAST('" + emptyPathSession.getPath().toString() + "' AS VARCHAR)");
        }
    }
}

