/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.DeterminismEvaluator;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDeterminismEvaluator {
    @Test
    public void testDeterminismEvaluator() {
        DeterminismEvaluator determinismEvaluator = new DeterminismEvaluator(MetadataManager.createTestMetadataManager().getFunctionRegistry());
        CallExpression random = new CallExpression(new Signature("random", FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"bigint"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint")}), (Type)BigintType.BIGINT, Collections.singletonList(Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)determinismEvaluator.isDeterministic((RowExpression)random));
        InputReferenceExpression col0 = Expressions.field((int)0, (Type)BigintType.BIGINT);
        Signature lessThan = Signature.internalOperator((OperatorType)OperatorType.LESS_THAN, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        CallExpression lessThanExpression = new CallExpression(lessThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)col0, (Object)Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)determinismEvaluator.isDeterministic((RowExpression)lessThanExpression));
        CallExpression lessThanRandomExpression = new CallExpression(lessThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)col0, (Object)random));
        Assert.assertFalse((boolean)determinismEvaluator.isDeterministic((RowExpression)lessThanRandomExpression));
    }
}

