/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.transaction;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.connector.informationSchema.InformationSchemaConnector;
import com.facebook.presto.connector.system.SystemConnector;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.CatalogMetadata;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.testing.TestingConnectorContext;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionInfo;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.transaction.TransactionManagerConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestTransactionManager {
    private static final String CATALOG_NAME = "test_catalog";
    private static final ConnectorId CONNECTOR_ID = new ConnectorId("test_catalog");
    private static final ConnectorId SYSTEM_TABLES_ID = ConnectorId.createSystemTablesConnectorId((ConnectorId)CONNECTOR_ID);
    private static final ConnectorId INFORMATION_SCHEMA_ID = ConnectorId.createInformationSchemaConnectorId((ConnectorId)CONNECTOR_ID);
    private final ExecutorService finishingExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"transaction-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.finishingExecutor.shutdownNow();
    }

    @Test
    public void testTransactionWorkflow() {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            CatalogManager catalogManager = new CatalogManager();
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig(), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)catalogManager, (ExecutorService)this.finishingExecutor);
            Connector c1 = new TpchConnectorFactory().create(CATALOG_NAME, (Map)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
            TestTransactionManager.registerConnector(catalogManager, transactionManager, CATALOG_NAME, CONNECTOR_ID, c1);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            Assert.assertTrue((boolean)transactionInfo.getConnectorIds().isEmpty());
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, CATALOG_NAME).get()).getMetadata();
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(CONNECTOR_ID));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertEquals((Collection)transactionInfo.getConnectorIds(), (Collection)ImmutableList.of((Object)CONNECTOR_ID, (Object)INFORMATION_SCHEMA_ID, (Object)SYSTEM_TABLES_ID));
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            MoreFutures.getFutureValue((Future)transactionManager.asyncCommit(transactionId));
            Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    @Test
    public void testAbortedTransactionWorkflow() {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            CatalogManager catalogManager = new CatalogManager();
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig(), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)catalogManager, (ExecutorService)this.finishingExecutor);
            Connector c1 = new TpchConnectorFactory().create(CATALOG_NAME, (Map)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
            TestTransactionManager.registerConnector(catalogManager, transactionManager, CATALOG_NAME, CONNECTOR_ID, c1);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            Assert.assertTrue((boolean)transactionInfo.getConnectorIds().isEmpty());
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, CATALOG_NAME).get()).getMetadata();
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(CONNECTOR_ID));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertEquals((Collection)transactionInfo.getConnectorIds(), (Collection)ImmutableList.of((Object)CONNECTOR_ID, (Object)INFORMATION_SCHEMA_ID, (Object)SYSTEM_TABLES_ID));
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            MoreFutures.getFutureValue((Future)transactionManager.asyncAbort(transactionId));
            Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    @Test
    public void testFailedTransactionWorkflow() {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            CatalogManager catalogManager = new CatalogManager();
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig(), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)catalogManager, (ExecutorService)this.finishingExecutor);
            Connector c1 = new TpchConnectorFactory().create(CATALOG_NAME, (Map)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
            TestTransactionManager.registerConnector(catalogManager, transactionManager, CATALOG_NAME, CONNECTOR_ID, c1);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            Assert.assertTrue((boolean)transactionInfo.getConnectorIds().isEmpty());
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, CATALOG_NAME).get()).getMetadata();
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(CONNECTOR_ID));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertEquals((Collection)transactionInfo.getConnectorIds(), (Collection)ImmutableList.of((Object)CONNECTOR_ID, (Object)INFORMATION_SCHEMA_ID, (Object)SYSTEM_TABLES_ID));
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            transactionManager.fail(transactionId);
            Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            try {
                transactionManager.getCatalogMetadata(transactionId, CONNECTOR_ID);
                Assert.fail();
            }
            catch (PrestoException e) {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.TRANSACTION_ALREADY_ABORTED.toErrorCode());
            }
            Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            MoreFutures.getFutureValue((Future)transactionManager.asyncAbort(transactionId));
            Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    @Test
    public void testExpiration() throws Exception {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.MILLISECONDS)).setIdleCheckInterval(new Duration(5.0, TimeUnit.MILLISECONDS)), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)new CatalogManager(), (ExecutorService)this.finishingExecutor);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
            Assert.assertTrue((boolean)transactionInfo.getConnectorIds().isEmpty());
            Assert.assertFalse((boolean)transactionInfo.getWrittenConnectorId().isPresent());
            transactionManager.trySetInactive(transactionId);
            TimeUnit.MILLISECONDS.sleep(100L);
            Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        }
    }

    private static void registerConnector(CatalogManager catalogManager, TransactionManager transactionManager, String catalogName, ConnectorId connectorId, Connector connector) {
        ConnectorId systemId = ConnectorId.createSystemTablesConnectorId((ConnectorId)connectorId);
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        MetadataManager metadata = MetadataManager.createTestMetadataManager((CatalogManager)catalogManager);
        catalogManager.registerCatalog(new Catalog(catalogName, connectorId, connector, ConnectorId.createInformationSchemaConnectorId((ConnectorId)connectorId), (Connector)new InformationSchemaConnector(catalogName, (InternalNodeManager)nodeManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()), systemId, (Connector)new SystemConnector(systemId, (InternalNodeManager)nodeManager, connector.getSystemTables(), transactionId -> transactionManager.getConnectorTransaction(transactionId, connectorId))));
    }

    private static class IdleCheckExecutor
    implements Closeable {
        private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"idle-check"));

        private IdleCheckExecutor() {
        }

        public ScheduledExecutorService getExecutor() {
            return this.executorService;
        }

        @Override
        public void close() {
            this.executorService.shutdownNow();
        }
    }
}

