/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.AbstractTestType;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.StructuralTestUtil;
import java.util.List;

public class TestBigintArrayType
extends AbstractTestType {
    public TestBigintArrayType() {
        super(new TypeRegistry().getType(TypeSignature.parseTypeSignature((String)"array(bigint)")), List.class, TestBigintArrayType.createTestBlock(new TypeRegistry().getType(TypeSignature.parseTypeSignature((String)"array(bigint)"))));
    }

    public static Block createTestBlock(Type arrayType) {
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 4);
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 1, 2));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 100, 200, 300));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        Block block = (Block)value;
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, block.getPositionCount() + 1);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            BigintType.BIGINT.appendTo(block, i, blockBuilder);
        }
        BigintType.BIGINT.writeLong(blockBuilder, 1L);
        return blockBuilder.build();
    }
}

