/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.Session;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlTimeWithTimeZone;
import com.facebook.presto.spi.type.SqlTimestampWithTimeZone;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.DateTimeTestingUtils;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.util.DateTimeZoneIndex;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.annotations.Test;

public abstract class TestDateTimeOperatorsBase
extends AbstractTestFunctions {
    protected static final TimeZoneKey TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin");
    protected static final DateTimeZone TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);
    protected static final DateTimeZone WEIRD_TIME_ZONE = DateTimeZone.forOffsetHoursMinutes((int)5, (int)9);
    protected static final TimeZoneKey WEIRD_TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)309L);

    protected TestDateTimeOperatorsBase(boolean legacyTimestamp) {
        super(TestingSession.testSessionBuilder().setSystemProperty("legacy_timestamp", String.valueOf(legacyTimestamp)).setTimeZoneKey(TIME_ZONE_KEY).build());
    }

    @Test
    public void testDatePlusInterval() {
        this.assertFunction("DATE '2001-1-22' + INTERVAL '3' day", (Type)DateType.DATE, TestDateTimeOperatorsBase.toDate(new DateTime(2001, 1, 25, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("INTERVAL '3' day + DATE '2001-1-22'", (Type)DateType.DATE, TestDateTimeOperatorsBase.toDate(new DateTime(2001, 1, 25, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("DATE '2001-1-22' + INTERVAL '3' month", (Type)DateType.DATE, TestDateTimeOperatorsBase.toDate(new DateTime(2001, 4, 22, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("INTERVAL '3' month + DATE '2001-1-22'", (Type)DateType.DATE, TestDateTimeOperatorsBase.toDate(new DateTime(2001, 4, 22, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("DATE '2001-1-22' + INTERVAL '3' year", (Type)DateType.DATE, TestDateTimeOperatorsBase.toDate(new DateTime(2004, 1, 22, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertFunction("INTERVAL '3' year + DATE '2001-1-22'", (Type)DateType.DATE, TestDateTimeOperatorsBase.toDate(new DateTime(2004, 1, 22, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertInvalidFunction("DATE '2001-1-22' + INTERVAL '3' hour", "Cannot add hour, minutes or seconds to a date");
        this.assertInvalidFunction("INTERVAL '3' hour + DATE '2001-1-22'", "Cannot add hour, minutes or seconds to a date");
    }

    @Test
    public void testTimePlusInterval() {
        this.assertFunction("TIME '03:04:05.321' + INTERVAL '3' hour", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)6, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("INTERVAL '3' hour + TIME '03:04:05.321'", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)6, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIME '03:04:05.321' + INTERVAL '3' day", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("INTERVAL '3' day + TIME '03:04:05.321'", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIME '03:04:05.321' + INTERVAL '3' month", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("INTERVAL '3' month + TIME '03:04:05.321'", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIME '03:04:05.321' + INTERVAL '3' year", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("INTERVAL '3' year + TIME '03:04:05.321'", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIME '03:04:05.321' + INTERVAL '27' hour", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)6, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("INTERVAL '27' hour + TIME '03:04:05.321'", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)6, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIME '03:04:05.321 +05:09' + INTERVAL '3' hour", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' hour + TIME '03:04:05.321 +05:09'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' + INTERVAL '3' day", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' day + TIME '03:04:05.321 +05:09'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' + INTERVAL '3' month", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' month + TIME '03:04:05.321 +05:09'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' + INTERVAL '3' year", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' year + TIME '03:04:05.321 +05:09'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' + INTERVAL '27' hour", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '27' hour + TIME '03:04:05.321 +05:09'", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testTimestampPlusInterval() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' + INTERVAL '3' hour", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)1, (int)22, (int)6, (int)4, (int)5, (int)321, (DateTimeZone)TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (Session)this.session));
        this.assertFunction("INTERVAL '3' hour + TIMESTAMP '2001-1-22 03:04:05.321'", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)1, (int)22, (int)6, (int)4, (int)5, (int)321, (DateTimeZone)TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' + INTERVAL '3' day", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)1, (int)25, (int)3, (int)4, (int)5, (int)321, (DateTimeZone)TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (Session)this.session));
        this.assertFunction("INTERVAL '3' day + TIMESTAMP '2001-1-22 03:04:05.321'", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)1, (int)25, (int)3, (int)4, (int)5, (int)321, (DateTimeZone)TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' + INTERVAL '3' month", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)4, (int)22, (int)3, (int)4, (int)5, (int)321, (DateTimeZone)TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (Session)this.session));
        this.assertFunction("INTERVAL '3' month + TIMESTAMP '2001-1-22 03:04:05.321'", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)4, (int)22, (int)3, (int)4, (int)5, (int)321, (DateTimeZone)TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' + INTERVAL '3' year", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2004, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (DateTimeZone)TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (Session)this.session));
        this.assertFunction("INTERVAL '3' year + TIMESTAMP '2001-1-22 03:04:05.321'", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2004, (int)1, (int)22, (int)3, (int)4, (int)5, (int)321, (DateTimeZone)TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' + INTERVAL '3' hour", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, new SqlTimestampWithTimeZone(new DateTime(2001, 1, 22, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' hour + TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, new SqlTimestampWithTimeZone(new DateTime(2001, 1, 22, 6, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' + INTERVAL '3' day", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, new SqlTimestampWithTimeZone(new DateTime(2001, 1, 25, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' day + TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, new SqlTimestampWithTimeZone(new DateTime(2001, 1, 25, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' + INTERVAL '3' month", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, new SqlTimestampWithTimeZone(new DateTime(2001, 4, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' month + TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, new SqlTimestampWithTimeZone(new DateTime(2001, 4, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' + INTERVAL '3' year", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, new SqlTimestampWithTimeZone(new DateTime(2004, 1, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("INTERVAL '3' year + TIMESTAMP '2001-1-22 03:04:05.321 +05:09'", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, new SqlTimestampWithTimeZone(new DateTime(2004, 1, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testDateMinusInterval() {
        this.assertFunction("DATE '2001-1-22' - INTERVAL '3' day", (Type)DateType.DATE, TestDateTimeOperatorsBase.toDate(new DateTime(2001, 1, 19, 0, 0, 0, 0, DateTimeZone.UTC)));
        this.assertInvalidFunction("DATE '2001-1-22' - INTERVAL '3' hour", "Cannot subtract hour, minutes or seconds from a date");
    }

    @Test
    public void testTimeMinusInterval() {
        this.assertFunction("TIME '03:04:05.321' - INTERVAL '3' hour", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)0, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIME '03:04:05.321' - INTERVAL '3' day", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIME '03:04:05.321' - INTERVAL '3' month", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIME '03:04:05.321' - INTERVAL '3' year", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)3, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIME '03:04:05.321' - INTERVAL '6' hour", (Type)TimeType.TIME, DateTimeTestingUtils.sqlTimeOf((int)21, (int)4, (int)5, (int)321, (Session)this.session));
        this.assertFunction("TIME '03:04:05.321 +05:09' - INTERVAL '3' hour", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 0, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' - INTERVAL '3' day", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' - INTERVAL '3' month", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' - INTERVAL '3' year", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIME '03:04:05.321 +05:09' - INTERVAL '6' hour", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 21, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testTimestampMinusInterval() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' - INTERVAL '3' day", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2001, (int)1, (int)19, (int)3, (int)4, (int)5, (int)321, (DateTimeZone)TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' - INTERVAL '3' day", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, new SqlTimestampWithTimeZone(new DateTime(2001, 1, 19, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' - INTERVAL '3' month", (Type)TimestampType.TIMESTAMP, DateTimeTestingUtils.sqlTimestampOf((int)2000, (int)10, (int)22, (int)3, (int)4, (int)5, (int)321, (DateTimeZone)TIME_ZONE, (TimeZoneKey)TIME_ZONE_KEY, (Session)this.session));
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321 +05:09' - INTERVAL '3' month", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, new SqlTimestampWithTimeZone(new DateTime(2000, 10, 22, 3, 4, 5, 321, WEIRD_TIME_ZONE).getMillis(), WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testDateToTimestampCoercing() {
        this.assertFunction("date_format(DATE '2013-10-27', '%Y-%m-%d %H:%i:%s')", (Type)VarcharType.VARCHAR, "2013-10-27 00:00:00");
        this.assertFunction("DATE '2013-10-27' = TIMESTAMP '2013-10-27 00:00:00'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2013-10-27' < TIMESTAMP '2013-10-27 00:00:01'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2013-10-27' > TIMESTAMP '2013-10-26 23:59:59'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testDateToTimestampWithZoneCoercing() {
        this.assertFunction("DATE '2013-10-27' = TIMESTAMP '2013-10-27 00:00:00 Europe/Berlin'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2013-10-27' < TIMESTAMP '2013-10-27 00:00:01 Europe/Berlin'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2013-10-27' > TIMESTAMP '2013-10-26 23:59:59 Europe/Berlin'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS DATE) IS DISTINCT FROM CAST(NULL AS DATE)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DATE '2013-10-27' IS DISTINCT FROM TIMESTAMP '2013-10-27 00:00:00'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("DATE '2013-10-27' IS DISTINCT FROM TIMESTAMP '2013-10-28 00:00:00'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM DATE '2013-10-27'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("DATE '2013-10-27' IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
    }

    private static SqlDate toDate(DateTime dateTime) {
        return new SqlDate((int)TimeUnit.MILLISECONDS.toDays(dateTime.getMillis()));
    }
}

