/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.DoubleOperators;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDoubleOperators
extends AbstractTestFunctions {
    @Test
    public void testLiteral() {
        this.assertFunction("37.7E0", (Type)DoubleType.DOUBLE, 37.7);
        this.assertFunction("17.1E0", (Type)DoubleType.DOUBLE, 17.1);
    }

    @Test
    public void testTypeConstructor() {
        this.assertFunction("DOUBLE '12.34'", (Type)DoubleType.DOUBLE, 12.34);
        this.assertFunction("DOUBLE '-17.6'", (Type)DoubleType.DOUBLE, -17.6);
        this.assertFunction("DOUBLE '+754'", (Type)DoubleType.DOUBLE, 754.0);
        this.assertFunction("DOUBLE PRECISION '12.34'", (Type)DoubleType.DOUBLE, 12.34);
        this.assertFunction("DOUBLE PRECISION '-17.6'", (Type)DoubleType.DOUBLE, -17.6);
        this.assertFunction("DOUBLE PRECISION '+754'", (Type)DoubleType.DOUBLE, 754.0);
    }

    @Test
    public void testAdd() {
        this.assertFunction("37.7E0 + 37.7E0", (Type)DoubleType.DOUBLE, 75.4);
        this.assertFunction("37.7E0 + 17.1E0", (Type)DoubleType.DOUBLE, 54.800000000000004);
        this.assertFunction("17.1E0 + 37.7E0", (Type)DoubleType.DOUBLE, 54.800000000000004);
        this.assertFunction("17.1E0 + 17.1E0", (Type)DoubleType.DOUBLE, 34.2);
    }

    @Test
    public void testSubtract() {
        this.assertFunction("37.7E0 - 37.7E0", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("37.7E0 - 17.1E0", (Type)DoubleType.DOUBLE, 20.6);
        this.assertFunction("17.1E0 - 37.7E0", (Type)DoubleType.DOUBLE, -20.6);
        this.assertFunction("17.1E0 - 17.1E0", (Type)DoubleType.DOUBLE, 0.0);
    }

    @Test
    public void testMultiply() {
        this.assertFunction("37.7E0 * 37.7E0", (Type)DoubleType.DOUBLE, 1421.2900000000002);
        this.assertFunction("37.7E0 * 17.1E0", (Type)DoubleType.DOUBLE, 644.6700000000001);
        this.assertFunction("17.1E0 * 37.7E0", (Type)DoubleType.DOUBLE, 644.6700000000001);
        this.assertFunction("17.1E0 * 17.1E0", (Type)DoubleType.DOUBLE, 292.41);
    }

    @Test
    public void testDivide() {
        this.assertFunction("37.7E0 / 37.7E0", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("37.7E0 / 17.1E0", (Type)DoubleType.DOUBLE, 2.2046783625730995);
        this.assertFunction("17.1E0 / 37.7E0", (Type)DoubleType.DOUBLE, 0.4535809018567639);
        this.assertFunction("17.1E0 / 17.1E0", (Type)DoubleType.DOUBLE, 1.0);
    }

    @Test
    public void testModulus() {
        this.assertFunction("37.7E0 % 37.7E0", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("37.7E0 % 17.1E0", (Type)DoubleType.DOUBLE, 3.5);
        this.assertFunction("17.1E0 % 37.7E0", (Type)DoubleType.DOUBLE, 17.1);
        this.assertFunction("17.1E0 % 17.1E0", (Type)DoubleType.DOUBLE, 0.0);
    }

    @Test
    public void testNegation() {
        this.assertFunction("-(37.7E0)", (Type)DoubleType.DOUBLE, -37.7);
        this.assertFunction("-(17.1E0)", (Type)DoubleType.DOUBLE, -17.1);
    }

    @Test
    public void testEqual() {
        this.assertFunction("37.7E0 = 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37.7E0 = 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 = 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 = 17.1E0", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("37.7E0 <> 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7E0 <> 17.1E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 <> 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 <> 17.1E0", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("37.7E0 < 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7E0 < 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 < 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 < 17.1E0", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("37.7E0 <= 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37.7E0 <= 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 <= 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 <= 17.1E0", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("37.7E0 > 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7E0 > 17.1E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 > 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 > 17.1E0", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("37.7E0 >= 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37.7E0 >= 17.1E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 >= 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 >= 17.1E0", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testBetween() {
        this.assertFunction("37.7E0 BETWEEN 37.7E0 AND 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37.7E0 BETWEEN 37.7E0 AND 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7E0 BETWEEN 17.1E0 AND 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37.7E0 BETWEEN 17.1E0 AND 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 BETWEEN 37.7E0 AND 37.7E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 BETWEEN 37.7E0 AND 17.1E0", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("17.1E0 BETWEEN 17.1E0 AND 37.7E0", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("17.1E0 BETWEEN 17.1E0 AND 17.1E0", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testCastToVarchar() {
        this.assertFunction("cast(37.7E0 as varchar)", (Type)VarcharType.VARCHAR, "37.7");
        this.assertFunction("cast(17.1E0 as varchar)", (Type)VarcharType.VARCHAR, "17.1");
    }

    @Test
    public void testCastToBigint() {
        this.assertFunction("cast(37.7E0 as bigint)", (Type)BigintType.BIGINT, 38L);
        this.assertFunction("cast(-37.7E0 as bigint)", (Type)BigintType.BIGINT, -38L);
        this.assertFunction("cast(17.1E0 as bigint)", (Type)BigintType.BIGINT, 17L);
        this.assertFunction("cast(-17.1E0 as bigint)", (Type)BigintType.BIGINT, -17L);
        this.assertFunction("cast(9.2E18 as bigint)", (Type)BigintType.BIGINT, 9200000000000000000L);
        this.assertFunction("cast(-9.2E18 as bigint)", (Type)BigintType.BIGINT, -9200000000000000000L);
        this.assertFunction("cast(2.21E9 as bigint)", (Type)BigintType.BIGINT, 2210000000L);
        this.assertFunction("cast(-2.21E9 as bigint)", (Type)BigintType.BIGINT, -2210000000L);
        this.assertFunction("cast(17.5E0 as bigint)", (Type)BigintType.BIGINT, 18L);
        this.assertFunction("cast(-17.5E0 as bigint)", (Type)BigintType.BIGINT, -18L);
        this.assertFunction("cast(" + Math.nextDown(9.223372036854776E18) + " as bigint)", (Type)BigintType.BIGINT, (long)Math.nextDown(9.223372036854776E18));
        this.assertInvalidFunction("cast(9.223372036854776E18 as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(" + Math.nextUp(9.223372036854776E18) + " as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(" + Math.nextDown(-9.223372036854776E18) + " as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertFunction("cast(-9.223372036854776E18 as bigint)", (Type)BigintType.BIGINT, Long.MIN_VALUE);
        this.assertFunction("cast(" + Math.nextUp(-9.223372036854776E18) + " as bigint)", (Type)BigintType.BIGINT, (long)Math.nextUp(-9.223372036854776E18));
        this.assertInvalidFunction("cast(9.3E18 as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(-9.3E18 as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(infinity() as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(-infinity() as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
        this.assertInvalidFunction("cast(nan() as bigint)", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
    }

    @Test
    public void testCastToBoolean() {
        this.assertFunction("cast(37.7E0 as boolean)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(17.1E0 as boolean)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(0.0E0 as boolean)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastToFloat() {
        this.assertFunction("cast('754.1985' as real)", (Type)RealType.REAL, Float.valueOf(754.1985f));
        this.assertFunction("cast('-754.2008' as real)", (Type)RealType.REAL, Float.valueOf(-754.2008f));
        this.assertFunction("cast('0.0' as real)", (Type)RealType.REAL, Float.valueOf(0.0f));
        this.assertFunction("cast('-0.0' as real)", (Type)RealType.REAL, Float.valueOf(-0.0f));
    }

    @Test
    public void testCastFromVarchar() {
        this.assertFunction("cast('37.7' as double)", (Type)DoubleType.DOUBLE, 37.7);
        this.assertFunction("cast('17.1' as double)", (Type)DoubleType.DOUBLE, 17.1);
        this.assertFunction("cast('37.7' as double precision)", (Type)DoubleType.DOUBLE, 37.7);
        this.assertFunction("cast('17.1' as double precision)", (Type)DoubleType.DOUBLE, 17.1);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS DOUBLE) IS DISTINCT FROM CAST(NULL AS DOUBLE)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37.7 IS DISTINCT FROM 37.7", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37 IS DISTINCT FROM 37.8", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM 37.7", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37.7 IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("nan() IS DISTINCT FROM nan()", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as double)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "1.2", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(1.2 as double)", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(1 as double)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNanHash() {
        long[] nanRepresentations;
        for (long nanRepresentation : nanRepresentations = new long[]{Double.doubleToLongBits(Double.NaN), -2251799813685248L, 9221140251894092340L, -2231784960683468L}) {
            Assert.assertTrue((boolean)Double.isNaN(Double.longBitsToDouble(nanRepresentation)));
            Assert.assertTrue((nanRepresentation == nanRepresentations[0] || Double.doubleToRawLongBits(Double.longBitsToDouble(nanRepresentation)) != Double.doubleToRawLongBits(Double.longBitsToDouble(nanRepresentations[0])) ? 1 : 0) != 0);
            Assert.assertEquals((long)DoubleOperators.hashCode((double)Double.longBitsToDouble(nanRepresentation)), (long)DoubleOperators.hashCode((double)Double.longBitsToDouble(nanRepresentations[0])));
        }
    }
}

