/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestIntegerOperators
extends AbstractTestFunctions {
    @Test
    public void testLiteral() {
        this.assertFunction("INTEGER'37'", (Type)IntegerType.INTEGER, 37);
        this.assertFunction("INTEGER'17'", (Type)IntegerType.INTEGER, 17);
        this.assertInvalidCast("INTEGER'2147483648'");
    }

    @Test
    public void testUnaryPlus() {
        this.assertFunction("+INTEGER'37'", (Type)IntegerType.INTEGER, 37);
        this.assertFunction("+INTEGER'17'", (Type)IntegerType.INTEGER, 17);
    }

    @Test
    public void testUnaryMinus() {
        this.assertFunction("INTEGER'-37'", (Type)IntegerType.INTEGER, -37);
        this.assertFunction("INTEGER'-17'", (Type)IntegerType.INTEGER, -17);
        this.assertInvalidFunction("INTEGER'--2147483648'", (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
    }

    @Test
    public void testAdd() {
        this.assertFunction("INTEGER'37' + INTEGER'37'", (Type)IntegerType.INTEGER, 74);
        this.assertFunction("INTEGER'37' + INTEGER'17'", (Type)IntegerType.INTEGER, 54);
        this.assertFunction("INTEGER'17' + INTEGER'37'", (Type)IntegerType.INTEGER, 54);
        this.assertFunction("INTEGER'17' + INTEGER'17'", (Type)IntegerType.INTEGER, 34);
        this.assertNumericOverflow(String.format("INTEGER'%s' + INTEGER'1'", Integer.MAX_VALUE), "integer addition overflow: 2147483647 + 1");
    }

    @Test
    public void testSubtract() {
        this.assertFunction("INTEGER'37' - INTEGER'37'", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("INTEGER'37' - INTEGER'17'", (Type)IntegerType.INTEGER, 20);
        this.assertFunction("INTEGER'17' - INTEGER'37'", (Type)IntegerType.INTEGER, -20);
        this.assertFunction("INTEGER'17' - INTEGER'17'", (Type)IntegerType.INTEGER, 0);
        this.assertNumericOverflow(String.format("INTEGER'%s' - INTEGER'1'", Integer.MIN_VALUE), "integer subtraction overflow: -2147483648 - 1");
    }

    @Test
    public void testMultiply() {
        this.assertFunction("INTEGER'37' * INTEGER'37'", (Type)IntegerType.INTEGER, 1369);
        this.assertFunction("INTEGER'37' * INTEGER'17'", (Type)IntegerType.INTEGER, 629);
        this.assertFunction("INTEGER'17' * INTEGER'37'", (Type)IntegerType.INTEGER, 629);
        this.assertFunction("INTEGER'17' * INTEGER'17'", (Type)IntegerType.INTEGER, 289);
        this.assertNumericOverflow(String.format("INTEGER'%s' * INTEGER'2'", Integer.MAX_VALUE), "integer multiplication overflow: 2147483647 * 2");
    }

    @Test
    public void testDivide() {
        this.assertFunction("INTEGER'37' / INTEGER'37'", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("INTEGER'37' / INTEGER'17'", (Type)IntegerType.INTEGER, 2);
        this.assertFunction("INTEGER'17' / INTEGER'37'", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("INTEGER'17' / INTEGER'17'", (Type)IntegerType.INTEGER, 1);
        this.assertInvalidFunction("INTEGER'17' / INTEGER'0'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
    }

    @Test
    public void testModulus() {
        this.assertFunction("INTEGER'37' % INTEGER'37'", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("INTEGER'37' % INTEGER'17'", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("INTEGER'17' % INTEGER'37'", (Type)IntegerType.INTEGER, 17);
        this.assertFunction("INTEGER'17' % INTEGER'17'", (Type)IntegerType.INTEGER, 0);
        this.assertInvalidFunction("INTEGER'17' % INTEGER'0'", (ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO);
    }

    @Test
    public void testNegation() {
        this.assertFunction("-(INTEGER'37')", (Type)IntegerType.INTEGER, -37);
        this.assertFunction("-(INTEGER'17')", (Type)IntegerType.INTEGER, -17);
        this.assertFunction("-(INTEGER'2147483647')", (Type)IntegerType.INTEGER, -2147483647);
        this.assertNumericOverflow(String.format("-(INTEGER'%s')", Integer.MIN_VALUE), "integer negation overflow: -2147483648");
    }

    @Test
    public void testEqual() {
        this.assertFunction("INTEGER'37' = INTEGER'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTEGER'37' = INTEGER'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTEGER'17' = INTEGER'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTEGER'17' = INTEGER'17'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("INTEGER'37' <> INTEGER'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTEGER'37' <> INTEGER'17'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTEGER'17' <> INTEGER'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTEGER'17' <> INTEGER'17'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("INTEGER'37' < INTEGER'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTEGER'37' < INTEGER'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTEGER'17' < INTEGER'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTEGER'17' < INTEGER'17'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("INTEGER'37' <= INTEGER'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTEGER'37' <= INTEGER'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTEGER'17' <= INTEGER'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTEGER'17' <= INTEGER'17'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("INTEGER'37' > INTEGER'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTEGER'37' > INTEGER'17'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTEGER'17' > INTEGER'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTEGER'17' > INTEGER'17'", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("INTEGER'37' >= INTEGER'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTEGER'37' >= INTEGER'17'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTEGER'17' >= INTEGER'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTEGER'17' >= INTEGER'17'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testBetween() {
        this.assertFunction("INTEGER'37' BETWEEN INTEGER'37' AND INTEGER'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTEGER'37' BETWEEN INTEGER'37' AND INTEGER'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTEGER'37' BETWEEN INTEGER'17' AND INTEGER'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTEGER'37' BETWEEN INTEGER'17' AND INTEGER'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTEGER'17' BETWEEN INTEGER'37' AND INTEGER'37'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTEGER'17' BETWEEN INTEGER'37' AND INTEGER'17'", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("INTEGER'17' BETWEEN INTEGER'17' AND INTEGER'37'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("INTEGER'17' BETWEEN INTEGER'17' AND INTEGER'17'", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testCastToBigint() {
        this.assertFunction("cast(INTEGER'37' as bigint)", (Type)BigintType.BIGINT, 37L);
        this.assertFunction("cast(INTEGER'17' as bigint)", (Type)BigintType.BIGINT, 17L);
    }

    @Test
    public void testCastToSmallint() {
        this.assertFunction("cast(INTEGER'37' as smallint)", (Type)SmallintType.SMALLINT, (short)37);
        this.assertFunction("cast(INTEGER'17' as smallint)", (Type)SmallintType.SMALLINT, (short)17);
    }

    @Test
    public void testCastToTinyint() {
        this.assertFunction("cast(INTEGER'37' as tinyint)", (Type)TinyintType.TINYINT, (byte)37);
        this.assertFunction("cast(INTEGER'17' as tinyint)", (Type)TinyintType.TINYINT, (byte)17);
    }

    @Test
    public void testCastToVarchar() {
        this.assertFunction("cast(INTEGER'37' as varchar)", (Type)VarcharType.VARCHAR, "37");
        this.assertFunction("cast(INTEGER'17' as varchar)", (Type)VarcharType.VARCHAR, "17");
    }

    @Test
    public void testCastToDouble() {
        this.assertFunction("cast(INTEGER'37' as double)", (Type)DoubleType.DOUBLE, 37.0);
        this.assertFunction("cast(INTEGER'17' as double)", (Type)DoubleType.DOUBLE, 17.0);
    }

    @Test
    public void testCastToFloat() {
        this.assertFunction("cast(INTEGER'37' as real)", (Type)RealType.REAL, Float.valueOf(37.0f));
        this.assertFunction("cast(INTEGER'-2147483648' as real)", (Type)RealType.REAL, Float.valueOf(-2.1474836E9f));
        this.assertFunction("cast(INTEGER'0' as real)", (Type)RealType.REAL, Float.valueOf(0.0f));
    }

    @Test
    public void testCastToBoolean() {
        this.assertFunction("cast(INTEGER'37' as boolean)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(INTEGER'17' as boolean)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("cast(INTEGER'0' as boolean)", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCastFromVarchar() {
        this.assertFunction("cast('37' as integer)", (Type)IntegerType.INTEGER, 37);
        this.assertFunction("cast('17' as integer)", (Type)IntegerType.INTEGER, 17);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("CAST(NULL AS INTEGER) IS DISTINCT FROM CAST(NULL AS INTEGER)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37 IS DISTINCT FROM 37", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("37 IS DISTINCT FROM 38", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("NULL IS DISTINCT FROM 37", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("37 IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as integer)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "12", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "0", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "-23", (Type)BooleanType.BOOLEAN, false);
        this.assertOperator(OperatorType.INDETERMINATE, "cast(1.4 as integer)", (Type)BooleanType.BOOLEAN, false);
    }
}

