/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.AbstractTestType;
import com.facebook.presto.type.IpAddressType;
import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestIpAddressType
extends AbstractTestType {
    public TestIpAddressType() {
        super((Type)IpAddressType.IPADDRESS, String.class, TestIpAddressType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = IpAddressType.IPADDRESS.createBlockBuilder(null, 1);
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8320"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8321"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8322"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8323"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8324"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8325"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8326"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8327"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8328"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8329"));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        byte[] address = ((Slice)value).getBytes();
        int n = address.length - 1;
        byte by = (byte)(address[n] + 1);
        address[n] = by;
        Preconditions.checkState((by != 0 ? 1 : 0) != 0, (Object)"Last byte of address is 0xff");
        return Slices.wrappedBuffer((byte[])address);
    }

    @Override
    protected Object getNonNullValue() {
        return Slices.wrappedBuffer((byte[])InetAddresses.forString((String)"::").getAddress());
    }

    @Test
    public void testDisplayName() {
        Assert.assertEquals((String)IpAddressType.IPADDRESS.getDisplayName(), (String)"ipaddress");
    }

    private static Slice getSliceForAddress(String address) {
        return Slices.wrappedBuffer((byte[])InetAddresses.forString((String)address).getAddress());
    }
}

