/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.IntArrayBlockBuilder;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.AbstractTestType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRealType
extends AbstractTestType {
    public TestRealType() {
        super((Type)RealType.REAL, Float.class, TestRealType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = RealType.REAL.createBlockBuilder(null, 30);
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(11.11f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(11.11f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(11.11f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(33.33f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(33.33f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(44.44f));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        int bits = ((Long)value).intValue();
        float greaterValue = Float.intBitsToFloat(bits) + 0.1f;
        return (long)Float.floatToRawIntBits(greaterValue);
    }

    @Test
    public void testNaNHash() {
        IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(null, 4);
        blockBuilder.writeInt(Float.floatToIntBits(Float.NaN));
        blockBuilder.writeInt(Float.floatToRawIntBits(Float.NaN));
        blockBuilder.writeInt(-4194304);
        blockBuilder.writeInt(2143289344);
        Assert.assertEquals((long)RealType.REAL.hash((Block)blockBuilder, 0), (long)RealType.REAL.hash((Block)blockBuilder, 1));
        Assert.assertEquals((long)RealType.REAL.hash((Block)blockBuilder, 0), (long)RealType.REAL.hash((Block)blockBuilder, 2));
        Assert.assertEquals((long)RealType.REAL.hash((Block)blockBuilder, 0), (long)RealType.REAL.hash((Block)blockBuilder, 3));
    }
}

