/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.RowBlockBuilder;
import com.facebook.presto.spi.block.SingleRowBlockWriter;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.AbstractTestType;
import com.facebook.presto.type.TypeRegistry;
import io.airlift.slice.Slices;
import java.util.List;

public class TestSimpleRowType
extends AbstractTestType {
    private static final Type TYPE = new TypeRegistry().getType(TypeSignature.parseTypeSignature((String)"row(a bigint,b varchar)"));

    public TestSimpleRowType() {
        super(TYPE, List.class, TestSimpleRowType.createTestBlock());
    }

    private static Block createTestBlock() {
        RowBlockBuilder blockBuilder = (RowBlockBuilder)TYPE.createBlockBuilder(null, 3);
        SingleRowBlockWriter singleRowBlockWriter = blockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong((BlockBuilder)singleRowBlockWriter, 1L);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)singleRowBlockWriter, Slices.utf8Slice((String)"cat"));
        blockBuilder.closeEntry();
        singleRowBlockWriter = blockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong((BlockBuilder)singleRowBlockWriter, 2L);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)singleRowBlockWriter, Slices.utf8Slice((String)"cats"));
        blockBuilder.closeEntry();
        singleRowBlockWriter = blockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong((BlockBuilder)singleRowBlockWriter, 3L);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)singleRowBlockWriter, Slices.utf8Slice((String)"dog"));
        blockBuilder.closeEntry();
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        RowBlockBuilder blockBuilder = (RowBlockBuilder)TYPE.createBlockBuilder(null, 1);
        Block block = (Block)value;
        SingleRowBlockWriter singleRowBlockWriter = blockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong((BlockBuilder)singleRowBlockWriter, block.getSingleValueBlock(0).getLong(0, 0) + 1L);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)singleRowBlockWriter, block.getSingleValueBlock(1).getSlice(0, 0, 1));
        blockBuilder.closeEntry();
        return TYPE.getObject(blockBuilder.build(), 0);
    }
}

