/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.type.JoniRegexpType;
import com.facebook.presto.type.JsonPathType;
import com.facebook.presto.type.LikePatternType;
import com.facebook.presto.type.Re2JRegexpType;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypeRegistry {
    private final TypeManager typeRegistry = new TypeRegistry();
    private final FunctionRegistry functionRegistry = new FunctionRegistry(this.typeRegistry, (BlockEncodingSerde)new BlockEncodingManager(this.typeRegistry, new BlockEncoding[0]), new FeaturesConfig());

    @Test
    public void testNonexistentType() {
        try {
            TypeRegistry typeManager = new TypeRegistry();
            typeManager.getType(TypeSignature.parseTypeSignature((String)"not a real type"));
            Assert.fail((String)"Expect to throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().matches("Unknown type.*"));
        }
        catch (Throwable t) {
            Assert.fail((String)("Expect to throw IllegalArgumentException, got " + t.getClass()));
        }
    }

    @Test
    public void testIsTypeOnlyCoercion() {
        Assert.assertTrue((boolean)this.isTypeOnlyCoercion((Type)BigintType.BIGINT, (Type)BigintType.BIGINT));
        Assert.assertTrue((boolean)this.isTypeOnlyCoercion("varchar(42)", "varchar(44)"));
        Assert.assertFalse((boolean)this.isTypeOnlyCoercion("varchar(44)", "varchar(42)"));
        Assert.assertFalse((boolean)this.isTypeOnlyCoercion("char(42)", "varchar(42)"));
        Assert.assertTrue((boolean)this.isTypeOnlyCoercion("array(varchar(42))", "array(varchar(44))"));
        Assert.assertFalse((boolean)this.isTypeOnlyCoercion("array(varchar(44))", "array(varchar(42))"));
        Assert.assertTrue((boolean)this.isTypeOnlyCoercion("decimal(22,1)", "decimal(23,1)"));
        Assert.assertTrue((boolean)this.isTypeOnlyCoercion("decimal(2,1)", "decimal(3,1)"));
        Assert.assertFalse((boolean)this.isTypeOnlyCoercion("decimal(23,1)", "decimal(22,1)"));
        Assert.assertFalse((boolean)this.isTypeOnlyCoercion("decimal(3,1)", "decimal(2,1)"));
        Assert.assertFalse((boolean)this.isTypeOnlyCoercion("decimal(3,1)", "decimal(22,1)"));
        Assert.assertTrue((boolean)this.isTypeOnlyCoercion("array(decimal(22,1))", "array(decimal(23,1))"));
        Assert.assertTrue((boolean)this.isTypeOnlyCoercion("array(decimal(2,1))", "array(decimal(3,1))"));
        Assert.assertFalse((boolean)this.isTypeOnlyCoercion("array(decimal(23,1))", "array(decimal(22,1))"));
        Assert.assertFalse((boolean)this.isTypeOnlyCoercion("array(decimal(3,1))", "array(decimal(2,1))"));
        Assert.assertTrue((boolean)this.isTypeOnlyCoercion("map(decimal(2,1), decimal(2,1))", "map(decimal(2,1), decimal(3,1))"));
        Assert.assertFalse((boolean)this.isTypeOnlyCoercion("map(decimal(2,1), decimal(2,1))", "map(decimal(2,1), decimal(23,1))"));
        Assert.assertFalse((boolean)this.isTypeOnlyCoercion("map(decimal(2,1), decimal(2,1))", "map(decimal(2,1), decimal(3,2))"));
        Assert.assertTrue((boolean)this.isTypeOnlyCoercion("map(decimal(22,1), decimal(2,1))", "map(decimal(23,1), decimal(3,1))"));
        Assert.assertFalse((boolean)this.isTypeOnlyCoercion("map(decimal(23,1), decimal(3,1))", "map(decimal(22,1), decimal(2,1))"));
    }

    @Test
    public void testTypeCompatibility() {
        this.assertThat((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN).hasCommonSuperType((Type)UnknownType.UNKNOWN).canCoerceToEachOther();
        this.assertThat((Type)BigintType.BIGINT, (Type)BigintType.BIGINT).hasCommonSuperType((Type)BigintType.BIGINT).canCoerceToEachOther();
        this.assertThat((Type)UnknownType.UNKNOWN, (Type)BigintType.BIGINT).hasCommonSuperType((Type)BigintType.BIGINT).canCoerceFirstToSecondOnly();
        this.assertThat((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DateType.DATE, (Type)TimestampType.TIMESTAMP).hasCommonSuperType((Type)TimestampType.TIMESTAMP).canCoerceFirstToSecondOnly();
        this.assertThat((Type)DateType.DATE, (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE).hasCommonSuperType((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)TimeType.TIME, (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE).hasCommonSuperType((Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)TimestampType.TIMESTAMP, (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE).hasCommonSuperType((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)VarcharType.VARCHAR, (Type)JoniRegexpType.JONI_REGEXP).hasCommonSuperType((Type)JoniRegexpType.JONI_REGEXP).canCoerceFirstToSecondOnly();
        this.assertThat((Type)VarcharType.VARCHAR, (Type)Re2JRegexpType.RE2J_REGEXP).hasCommonSuperType((Type)Re2JRegexpType.RE2J_REGEXP).canCoerceFirstToSecondOnly();
        this.assertThat((Type)VarcharType.VARCHAR, (Type)LikePatternType.LIKE_PATTERN).hasCommonSuperType((Type)LikePatternType.LIKE_PATTERN).canCoerceFirstToSecondOnly();
        this.assertThat((Type)VarcharType.VARCHAR, (Type)JsonPathType.JSON_PATH).hasCommonSuperType((Type)JsonPathType.JSON_PATH).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RealType.REAL, (Type)DoubleType.DOUBLE).hasCommonSuperType((Type)DoubleType.DOUBLE).canCoerceFirstToSecondOnly();
        this.assertThat((Type)RealType.REAL, (Type)TinyintType.TINYINT).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)RealType.REAL, (Type)SmallintType.SMALLINT).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)RealType.REAL, (Type)IntegerType.INTEGER).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)RealType.REAL, (Type)BigintType.BIGINT).hasCommonSuperType((Type)RealType.REAL).canCoerceSecondToFirstOnly();
        this.assertThat((Type)TimestampType.TIMESTAMP, (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE).isIncompatible();
        this.assertThat((Type)VarbinaryType.VARBINARY, (Type)VarcharType.VARCHAR).isIncompatible();
        this.assertThat("unknown", "array(bigint)").hasCommonSuperType("array(bigint)").canCoerceFirstToSecondOnly();
        this.assertThat("array(bigint)", "array(double)").hasCommonSuperType("array(double)").canCoerceFirstToSecondOnly();
        this.assertThat("array(bigint)", "array(unknown)").hasCommonSuperType("array(bigint)").canCoerceSecondToFirstOnly();
        this.assertThat("map(bigint,double)", "map(bigint,double)").hasCommonSuperType("map(bigint,double)").canCoerceToEachOther();
        this.assertThat("map(bigint,double)", "map(double,double)").hasCommonSuperType("map(double,double)").canCoerceFirstToSecondOnly();
        this.assertThat("row(a bigint,b double,c varchar)", "row(a bigint,b double,c varchar)").hasCommonSuperType("row(a bigint,b double,c varchar)").canCoerceToEachOther();
        this.assertThat("decimal(22,1)", "decimal(23,1)").hasCommonSuperType("decimal(23,1)").canCoerceFirstToSecondOnly();
        this.assertThat("bigint", "decimal(23,1)").hasCommonSuperType("decimal(23,1)").canCoerceFirstToSecondOnly();
        this.assertThat("bigint", "decimal(18,0)").hasCommonSuperType("decimal(19,0)").cannotCoerceToEachOther();
        this.assertThat("bigint", "decimal(19,0)").hasCommonSuperType("decimal(19,0)").canCoerceFirstToSecondOnly();
        this.assertThat("bigint", "decimal(37,1)").hasCommonSuperType("decimal(37,1)").canCoerceFirstToSecondOnly();
        this.assertThat("real", "decimal(37,1)").hasCommonSuperType("real").canCoerceSecondToFirstOnly();
        this.assertThat("array(decimal(23,1))", "array(decimal(22,1))").hasCommonSuperType("array(decimal(23,1))").canCoerceSecondToFirstOnly();
        this.assertThat("array(bigint)", "array(decimal(2,1))").hasCommonSuperType("array(decimal(20,1))").cannotCoerceToEachOther();
        this.assertThat("array(bigint)", "array(decimal(20,1))").hasCommonSuperType("array(decimal(20,1))").canCoerceFirstToSecondOnly();
        this.assertThat("decimal(3,2)", "double").hasCommonSuperType("double").canCoerceFirstToSecondOnly();
        this.assertThat("decimal(22,1)", "double").hasCommonSuperType("double").canCoerceFirstToSecondOnly();
        this.assertThat("decimal(37,1)", "double").hasCommonSuperType("double").canCoerceFirstToSecondOnly();
        this.assertThat("decimal(37,37)", "double").hasCommonSuperType("double").canCoerceFirstToSecondOnly();
        this.assertThat("decimal(22,1)", "real").hasCommonSuperType("real").canCoerceFirstToSecondOnly();
        this.assertThat("decimal(3,2)", "real").hasCommonSuperType("real").canCoerceFirstToSecondOnly();
        this.assertThat("decimal(37,37)", "real").hasCommonSuperType("real").canCoerceFirstToSecondOnly();
        this.assertThat("integer", "decimal(23,1)").hasCommonSuperType("decimal(23,1)").canCoerceFirstToSecondOnly();
        this.assertThat("integer", "decimal(9,0)").hasCommonSuperType("decimal(10,0)").cannotCoerceToEachOther();
        this.assertThat("integer", "decimal(10,0)").hasCommonSuperType("decimal(10,0)").canCoerceFirstToSecondOnly();
        this.assertThat("integer", "decimal(37,1)").hasCommonSuperType("decimal(37,1)").canCoerceFirstToSecondOnly();
        this.assertThat("tinyint", "decimal(2,0)").hasCommonSuperType("decimal(3,0)").cannotCoerceToEachOther();
        this.assertThat("tinyint", "decimal(9,0)").hasCommonSuperType("decimal(9,0)").canCoerceFirstToSecondOnly();
        this.assertThat("tinyint", "decimal(2,1)").hasCommonSuperType("decimal(4,1)").cannotCoerceToEachOther();
        this.assertThat("tinyint", "decimal(3,0)").hasCommonSuperType("decimal(3,0)").canCoerceFirstToSecondOnly();
        this.assertThat("tinyint", "decimal(37,1)").hasCommonSuperType("decimal(37,1)").canCoerceFirstToSecondOnly();
        this.assertThat("smallint", "decimal(37,1)").hasCommonSuperType("decimal(37,1)").canCoerceFirstToSecondOnly();
        this.assertThat("smallint", "decimal(4,0)").hasCommonSuperType("decimal(5,0)").cannotCoerceToEachOther();
        this.assertThat("smallint", "decimal(5,0)").hasCommonSuperType("decimal(5,0)").canCoerceFirstToSecondOnly();
        this.assertThat("smallint", "decimal(2,0)").hasCommonSuperType("decimal(5,0)").cannotCoerceToEachOther();
        this.assertThat("smallint", "decimal(9,0)").hasCommonSuperType("decimal(9,0)").canCoerceFirstToSecondOnly();
        this.assertThat("smallint", "decimal(2,1)").hasCommonSuperType("decimal(6,1)").cannotCoerceToEachOther();
        this.assertThat("char(42)", "char(40)").hasCommonSuperType("char(42)").canCoerceSecondToFirstOnly();
        this.assertThat("char(42)", "char(44)").hasCommonSuperType("char(44)").canCoerceFirstToSecondOnly();
        this.assertThat("varchar(42)", "varchar(42)").hasCommonSuperType("varchar(42)").canCoerceToEachOther();
        this.assertThat("varchar(42)", "varchar(44)").hasCommonSuperType("varchar(44)").canCoerceFirstToSecondOnly();
        this.assertThat("char(40)", "varchar(42)").hasCommonSuperType("char(42)").cannotCoerceToEachOther();
        this.assertThat("char(42)", "varchar(42)").hasCommonSuperType("char(42)").canCoerceSecondToFirstOnly();
        this.assertThat("char(44)", "varchar(42)").hasCommonSuperType("char(44)").canCoerceSecondToFirstOnly();
        this.assertThat(this.createType("char(42)"), (Type)JoniRegexpType.JONI_REGEXP).hasCommonSuperType((Type)JoniRegexpType.JONI_REGEXP).canCoerceFirstToSecondOnly();
        this.assertThat(this.createType("char(42)"), (Type)JsonPathType.JSON_PATH).hasCommonSuperType((Type)JsonPathType.JSON_PATH).canCoerceFirstToSecondOnly();
        this.assertThat(this.createType("char(42)"), (Type)LikePatternType.LIKE_PATTERN).hasCommonSuperType((Type)LikePatternType.LIKE_PATTERN).canCoerceFirstToSecondOnly();
        this.assertThat(this.createType("char(42)"), (Type)Re2JRegexpType.RE2J_REGEXP).hasCommonSuperType((Type)Re2JRegexpType.RE2J_REGEXP).canCoerceFirstToSecondOnly();
        this.assertThat("row(varchar(2))", "row(varchar(5))").hasCommonSuperType("row(varchar(5))").canCoerceFirstToSecondOnly();
        this.assertThat("row(a integer)", "row(a bigint)").hasCommonSuperType("row(a bigint)").canCoerceFirstToSecondOnly();
        this.assertThat("row(a integer)", "row(b bigint)").hasCommonSuperType("row(bigint)").canCoerceFirstToSecondOnly();
        this.assertThat("row(integer)", "row(b bigint)").hasCommonSuperType("row(bigint)").canCoerceFirstToSecondOnly();
        this.assertThat("row(a integer)", "row(a varchar(2))").isIncompatible();
        this.assertThat("row(a integer)", "row(a integer,b varchar(2))").isIncompatible();
        this.assertThat("row(a integer,b varchar(2))", "row(a bigint,c varchar(5))").hasCommonSuperType("row(a bigint,varchar(5))").canCoerceFirstToSecondOnly();
        this.assertThat("row(a integer,b varchar(2))", "row(bigint,varchar(5))").hasCommonSuperType("row(bigint,varchar(5))").canCoerceFirstToSecondOnly();
        this.assertThat("row(a integer,b varchar(5))", "row(c bigint,d varchar(2))").hasCommonSuperType("row(bigint,varchar(5))").cannotCoerceToEachOther();
        this.assertThat("row(a row(c integer),b varchar(2))", "row(row(c integer),varchar(5))").hasCommonSuperType("row(row(c integer),varchar(5))").canCoerceFirstToSecondOnly();
        this.assertThat("row(a row(c integer),b varchar(2))", "row(a row(c integer),d varchar(5))").hasCommonSuperType("row(a row(c integer),varchar(5))").canCoerceFirstToSecondOnly();
        this.assertThat("row(a row(c integer),b varchar(5))", "row(d row(e integer),b varchar(5))").hasCommonSuperType("row(row(integer),b varchar(5))").canCoerceToEachOther();
    }

    @Test
    public void testCoerceTypeBase() {
        Assert.assertEquals((Object)this.typeRegistry.coerceTypeBase((Type)DecimalType.createDecimalType((int)21, (int)1), "decimal"), Optional.of(DecimalType.createDecimalType((int)21, (int)1)));
        Assert.assertEquals((Object)this.typeRegistry.coerceTypeBase((Type)BigintType.BIGINT, "decimal"), Optional.of(DecimalType.createDecimalType((int)19, (int)0)));
        Assert.assertEquals((Object)this.typeRegistry.coerceTypeBase((Type)IntegerType.INTEGER, "decimal"), Optional.of(DecimalType.createDecimalType((int)10, (int)0)));
        Assert.assertEquals((Object)this.typeRegistry.coerceTypeBase((Type)TinyintType.TINYINT, "decimal"), Optional.of(DecimalType.createDecimalType((int)3, (int)0)));
        Assert.assertEquals((Object)this.typeRegistry.coerceTypeBase((Type)SmallintType.SMALLINT, "decimal"), Optional.of(DecimalType.createDecimalType((int)5, (int)0)));
    }

    @Test
    public void testCanCoerceIsTransitive() {
        Set<Type> types = this.getStandardPrimitiveTypes();
        for (Type transitiveType : types) {
            for (Type resultType : types) {
                if (!this.typeRegistry.canCoerce(transitiveType, resultType)) continue;
                for (Type sourceType : types) {
                    if (!this.typeRegistry.canCoerce(sourceType, transitiveType) || this.typeRegistry.canCoerce(sourceType, resultType)) continue;
                    Assert.fail((String)String.format("'%s' -> '%s' coercion is missing when transitive coercion is possible: '%s' -> '%s' -> '%s'", sourceType, resultType, sourceType, transitiveType, resultType));
                }
            }
        }
    }

    @Test
    public void testCastOperatorsExistForCoercions() {
        Set<Type> types = this.getStandardPrimitiveTypes();
        for (Type sourceType : types) {
            for (Type resultType : types) {
                if (!this.typeRegistry.canCoerce(sourceType, resultType) || sourceType == UnknownType.UNKNOWN || resultType == UnknownType.UNKNOWN) continue;
                Assert.assertTrue((boolean)this.functionRegistry.canResolveOperator(OperatorType.CAST, resultType, (List)ImmutableList.of((Object)sourceType)), (String)String.format("'%s' -> '%s' coercion exists but there is no cast operator", sourceType, resultType));
            }
        }
    }

    @Test
    public void testOperatorsImplemented() {
        for (Type type : this.typeRegistry.getTypes()) {
            if (type.isComparable()) {
                this.functionRegistry.resolveOperator(OperatorType.EQUAL, (List)ImmutableList.of((Object)type, (Object)type));
                this.functionRegistry.resolveOperator(OperatorType.NOT_EQUAL, (List)ImmutableList.of((Object)type, (Object)type));
                this.functionRegistry.resolveOperator(OperatorType.IS_DISTINCT_FROM, (List)ImmutableList.of((Object)type, (Object)type));
                this.functionRegistry.resolveOperator(OperatorType.HASH_CODE, (List)ImmutableList.of((Object)type));
            }
            if (!type.isOrderable()) continue;
            this.functionRegistry.resolveOperator(OperatorType.LESS_THAN, (List)ImmutableList.of((Object)type, (Object)type));
            this.functionRegistry.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List)ImmutableList.of((Object)type, (Object)type));
            this.functionRegistry.resolveOperator(OperatorType.GREATER_THAN_OR_EQUAL, (List)ImmutableList.of((Object)type, (Object)type));
            this.functionRegistry.resolveOperator(OperatorType.GREATER_THAN, (List)ImmutableList.of((Object)type, (Object)type));
        }
    }

    @Test
    public void testRowTypeCreation() {
        this.createType("row(time with time zone,time time with time zone)");
        this.createType("row(timestamp with time zone,\"timestamp\" timestamp with time zone)");
        this.createType("row(interval day to second,interval interval day to second)");
        this.createType("row(interval year to month,\"interval\" interval year to month)");
        this.createType("row(array(time with time zone),    \"a\" array(map(timestamp with time zone, interval day to second)))");
    }

    private Set<Type> getStandardPrimitiveTypes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)this.typeRegistry.getTypes());
        builder.add((Object)DecimalType.createDecimalType((int)1, (int)0));
        builder.add((Object)DecimalType.createDecimalType((int)17, (int)0));
        builder.add((Object)DecimalType.createDecimalType((int)38, (int)0));
        builder.add((Object)DecimalType.createDecimalType((int)17, (int)17));
        builder.add((Object)DecimalType.createDecimalType((int)38, (int)38));
        builder.add((Object)VarcharType.createVarcharType((int)0));
        builder.add((Object)VarcharType.createUnboundedVarcharType());
        builder.add((Object)CharType.createCharType((long)0L));
        builder.add((Object)CharType.createCharType((long)42L));
        return builder.build();
    }

    private CompatibilityAssertion assertThat(Type firstType, Type secondType) {
        Optional commonSuperType1 = this.typeRegistry.getCommonSuperType(firstType, secondType);
        Optional commonSuperType2 = this.typeRegistry.getCommonSuperType(secondType, firstType);
        Assert.assertEquals((Object)commonSuperType1, (Object)commonSuperType2, (String)"Expected getCommonSuperType to return the same result when invoked in either order");
        boolean canCoerceFirstToSecond = this.typeRegistry.canCoerce(firstType, secondType);
        boolean canCoerceSecondToFirst = this.typeRegistry.canCoerce(secondType, firstType);
        return new CompatibilityAssertion(commonSuperType1, canCoerceFirstToSecond, canCoerceSecondToFirst);
    }

    private CompatibilityAssertion assertThat(String firstType, String secondType) {
        return this.assertThat(this.createType(firstType), this.createType(secondType));
    }

    private boolean isTypeOnlyCoercion(Type actual, Type expected) {
        return this.typeRegistry.isTypeOnlyCoercion(actual, expected);
    }

    private boolean isTypeOnlyCoercion(String actual, String expected) {
        return this.typeRegistry.isTypeOnlyCoercion(this.createType(actual), this.createType(expected));
    }

    private Type createType(String signature) {
        return this.typeRegistry.getType(TypeSignature.parseTypeSignature((String)signature));
    }

    private class CompatibilityAssertion {
        private final Optional<Type> commonSuperType;
        private final boolean canCoerceFirstToSecond;
        private final boolean canCoerceSecondToFirst;

        public CompatibilityAssertion(Optional<Type> commonSuperType, boolean canCoerceFirstToSecond, boolean canCoerceSecondToFirst) {
            this.commonSuperType = Objects.requireNonNull(commonSuperType, "commonSuperType is null");
            Assert.assertTrue((!canCoerceFirstToSecond && !canCoerceSecondToFirst || commonSuperType.isPresent() ? 1 : 0) != 0, (String)"Expected canCoercion to be false when there is no commonSuperType");
            this.canCoerceFirstToSecond = canCoerceFirstToSecond;
            this.canCoerceSecondToFirst = canCoerceSecondToFirst;
        }

        public void isIncompatible() {
            Assert.assertTrue((!this.commonSuperType.isPresent() ? 1 : 0) != 0, (String)"Expected to be incompatible");
        }

        public CompatibilityAssertion hasCommonSuperType(Type expected) {
            Assert.assertTrue((boolean)this.commonSuperType.isPresent(), (String)"Expected commonSuperType to be present");
            Assert.assertEquals((Object)this.commonSuperType.get(), (Object)expected, (String)"commonSuperType");
            return this;
        }

        public CompatibilityAssertion hasCommonSuperType(String expected) {
            return this.hasCommonSuperType(TestTypeRegistry.this.createType(expected));
        }

        public CompatibilityAssertion canCoerceToEachOther() {
            Assert.assertTrue((boolean)this.canCoerceFirstToSecond, (String)"Expected first be coercible to second");
            Assert.assertTrue((boolean)this.canCoerceSecondToFirst, (String)"Expected second be coercible to first");
            return this;
        }

        public CompatibilityAssertion canCoerceFirstToSecondOnly() {
            Assert.assertTrue((boolean)this.canCoerceFirstToSecond, (String)"Expected first be coercible to second");
            Assert.assertFalse((boolean)this.canCoerceSecondToFirst, (String)"Expected second NOT be coercible to first");
            return this;
        }

        public CompatibilityAssertion canCoerceSecondToFirstOnly() {
            Assert.assertFalse((boolean)this.canCoerceFirstToSecond, (String)"Expected first NOT be coercible to second");
            Assert.assertTrue((boolean)this.canCoerceSecondToFirst, (String)"Expected second be coercible to first");
            return this;
        }

        public CompatibilityAssertion cannotCoerceToEachOther() {
            Assert.assertFalse((boolean)this.canCoerceFirstToSecond, (String)"Expected first NOT be coercible to second");
            Assert.assertFalse((boolean)this.canCoerceSecondToFirst, (String)"Expected second NOT be coercible to first");
            return this;
        }
    }
}

