/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.setdigest;

import com.facebook.presto.type.setdigest.SetDigest;
import com.facebook.presto.type.setdigest.SetDigestFunctions;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSetDigest {
    @Test
    public void testIntersectionCardinality() throws Exception {
        TestSetDigest.testIntersectionCardinality(8192, 2048, 8192, 2048);
    }

    @Test
    public void testUnevenIntersectionCardinality() throws Exception {
        TestSetDigest.testIntersectionCardinality(2048, 2048, 8192, 2048);
    }

    private static void testIntersectionCardinality(int maxHashes1, int numBuckets1, int maxHashes2, int numBuckets2) throws Exception {
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        Random rand = new Random(0L);
        for (int i = 10; i < 100000000; i *= 10) {
            sizes.add(rand.nextInt(i) + 10);
        }
        Iterator iterator = sizes.iterator();
        while (iterator.hasNext()) {
            int size = (Integer)iterator.next();
            int expectedCardinality = 0;
            SetDigest digest1 = new SetDigest(maxHashes1, numBuckets1);
            SetDigest digest2 = new SetDigest(maxHashes2, numBuckets2);
            for (int j = 0; j < size; ++j) {
                int added = 0;
                long value = rand.nextLong();
                if (rand.nextDouble() < 0.5) {
                    digest1.add(value);
                    ++added;
                }
                if (rand.nextDouble() < 0.5) {
                    digest2.add(value);
                    ++added;
                }
                if (added != 2) continue;
                ++expectedCardinality;
            }
            long estimatedCardinality = SetDigestFunctions.intersectionCardinality((Slice)digest1.serialize(), (Slice)digest2.serialize());
            Assert.assertTrue(((double)Math.abs((long)expectedCardinality - estimatedCardinality) / (double)expectedCardinality < 0.1 ? 1 : 0) != 0, (String)String.format("Expected intersection cardinality %d +/- 10%%, got %d, for set of size %d", expectedCardinality, estimatedCardinality, size));
        }
    }

    @Test
    public void testHashCounts() throws Exception {
        SetDigest digest1 = new SetDigest();
        digest1.add(0L);
        digest1.add(0L);
        digest1.add(1L);
        SetDigest digest2 = new SetDigest();
        digest2.add(0L);
        digest2.add(0L);
        digest2.add(2L);
        digest2.add(2L);
        ObjectMapper mapper = new ObjectMapperProvider().get();
        Slice slice = SetDigestFunctions.hashCounts((Slice)digest1.serialize());
        Map counts = (Map)mapper.readValue(slice.toStringUtf8(), (TypeReference)new TypeReference<Map<Long, Short>>(){});
        ImmutableSet expected = ImmutableSet.of((Object)1, (Object)2);
        Assert.assertEquals(counts.values(), (Collection)expected);
        digest1.mergeWith(digest2);
        slice = SetDigestFunctions.hashCounts((Slice)digest1.serialize());
        counts = (Map)mapper.readValue(slice.toStringUtf8(), (TypeReference)new TypeReference<Map<Long, Short>>(){});
        expected = ImmutableSet.of((Object)1, (Object)2, (Object)4);
        Assert.assertEquals((Set)ImmutableSet.copyOf(counts.values()), (Set)expected);
    }

    @Test
    public void testSmallLargeIntersections() {
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        Random rand = new Random(0L);
        for (int i = 1000; i < 1000000; i *= 10) {
            sizes.add(rand.nextInt(i) + 10);
        }
        Iterator iterator = sizes.iterator();
        while (iterator.hasNext()) {
            int n;
            int size1 = (Integer)iterator.next();
            SetDigest digest1 = new SetDigest(8192, 2048);
            HashMap<SetDigest, Integer> smallerSets = new HashMap<SetDigest, Integer>();
            Iterator<Object> iterator2 = sizes.iterator();
            while (iterator2.hasNext() && (n = ((Integer)iterator2.next()).intValue()) < size1) {
                for (int overlap = 2; overlap <= 10; overlap += 2) {
                    int expectedCardinality = 0;
                    SetDigest digest2 = new SetDigest(8192, 2048);
                    for (int j = 0; j < size1; ++j) {
                        long value = rand.nextLong();
                        digest1.add(value);
                        if (!(rand.nextDouble() < (double)n / (double)size1)) continue;
                        if (rand.nextDouble() * 10.0 < (double)overlap) {
                            digest2.add(value);
                            ++expectedCardinality;
                            continue;
                        }
                        digest2.add(rand.nextLong());
                    }
                    smallerSets.put(digest2, expectedCardinality);
                }
            }
            for (Map.Entry entry : smallerSets.entrySet()) {
                double size22;
                SetDigest digest2 = (SetDigest)entry.getKey();
                long estIntersectionCardinality = SetDigestFunctions.intersectionCardinality((Slice)digest1.serialize(), (Slice)digest2.serialize());
                Assert.assertTrue(((double)estIntersectionCardinality <= (size22 = (double)digest2.cardinality()) ? 1 : 0) != 0);
                int expectedCardinality = (Integer)entry.getValue();
                Assert.assertTrue(((double)Math.abs((long)expectedCardinality - estIntersectionCardinality) / (double)size1 < 0.05 ? 1 : 0) != 0);
            }
        }
    }
}

