/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.util.MockPowerOfTwo;
import com.facebook.presto.util.PowerOfTwo;
import com.facebook.presto.util.PowerOfTwoValidator;
import io.airlift.testing.Assertions;
import java.util.Set;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.bval.jsr.ApacheValidationProvider;
import org.apache.bval.jsr.ApacheValidatorConfiguration;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPowerOfTwoValidator {
    private static final Validator VALIDATOR = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator();

    @Test
    public void testValidator() {
        PowerOfTwoValidator validator = new PowerOfTwoValidator();
        validator.initialize((PowerOfTwo)new MockPowerOfTwo());
        Assert.assertTrue((boolean)validator.isValid(Integer.valueOf(1), (ConstraintValidatorContext)new MockContext()));
        Assert.assertTrue((boolean)validator.isValid(Integer.valueOf(2), (ConstraintValidatorContext)new MockContext()));
        Assert.assertTrue((boolean)validator.isValid(Integer.valueOf(64), (ConstraintValidatorContext)new MockContext()));
        Assert.assertFalse((boolean)validator.isValid(Integer.valueOf(0), (ConstraintValidatorContext)new MockContext()));
        Assert.assertFalse((boolean)validator.isValid(Integer.valueOf(3), (ConstraintValidatorContext)new MockContext()));
        Assert.assertFalse((boolean)validator.isValid(Integer.valueOf(99), (ConstraintValidatorContext)new MockContext()));
        Assert.assertFalse((boolean)validator.isValid(Integer.valueOf(-1), (ConstraintValidatorContext)new MockContext()));
        Assert.assertFalse((boolean)validator.isValid(Integer.valueOf(-2), (ConstraintValidatorContext)new MockContext()));
        Assert.assertFalse((boolean)validator.isValid(Integer.valueOf(-4), (ConstraintValidatorContext)new MockContext()));
    }

    @Test
    public void testAllowsNullPowerOfTwoAnnotation() {
        VALIDATOR.validate((Object)new NullPowerOfTwoAnnotation(), new Class[0]);
    }

    @Test
    public void testPassesValidation() {
        ConstrainedPowerOfTwo object = new ConstrainedPowerOfTwo(128);
        Set violations = VALIDATOR.validate((Object)object, new Class[0]);
        Assert.assertTrue((boolean)violations.isEmpty());
    }

    @Test
    public void testFailsValidation() {
        ConstrainedPowerOfTwo object = new ConstrainedPowerOfTwo(11);
        Set violations = VALIDATOR.validate((Object)object, new Class[0]);
        Assert.assertEquals((int)violations.size(), (int)2);
        for (ConstraintViolation violation : violations) {
            Assertions.assertInstanceOf((Object)violation.getConstraintDescriptor().getAnnotation(), PowerOfTwo.class);
        }
    }

    public static class NullPowerOfTwoAnnotation {
        @PowerOfTwo
        public static Integer getConstrainedByPowerOfTwo() {
            return null;
        }
    }

    public static class ConstrainedPowerOfTwo {
        private final int value;

        public ConstrainedPowerOfTwo(int value) {
            this.value = value;
        }

        @PowerOfTwo
        public int getConstrainedByPowerOfTwoUnboxed() {
            return this.value;
        }

        @PowerOfTwo
        public Integer getConstrainedByPowerOfTwoBoxed() {
            return this.value;
        }
    }

    private static class MockContext
    implements ConstraintValidatorContext {
        private MockContext() {
        }

        public void disableDefaultConstraintViolation() {
            throw new UnsupportedOperationException();
        }

        public String getDefaultConstraintMessageTemplate() {
            throw new UnsupportedOperationException();
        }

        public ConstraintValidatorContext.ConstraintViolationBuilder buildConstraintViolationWithTemplate(String s) {
            throw new UnsupportedOperationException();
        }

        public <T> T unwrap(Class<T> type) {
            throw new UnsupportedOperationException();
        }
    }
}

