/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.config;

import java.lang.reflect.Type;
import java.util.function.Consumer;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.array.SqlArrayArgumentStrategy;
import org.jdbi.v3.core.array.SqlArrayType;
import org.jdbi.v3.core.array.SqlArrayTypeFactory;
import org.jdbi.v3.core.array.SqlArrayTypes;
import org.jdbi.v3.core.collector.CollectorFactory;
import org.jdbi.v3.core.collector.JdbiCollectors;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.ColumnMappers;
import org.jdbi.v3.core.mapper.MapEntryMappers;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.core.statement.TimingCollector;

public interface Configurable<This> {
    public ConfigRegistry getConfig();

    default public <C extends JdbiConfig<C>> C getConfig(Class<C> configClass) {
        return this.getConfig().get(configClass);
    }

    default public <C extends JdbiConfig<C>> This configure(Class<C> configClass, Consumer<C> configurer) {
        configurer.accept(this.getConfig(configClass));
        return (This)this;
    }

    default public This setTemplateEngine(TemplateEngine templateEngine) {
        return this.configure(SqlStatements.class, c -> c.setTemplateEngine(templateEngine));
    }

    default public This setSqlParser(SqlParser parser) {
        return this.configure(SqlStatements.class, c -> c.setSqlParser(parser));
    }

    default public This setTimingCollector(TimingCollector collector) {
        return this.configure(SqlStatements.class, c -> c.setTimingCollector(collector));
    }

    default public This define(String key, Object value) {
        return this.configure(SqlStatements.class, c -> c.define(key, value));
    }

    default public This registerArgument(ArgumentFactory factory) {
        return this.configure(Arguments.class, c -> c.register(factory));
    }

    default public This setSqlArrayArgumentStrategy(SqlArrayArgumentStrategy strategy) {
        return this.configure(SqlArrayTypes.class, c -> c.setArgumentStrategy(strategy));
    }

    default public This setMapKeyColumn(String keyColumn) {
        return this.configure(MapEntryMappers.class, c -> c.setKeyColumn(keyColumn));
    }

    default public This setMapValueColumn(String valueColumn) {
        return this.configure(MapEntryMappers.class, c -> c.setValueColumn(valueColumn));
    }

    default public This registerArrayType(Class<?> elementType, String sqlTypeName) {
        return this.configure(SqlArrayTypes.class, c -> c.register(elementType, sqlTypeName));
    }

    default public This registerArrayType(SqlArrayType<?> arrayType) {
        return this.configure(SqlArrayTypes.class, c -> c.register(arrayType));
    }

    default public This registerArrayType(SqlArrayTypeFactory factory) {
        return this.configure(SqlArrayTypes.class, c -> c.register(factory));
    }

    default public This registerCollector(CollectorFactory factory) {
        return this.configure(JdbiCollectors.class, c -> c.register(factory));
    }

    default public This registerColumnMapper(ColumnMapper<?> mapper) {
        return this.configure(ColumnMappers.class, c -> c.register(mapper));
    }

    default public This registerColumnMapper(Type type, ColumnMapper<?> mapper) {
        return this.configure(ColumnMappers.class, c -> c.register(type, mapper));
    }

    default public This registerColumnMapper(ColumnMapperFactory factory) {
        return this.configure(ColumnMappers.class, c -> c.register(factory));
    }

    default public This registerExtension(ExtensionFactory factory) {
        return this.configure(Extensions.class, c -> c.register(factory));
    }

    default public This registerRowMapper(RowMapper<?> mapper) {
        return this.configure(RowMappers.class, c -> c.register(mapper));
    }

    default public This registerRowMapper(Type type, RowMapper<?> mapper) {
        return this.configure(RowMappers.class, c -> c.register(type, mapper));
    }

    default public This registerRowMapper(RowMapperFactory factory) {
        return this.configure(RowMappers.class, c -> c.register(factory));
    }
}

