/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.transaction;

import java.sql.SQLException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.transaction.DelegatingTransactionHandler;
import org.jdbi.v3.core.transaction.LocalTransactionHandler;
import org.jdbi.v3.core.transaction.TransactionHandler;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;

public class SerializableTransactionRunner
extends DelegatingTransactionHandler
implements TransactionHandler {
    private static final String SQLSTATE_TXN_SERIALIZATION_FAILED = "40001";

    public SerializableTransactionRunner() {
        this(new LocalTransactionHandler());
    }

    public SerializableTransactionRunner(TransactionHandler delegate) {
        super(delegate);
    }

    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, HandleCallback<R, X> callback) throws X {
        Configuration config = handle.getConfig(Configuration.class);
        int retriesRemaining = config.maxRetries;
        while (true) {
            try {
                return this.getDelegate().inTransaction(handle, callback);
            }
            catch (Exception e) {
                if (this.isSqlState(config.serializationFailureSqlState, e) && --retriesRemaining > 0) continue;
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R, X extends Exception> R inTransaction(Handle handle, TransactionIsolationLevel level, HandleCallback<R, X> callback) throws X {
        TransactionIsolationLevel initial = handle.getTransactionIsolationLevel();
        try {
            handle.setTransactionIsolation(level);
            R r = this.inTransaction(handle, callback);
            return r;
        }
        finally {
            handle.setTransactionIsolation(initial);
        }
    }

    protected boolean isSqlState(String expectedSqlState, Throwable throwable) {
        do {
            String sqlState;
            if (!(throwable instanceof SQLException) || (sqlState = ((SQLException)throwable).getSQLState()) == null || !sqlState.startsWith(expectedSqlState)) continue;
            return true;
        } while ((throwable = throwable.getCause()) != null);
        return false;
    }

    public static class Configuration
    implements JdbiConfig<Configuration> {
        private int maxRetries = 5;
        private String serializationFailureSqlState = "40001";

        public Configuration setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Configuration setSerializationFailureSqlState(String serializationFailureSqlState) {
            this.serializationFailureSqlState = serializationFailureSqlState;
            return this;
        }

        @Override
        public Configuration createCopy() {
            return new Configuration().setMaxRetries(this.maxRetries).setSerializationFailureSqlState(this.serializationFailureSqlState);
        }
    }
}

