/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.client;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.drift.TException;
import io.airlift.drift.transport.client.ConnectionFailedException;
import io.airlift.drift.transport.client.InvokeRequest;
import io.airlift.drift.transport.netty.client.ConnectionManager;
import io.airlift.drift.transport.netty.client.ThriftClientHandler;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

class InvocationResponseFuture
extends AbstractFuture<Object> {
    private final InvokeRequest request;
    private final ConnectionManager.ConnectionParameters connectionParameters;
    private final ConnectionManager connectionManager;
    @GuardedBy(value="this")
    private Future<Channel> connectionFuture;
    @GuardedBy(value="this")
    private ThriftClientHandler.ThriftRequest invocationFuture;

    static InvocationResponseFuture createInvocationResponseFuture(InvokeRequest request, ConnectionManager.ConnectionParameters connectionParameters, ConnectionManager connectionManager) {
        InvocationResponseFuture future = new InvocationResponseFuture(request, connectionParameters, connectionManager);
        future.tryConnect();
        return future;
    }

    private InvocationResponseFuture(InvokeRequest request, ConnectionManager.ConnectionParameters connectionParameters, ConnectionManager connectionManager) {
        this.request = Objects.requireNonNull(request, "request is null");
        this.connectionParameters = Objects.requireNonNull(connectionParameters, "connectionConfig is null");
        this.connectionManager = Objects.requireNonNull(connectionManager, "connectionManager is null");
        super.addListener(() -> {
            if (super.isCancelled()) {
                this.onCancel(this.wasInterrupted());
            }
        }, MoreExecutors.directExecutor());
    }

    private synchronized void tryConnect() {
        try {
            this.connectionFuture = this.connectionManager.getConnection(this.connectionParameters, this.request.getAddress().getHostAndPort());
            this.connectionFuture.addListener(channelFuture -> {
                try {
                    if (channelFuture.isSuccess()) {
                        this.tryInvocation((Channel)channelFuture.getNow());
                    } else {
                        this.fatalError((Throwable)new ConnectionFailedException(this.request.getAddress(), channelFuture.cause()));
                    }
                }
                catch (Throwable t) {
                    this.fatalError(t);
                }
            });
        }
        catch (Throwable t) {
            this.fatalError(t);
        }
    }

    private synchronized void tryInvocation(final Channel channel) {
        if (this.isCancelled()) {
            this.connectionManager.returnConnection(channel);
            return;
        }
        try {
            this.invocationFuture = new ThriftClientHandler.ThriftRequest(this.request.getMethod(), this.request.getParameters(), this.request.getHeaders());
            channel.writeAndFlush((Object)this.invocationFuture);
            Futures.addCallback((ListenableFuture)this.invocationFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    try {
                        InvocationResponseFuture.this.connectionManager.returnConnection(channel);
                        InvocationResponseFuture.this.set(result);
                    }
                    catch (Throwable t) {
                        InvocationResponseFuture.this.fatalError(t);
                    }
                }

                public void onFailure(Throwable t) {
                    try {
                        InvocationResponseFuture.this.connectionManager.returnConnection(channel);
                    }
                    finally {
                        InvocationResponseFuture.this.fatalError(t);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        catch (Throwable t) {
            try {
                this.connectionManager.returnConnection(channel);
            }
            finally {
                this.fatalError(t);
            }
        }
    }

    private synchronized void onCancel(boolean wasInterrupted) {
        if (this.connectionFuture != null) {
            this.connectionFuture.cancel(wasInterrupted);
        }
        if (this.invocationFuture != null) {
            this.invocationFuture.cancel(wasInterrupted);
        }
    }

    private void fatalError(Throwable throwable) {
        if (!(throwable instanceof Error) && !(throwable instanceof TException)) {
            throwable = new TException(throwable);
        }
        this.setException(throwable);
    }
}

