/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.type.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ColumnMetadata {
    private final String name;
    private final Type type;
    private final String comment;
    private final String extraInfo;
    private final boolean hidden;
    private final Map<String, Object> properties;

    public ColumnMetadata(String name, Type type) {
        this(name, type, null, null, false, Collections.emptyMap());
    }

    public ColumnMetadata(String name, Type type, String comment, boolean hidden) {
        this(name, type, comment, null, hidden, Collections.emptyMap());
    }

    public ColumnMetadata(String name, Type type, String comment, String extraInfo, boolean hidden) {
        this(name, type, comment, extraInfo, hidden, Collections.emptyMap());
    }

    public ColumnMetadata(String name, Type type, String comment, String extraInfo, boolean hidden, Map<String, Object> properties) {
        if (name == null || name.isEmpty()) {
            throw new NullPointerException("name is null or empty");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is null");
        }
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.type = type;
        this.comment = comment;
        this.extraInfo = extraInfo;
        this.hidden = hidden;
        this.properties = properties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(properties));
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnMetadata{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", type=").append(this.type);
        if (this.comment != null) {
            sb.append(", comment='").append(this.comment).append('\'');
        }
        if (this.extraInfo != null) {
            sb.append(", extraInfo='").append(this.extraInfo).append('\'');
        }
        if (this.hidden) {
            sb.append(", hidden");
        }
        if (!this.properties.isEmpty()) {
            sb.append(", properties=").append(this.properties);
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.comment, this.extraInfo, this.hidden);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnMetadata other = (ColumnMetadata)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.comment, other.comment) && Objects.equals(this.extraInfo, other.extraInfo) && Objects.equals(this.hidden, other.hidden);
    }
}

