/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractRowBlock;
import com.facebook.presto.spi.block.AbstractSingleRowBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockUtil;
import com.facebook.presto.spi.block.RowBlock;
import com.facebook.presto.spi.block.SingleRowBlockWriter;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class RowBlockBuilder
extends AbstractRowBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RowBlockBuilder.class).instanceSize();
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private int positionCount;
    private int[] fieldBlockOffsets;
    private boolean[] rowIsNull;
    private final BlockBuilder[] fieldBlockBuilders;
    private boolean currentEntryOpened;

    public RowBlockBuilder(List<Type> fieldTypes, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(blockBuilderStatus, RowBlockBuilder.createFieldBlockBuilders(fieldTypes, blockBuilderStatus, expectedEntries), new int[expectedEntries + 1], new boolean[expectedEntries]);
    }

    private RowBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, BlockBuilder[] fieldBlockBuilders, int[] fieldBlockOffsets, boolean[] rowIsNull) {
        super(fieldBlockBuilders.length);
        this.blockBuilderStatus = blockBuilderStatus;
        this.positionCount = 0;
        this.fieldBlockOffsets = Objects.requireNonNull(fieldBlockOffsets, "fieldBlockOffsets is null");
        this.rowIsNull = Objects.requireNonNull(rowIsNull, "rowIsNull is null");
        this.fieldBlockBuilders = Objects.requireNonNull(fieldBlockBuilders, "fieldBlockBuilders is null");
    }

    private static BlockBuilder[] createFieldBlockBuilders(List<Type> fieldTypes, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        BlockBuilder[] fieldBlockBuilders = new BlockBuilder[fieldTypes.size()];
        for (int i = 0; i < fieldTypes.size(); ++i) {
            fieldBlockBuilders[i] = fieldTypes.get(i).createBlockBuilder(blockBuilderStatus, expectedEntries);
        }
        return fieldBlockBuilders;
    }

    @Override
    protected Block[] getRawFieldBlocks() {
        return this.fieldBlockBuilders;
    }

    @Override
    protected int[] getFieldBlockOffsets() {
        return this.fieldBlockOffsets;
    }

    @Override
    protected int getOffsetBase() {
        return 0;
    }

    @Override
    protected boolean[] getRowIsNull() {
        return this.rowIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        long sizeInBytes = 5L * (long)this.positionCount;
        for (int i = 0; i < this.numFields; ++i) {
            sizeInBytes += this.fieldBlockBuilders[i].getSizeInBytes();
        }
        return sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.fieldBlockOffsets) + SizeOf.sizeOf((boolean[])this.rowIsNull);
        for (int i = 0; i < this.numFields; ++i) {
            size += this.fieldBlockBuilders[i].getRetainedSizeInBytes();
        }
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        for (int i = 0; i < this.numFields; ++i) {
            consumer.accept(this.fieldBlockBuilders[i], this.fieldBlockBuilders[i].getRetainedSizeInBytes());
        }
        consumer.accept(this.fieldBlockOffsets, SizeOf.sizeOf((int[])this.fieldBlockOffsets));
        consumer.accept(this.rowIsNull, SizeOf.sizeOf((boolean[])this.rowIsNull));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public SingleRowBlockWriter beginBlockEntry() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        return new SingleRowBlockWriter(this.fieldBlockBuilders[0].getPositionCount(), this.fieldBlockBuilders);
    }

    @Override
    public BlockBuilder closeEntry() {
        if (!this.currentEntryOpened) {
            throw new IllegalStateException("Expected entry to be opened but was closed");
        }
        this.entryAdded(false);
        this.currentEntryOpened = false;
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        if (this.rowIsNull.length <= this.positionCount) {
            int newSize = BlockUtil.calculateNewArraySize(this.rowIsNull.length);
            this.rowIsNull = Arrays.copyOf(this.rowIsNull, newSize);
            this.fieldBlockOffsets = Arrays.copyOf(this.fieldBlockOffsets, newSize + 1);
        }
        this.fieldBlockOffsets[this.positionCount + 1] = isNull ? this.fieldBlockOffsets[this.positionCount] : this.fieldBlockOffsets[this.positionCount] + 1;
        this.rowIsNull[this.positionCount] = isNull;
        ++this.positionCount;
        for (int i = 0; i < this.numFields; ++i) {
            if (this.fieldBlockBuilders[i].getPositionCount() == this.fieldBlockOffsets[this.positionCount]) continue;
            throw new IllegalStateException(String.format("field %s has unexpected position count. Expected: %s, actual: %s", i, this.fieldBlockOffsets[this.positionCount], this.fieldBlockBuilders[i].getPositionCount()));
        }
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
        }
    }

    @Override
    public Block build() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        Block[] fieldBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            fieldBlocks[i] = this.fieldBlockBuilders[i].build();
        }
        return RowBlock.createRowBlockInternal(0, this.positionCount, this.rowIsNull, this.fieldBlockOffsets, fieldBlocks);
    }

    public String toString() {
        return String.format("RowBlockBuilder{numFields=%d, positionCount=%d", this.numFields, this.getPositionCount());
    }

    @Override
    public BlockBuilder appendStructure(Block block) {
        if (!(block instanceof AbstractSingleRowBlock)) {
            throw new IllegalStateException("Expected AbstractSingleRowBlock");
        }
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        int blockPositionCount = block.getPositionCount();
        if (blockPositionCount != this.numFields) {
            throw new IllegalArgumentException(String.format("block position count (%s) is not equal to number of fields (%s)", blockPositionCount, this.numFields));
        }
        for (int i = 0; i < blockPositionCount; ++i) {
            if (block.isNull(i)) {
                this.fieldBlockBuilders[i].appendNull();
                continue;
            }
            block.writePositionTo(i, this.fieldBlockBuilders[i]);
        }
        this.closeEntry();
        return this;
    }

    @Override
    public BlockBuilder appendStructureInternal(Block block, int position) {
        if (!(block instanceof AbstractRowBlock)) {
            throw new IllegalArgumentException();
        }
        AbstractRowBlock rowBlock = (AbstractRowBlock)block;
        SingleRowBlockWriter entryBuilder = this.beginBlockEntry();
        int fieldBlockOffset = rowBlock.getFieldBlockOffset(position);
        for (int i = 0; i < rowBlock.numFields; ++i) {
            if (rowBlock.getRawFieldBlocks()[i].isNull(fieldBlockOffset)) {
                entryBuilder.appendNull();
                continue;
            }
            rowBlock.getRawFieldBlocks()[i].writePositionTo(fieldBlockOffset, entryBuilder);
        }
        this.closeEntry();
        return this;
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        int newSize = BlockUtil.calculateBlockResetSize(this.getPositionCount());
        BlockBuilder[] newBlockBuilders = new BlockBuilder[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlockBuilders[i] = this.fieldBlockBuilders[i].newBlockBuilderLike(blockBuilderStatus);
        }
        return new RowBlockBuilder(blockBuilderStatus, newBlockBuilders, new int[newSize + 1], new boolean[newSize]);
    }
}

