/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractSingleRowBlock;
import com.facebook.presto.spi.block.Block;
import java.util.function.BiConsumer;
import org.openjdk.jol.info.ClassLayout;

public class SingleRowBlock
extends AbstractSingleRowBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleRowBlock.class).instanceSize();
    private final Block[] fieldBlocks;

    SingleRowBlock(int rowIndex, Block[] fieldBlocks) {
        super(rowIndex);
        this.fieldBlocks = fieldBlocks;
    }

    int getNumFields() {
        return this.fieldBlocks.length;
    }

    @Override
    protected Block getRawFieldBlock(int fieldIndex) {
        return this.fieldBlocks[fieldIndex];
    }

    @Override
    public int getPositionCount() {
        return this.fieldBlocks.length;
    }

    @Override
    public long getSizeInBytes() {
        long sizeInBytes = 0L;
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            sizeInBytes += this.getRawFieldBlock(i).getRegionSizeInBytes(this.rowIndex, 1);
        }
        return sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = INSTANCE_SIZE;
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            retainedSizeInBytes += this.getRawFieldBlock(i).getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            consumer.accept(this.fieldBlocks[i], this.fieldBlocks[i].getRetainedSizeInBytes());
        }
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public String getEncodingName() {
        return "ROW_ELEMENT";
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public String toString() {
        return String.format("SingleRowBlock{numFields=%d}", this.fieldBlocks.length);
    }

    @Override
    public Block getLoadedBlock() {
        boolean allLoaded = true;
        Block[] loadedFieldBlocks = new Block[this.fieldBlocks.length];
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            loadedFieldBlocks[i] = this.fieldBlocks[i].getLoadedBlock();
            if (loadedFieldBlocks[i] == this.fieldBlocks[i]) continue;
            allLoaded = false;
        }
        if (allLoaded) {
            return this;
        }
        return new SingleRowBlock(this.rowIndex, loadedFieldBlocks);
    }
}

