/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.connector;

import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.Privilege;
import java.util.Collections;
import java.util.Set;

public interface ConnectorAccessControl {
    default public void checkCanCreateSchema(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName) {
        AccessDeniedException.denyCreateSchema(schemaName);
    }

    default public void checkCanDropSchema(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName) {
        AccessDeniedException.denyDropSchema(schemaName);
    }

    default public void checkCanRenameSchema(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName, String newSchemaName) {
        AccessDeniedException.denyRenameSchema(schemaName, newSchemaName);
    }

    default public void checkCanShowSchemas(ConnectorTransactionHandle transactionHandle, Identity identity) {
        AccessDeniedException.denyShowSchemas();
    }

    default public Set<String> filterSchemas(ConnectorTransactionHandle transactionHandle, Identity identity, Set<String> schemaNames) {
        return Collections.emptySet();
    }

    default public void checkCanCreateTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyCreateTable(tableName.toString());
    }

    default public void checkCanDropTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyDropTable(tableName.toString());
    }

    default public void checkCanRenameTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName, SchemaTableName newTableName) {
        AccessDeniedException.denyRenameTable(tableName.toString(), newTableName.toString());
    }

    default public void checkCanShowTablesMetadata(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName) {
        AccessDeniedException.denyShowTablesMetadata(schemaName);
    }

    default public Set<SchemaTableName> filterTables(ConnectorTransactionHandle transactionHandle, Identity identity, Set<SchemaTableName> tableNames) {
        return Collections.emptySet();
    }

    default public void checkCanAddColumn(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyAddColumn(tableName.toString());
    }

    default public void checkCanDropColumn(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyDropColumn(tableName.toString());
    }

    default public void checkCanRenameColumn(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyRenameColumn(tableName.toString());
    }

    default public void checkCanSelectFromColumns(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName, Set<String> columnNames) {
        AccessDeniedException.denySelectColumns(tableName.toString(), columnNames);
    }

    default public void checkCanInsertIntoTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyInsertTable(tableName.toString());
    }

    default public void checkCanDeleteFromTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyDeleteTable(tableName.toString());
    }

    default public void checkCanCreateView(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName viewName) {
        AccessDeniedException.denyCreateView(viewName.toString());
    }

    default public void checkCanDropView(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName viewName) {
        AccessDeniedException.denyDropView(viewName.toString());
    }

    default public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName, Set<String> columnNames) {
        AccessDeniedException.denyCreateViewWithSelect(tableName.toString(), identity);
    }

    default public void checkCanSetCatalogSessionProperty(ConnectorTransactionHandle transactionHandle, Identity identity, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty(propertyName);
    }

    default public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transactionHandle, Identity identity, Privilege privilege, SchemaTableName tableName, String grantee, boolean withGrantOption) {
        AccessDeniedException.denyGrantTablePrivilege(privilege.toString(), tableName.toString());
    }

    default public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transactionHandle, Identity identity, Privilege privilege, SchemaTableName tableName, String revokee, boolean grantOptionFor) {
        AccessDeniedException.denyRevokeTablePrivilege(privilege.toString(), tableName.toString());
    }
}

