/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.tpch.RandomInt;
import java.util.List;
import java.util.Map;

public class Distribution {
    private final String name;
    private final List<String> values;
    private final int[] weights;
    private final String[] distribution;
    private final int maxWeight;

    public Distribution(String name, Map<String, Integer> distribution) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull(distribution, (Object)"distribution is null");
        ImmutableList.Builder values = ImmutableList.builder();
        this.weights = new int[distribution.size()];
        int runningWeight = 0;
        int index = 0;
        boolean isValidDistribution = true;
        for (Map.Entry<String, Integer> entry : distribution.entrySet()) {
            values.add((Object)entry.getKey());
            this.weights[index] = runningWeight += entry.getValue().intValue();
            isValidDistribution = isValidDistribution && entry.getValue() > 0;
            ++index;
        }
        this.values = values.build();
        if (isValidDistribution) {
            this.maxWeight = this.weights[this.weights.length - 1];
            this.distribution = new String[this.maxWeight];
            index = 0;
            for (String value : this.values) {
                int count = distribution.get(value);
                for (int i = 0; i < count; ++i) {
                    this.distribution[index++] = value;
                }
            }
        } else {
            this.maxWeight = -1;
            this.distribution = null;
        }
    }

    public String getValue(int index) {
        return this.values.get(index);
    }

    public List<String> getValues() {
        return this.values;
    }

    public int getWeight(int index) {
        return this.weights[index];
    }

    public int size() {
        return this.values.size();
    }

    public String randomValue(RandomInt randomInt) {
        Preconditions.checkState((this.distribution != null ? 1 : 0) != 0, (String)"%s does not have a distribution", (Object[])new Object[]{this.name});
        int randomValue = randomInt.nextInt(0, this.maxWeight - 1);
        return this.distribution[randomValue];
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }
}

