/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.NotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import java.util.Objects;

public class ViewNotFoundException
extends NotFoundException {
    private final SchemaTableName viewName;

    public ViewNotFoundException(SchemaTableName viewName) {
        this(viewName, String.format("View '%s' not found", viewName));
    }

    public ViewNotFoundException(SchemaTableName viewName, String message) {
        super(message);
        this.viewName = Objects.requireNonNull(viewName, "viewName is null");
    }

    public ViewNotFoundException(SchemaTableName viewName, Throwable cause) {
        this(viewName, String.format("View '%s' not found", viewName), cause);
    }

    public ViewNotFoundException(SchemaTableName viewName, String message, Throwable cause) {
        super(message, cause);
        this.viewName = Objects.requireNonNull(viewName, "viewName is null");
    }

    public SchemaTableName getViewName() {
        return this.viewName;
    }
}

