/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.codec.metadata.FieldKind;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftConstructorInjection;
import com.facebook.drift.codec.metadata.ThriftExtraction;
import com.facebook.drift.codec.metadata.ThriftFieldExtractor;
import com.facebook.drift.codec.metadata.ThriftInjection;
import com.facebook.drift.codec.metadata.ThriftMethodExtractor;
import com.facebook.drift.codec.metadata.ThriftMethodInjection;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.codec.metadata.ThriftTypeReference;
import com.facebook.drift.codec.metadata.TypeCoercion;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftFieldMetadata {
    private final short id;
    private final ThriftTypeReference thriftTypeReference;
    private final String name;
    private final FieldKind fieldKind;
    private final List<ThriftInjection> injections;
    private final Map<String, String> idlAnnotations;
    private final Optional<ThriftConstructorInjection> constructorInjection;
    private final Optional<ThriftMethodInjection> methodInjection;
    private final Optional<ThriftExtraction> extraction;
    private final Optional<TypeCoercion> coercion;
    private final ImmutableList<String> documentation;
    private final boolean isRecursiveReference;
    private final ThriftField.Requiredness requiredness;

    public ThriftFieldMetadata(short id, boolean isLegacyId, boolean isRecursiveReference, ThriftField.Requiredness requiredness, Map<String, String> idlAnnotations, ThriftTypeReference thriftTypeReference, String name, FieldKind fieldKind, List<ThriftInjection> injections, Optional<ThriftConstructorInjection> constructorInjection, Optional<ThriftMethodInjection> methodInjection, Optional<ThriftExtraction> extraction, Optional<TypeCoercion> coercion) {
        this.isRecursiveReference = isRecursiveReference;
        this.requiredness = requiredness;
        this.thriftTypeReference = Objects.requireNonNull(thriftTypeReference, "thriftType is null");
        this.fieldKind = Objects.requireNonNull(fieldKind, "type is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.injections = ImmutableList.copyOf((Collection)Objects.requireNonNull(injections, "injections is null"));
        this.constructorInjection = Objects.requireNonNull(constructorInjection, "constructorInjection is null");
        this.methodInjection = Objects.requireNonNull(methodInjection, "methodInjection is null");
        this.extraction = Objects.requireNonNull(extraction, "extraction is null");
        this.coercion = Objects.requireNonNull(coercion, "coercion is null");
        switch (fieldKind) {
            case THRIFT_FIELD: {
                if (isLegacyId) {
                    Preconditions.checkArgument((id < 0 ? 1 : 0) != 0, (Object)"isLegacyId should only be specified on fields with negative IDs");
                    break;
                }
                Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"isLegacyId must be specified on fields with negative IDs");
                break;
            }
            case THRIFT_UNION_ID: {
                Preconditions.checkArgument((boolean)isLegacyId, (Object)"isLegacyId should be implicitly set on ThriftUnionId fields");
                Preconditions.checkArgument((id == Short.MIN_VALUE ? 1 : 0) != 0, (Object)"thrift union id must be Short.MIN_VALUE");
            }
        }
        Preconditions.checkArgument((!injections.isEmpty() || extraction.isPresent() || constructorInjection.isPresent() || methodInjection.isPresent() ? 1 : 0) != 0, (Object)"A thrift field must have an injection or extraction point");
        this.id = id;
        if (extraction.isPresent()) {
            if (extraction.get() instanceof ThriftFieldExtractor) {
                ThriftFieldExtractor e = (ThriftFieldExtractor)extraction.get();
                this.documentation = ThriftCatalog.getThriftDocumentation(e.getField());
            } else if (extraction.get() instanceof ThriftMethodExtractor) {
                ThriftMethodExtractor e = (ThriftMethodExtractor)extraction.get();
                this.documentation = ThriftCatalog.getThriftDocumentation(e.getMethod());
            } else {
                this.documentation = ImmutableList.of();
            }
        } else {
            this.documentation = ImmutableList.of();
        }
        this.idlAnnotations = idlAnnotations;
    }

    public short getId() {
        return this.id;
    }

    public ThriftType getThriftType() {
        return this.thriftTypeReference.get();
    }

    public ThriftField.Requiredness getRequiredness() {
        return this.requiredness;
    }

    public String getName() {
        return this.name;
    }

    public FieldKind getType() {
        return this.fieldKind;
    }

    public Map<String, String> getIdlAnnotations() {
        ImmutableMap.Builder annotationsBuilder = ImmutableMap.builder();
        annotationsBuilder.putAll(this.idlAnnotations);
        if (this.isRecursiveReference()) {
            annotationsBuilder.put((Object)"drift.recursive_reference", (Object)"true");
        }
        return annotationsBuilder.build();
    }

    public boolean isTypeReferenceRecursive() {
        return this.thriftTypeReference.isRecursive();
    }

    public boolean isRecursiveReference() {
        return this.isRecursiveReference;
    }

    public boolean isInternal() {
        switch (this.getType()) {
            case THRIFT_FIELD: {
                return false;
            }
        }
        return true;
    }

    public boolean isReadOnly() {
        return this.injections.isEmpty() && !this.constructorInjection.isPresent() && !this.methodInjection.isPresent();
    }

    public boolean isWriteOnly() {
        return !this.extraction.isPresent();
    }

    public List<ThriftInjection> getInjections() {
        return this.injections;
    }

    public Optional<ThriftConstructorInjection> getConstructorInjection() {
        return this.constructorInjection;
    }

    public Optional<ThriftMethodInjection> getMethodInjection() {
        return this.methodInjection;
    }

    public Optional<ThriftExtraction> getExtraction() {
        return this.extraction;
    }

    public Optional<TypeCoercion> getCoercion() {
        return this.coercion;
    }

    public ImmutableList<String> getDocumentation() {
        return this.documentation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftFieldMetadata that = (ThriftFieldMetadata)o;
        return this.id == that.id && Objects.equals(this.thriftTypeReference, that.thriftTypeReference) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.thriftTypeReference, this.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (int)this.id).add("thriftTypeReference", (Object)this.thriftTypeReference).add("name", (Object)this.name).add("fieldKind", (Object)this.fieldKind).add("injections", this.injections).add("constructorInjection", this.constructorInjection).add("methodInjection", this.methodInjection).add("extraction", this.extraction).add("coercion", this.coercion).toString();
    }
}

