/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import java.util.List;

public final class SequencePageBuilder {
    private SequencePageBuilder() {
    }

    public static Page createSequencePage(List<? extends Type> types, int length) {
        return SequencePageBuilder.createSequencePage(types, length, new int[types.size()]);
    }

    public static Page createSequencePage(List<? extends Type> types, int length, int ... initialValues) {
        Block[] blocks = new Block[initialValues.length];
        for (int i = 0; i < blocks.length; ++i) {
            Type type = types.get(i);
            int initialValue = initialValues[i];
            if (type.equals(BigintType.BIGINT)) {
                blocks[i] = BlockAssertions.createLongSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(RealType.REAL)) {
                blocks[i] = BlockAssertions.createSequenceBlockOfReal(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(DoubleType.DOUBLE)) {
                blocks[i] = BlockAssertions.createDoubleSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type instanceof VarcharType) {
                blocks[i] = BlockAssertions.createStringSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(BooleanType.BOOLEAN)) {
                blocks[i] = BlockAssertions.createBooleanSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(DateType.DATE)) {
                blocks[i] = BlockAssertions.createDateSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(TimestampType.TIMESTAMP)) {
                blocks[i] = BlockAssertions.createTimestampSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (Decimals.isShortDecimal((Type)type)) {
                blocks[i] = BlockAssertions.createShortDecimalSequenceBlock(initialValue, initialValue + length, (DecimalType)type);
                continue;
            }
            if (Decimals.isLongDecimal((Type)type)) {
                blocks[i] = BlockAssertions.createLongDecimalSequenceBlock(initialValue, initialValue + length, (DecimalType)type);
                continue;
            }
            throw new IllegalStateException("Unsupported type " + type);
        }
        return new Page(blocks);
    }

    public static Page createSequencePageWithDictionaryBlocks(List<? extends Type> types, int length) {
        return SequencePageBuilder.createSequencePageWithDictionaryBlocks(types, length, new int[types.size()]);
    }

    public static Page createSequencePageWithDictionaryBlocks(List<? extends Type> types, int length, int ... initialValues) {
        Block[] blocks = new Block[initialValues.length];
        for (int i = 0; i < blocks.length; ++i) {
            Type type = types.get(i);
            int initialValue = initialValues[i];
            if (type.equals(VarcharType.VARCHAR)) {
                blocks[i] = BlockAssertions.createStringDictionaryBlock(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(BigintType.BIGINT)) {
                blocks[i] = BlockAssertions.createLongDictionaryBlock(initialValue, initialValue + length);
                continue;
            }
            throw new IllegalStateException("Unsupported type " + type);
        }
        return new Page(blocks);
    }
}

