/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.BaseStatsCalculatorTest;
import com.facebook.presto.cost.PlanNodeStatsAssertion;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculatorAssertion;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import org.testng.annotations.Test;

public class TestAggregationStatsRule
extends BaseStatsCalculatorTest {
    @Test
    public void testAggregationWhenAllStatisticsAreKnown() {
        Consumer<PlanNodeStatsAssertion> outputRowCountAndZStatsAreCalculated = check -> check.outputRowsCount(15.0).variableStats(new VariableReferenceExpression("z", (Type)BigintType.BIGINT), symbolStatsAssertion -> symbolStatsAssertion.lowValue(10.0).highValue(15.0).distinctValuesCount(4.0).nullsFraction(0.2)).variableStats(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), symbolStatsAssertion -> symbolStatsAssertion.lowValue(0.0).highValue(3.0).distinctValuesCount(3.0).nullsFraction(0.0));
        this.testAggregation(VariableStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).check(outputRowCountAndZStatsAreCalculated);
        this.testAggregation(VariableStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).build()).check(outputRowCountAndZStatsAreCalculated);
        Consumer<PlanNodeStatsAssertion> outputRowsCountAndZStatsAreNotFullyCalculated = check -> check.outputRowsCountUnknown().variableStats(new VariableReferenceExpression("z", (Type)BigintType.BIGINT), symbolStatsAssertion -> symbolStatsAssertion.unknownRange().distinctValuesCountUnknown().nullsFractionUnknown()).variableStats(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), symbolStatsAssertion -> symbolStatsAssertion.unknownRange().nullsFractionUnknown().distinctValuesCountUnknown());
        this.testAggregation(VariableStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setNullsFraction(0.1).build()).check(outputRowsCountAndZStatsAreNotFullyCalculated);
        this.testAggregation(VariableStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).build()).check(outputRowsCountAndZStatsAreNotFullyCalculated);
    }

    private StatsCalculatorAssertion testAggregation(VariableStatsEstimate zStats) {
        return this.tester().assertStatsFor(pb -> pb.aggregation(ab -> ab.addAggregation(pb.variable("sum", (Type)BigintType.BIGINT), PlanBuilder.expression("sum(x)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(pb.variable("count", (Type)BigintType.BIGINT), PlanBuilder.expression("count()"), (List<Type>)ImmutableList.of()).addAggregation(pb.variable("count_on_x", (Type)BigintType.BIGINT), PlanBuilder.expression("count(x)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(pb.variable("y", (Type)BigintType.BIGINT), pb.variable("z", (Type)BigintType.BIGINT)).source((PlanNode)pb.values(pb.variable("x", (Type)BigintType.BIGINT), pb.variable("y", (Type)BigintType.BIGINT), pb.variable("z", (Type)BigintType.BIGINT))))).withSourceStats(PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.3).build()).addVariableStatistics(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(3.0).setNullsFraction(0.0).build()).addVariableStatistics(new VariableReferenceExpression("z", (Type)BigintType.BIGINT), zStats).build()).check(check -> check.variableStats(new VariableReferenceExpression("sum", (Type)BigintType.BIGINT), symbolStatsAssertion -> symbolStatsAssertion.lowValueUnknown().highValueUnknown().distinctValuesCountUnknown().nullsFractionUnknown()).variableStats(new VariableReferenceExpression("count", (Type)BigintType.BIGINT), symbolStatsAssertion -> symbolStatsAssertion.lowValueUnknown().highValueUnknown().distinctValuesCountUnknown().nullsFractionUnknown()).variableStats(new VariableReferenceExpression("count_on_x", (Type)BigintType.BIGINT), symbolStatsAssertion -> symbolStatsAssertion.lowValueUnknown().highValueUnknown().distinctValuesCountUnknown().nullsFractionUnknown()).variableStats(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), symbolStatsAssertion -> symbolStatsAssertion.lowValueUnknown().highValueUnknown().distinctValuesCountUnknown().nullsFractionUnknown()));
    }

    @Test
    public void testAggregationStatsCappedToInputRows() {
        this.tester().assertStatsFor(pb -> pb.aggregation(ab -> ab.addAggregation(pb.variable("count_on_x", (Type)BigintType.BIGINT), PlanBuilder.expression("count(x)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(pb.variable("y", (Type)BigintType.BIGINT), pb.variable("z", (Type)BigintType.BIGINT)).source((PlanNode)pb.values(pb.variable("x", (Type)BigintType.BIGINT), pb.variable("y", (Type)BigintType.BIGINT), pb.variable("z", (Type)BigintType.BIGINT))))).withSourceStats(PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addVariableStatistics(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setDistinctValuesCount(50.0).build()).addVariableStatistics(new VariableReferenceExpression("z", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setDistinctValuesCount(50.0).build()).build()).check(check -> check.outputRowsCount(100.0));
    }
}

