/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.FilterStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsAssertion;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.ScalarStatsCalculator;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.VariableStatsAssertion;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestComparisonStatsCalculator {
    private FilterStatsCalculator filterStatsCalculator;
    private Session session;
    private PlanNodeStatsEstimate standardInputStatistics;
    private TypeProvider types;
    private VariableStatsEstimate uStats;
    private VariableStatsEstimate wStats;
    private VariableStatsEstimate xStats;
    private VariableStatsEstimate yStats;
    private VariableStatsEstimate zStats;
    private VariableStatsEstimate leftOpenStats;
    private VariableStatsEstimate rightOpenStats;
    private VariableStatsEstimate unknownRangeStats;
    private VariableStatsEstimate emptyRangeStats;
    private VariableStatsEstimate varcharStats;

    @BeforeClass
    public void setUp() throws Exception {
        this.session = TestingSession.testSessionBuilder().build();
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        this.filterStatsCalculator = new FilterStatsCalculator((Metadata)metadata, new ScalarStatsCalculator((Metadata)metadata), new StatsNormalizer());
        this.uStats = VariableStatsEstimate.builder().setAverageRowSize(8.0).setDistinctValuesCount(300.0).setLowValue(0.0).setHighValue(20.0).setNullsFraction(0.1).build();
        this.wStats = VariableStatsEstimate.builder().setAverageRowSize(8.0).setDistinctValuesCount(30.0).setLowValue(0.0).setHighValue(20.0).setNullsFraction(0.1).build();
        this.xStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(40.0).setLowValue(-10.0).setHighValue(10.0).setNullsFraction(0.25).build();
        this.yStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(20.0).setLowValue(0.0).setHighValue(5.0).setNullsFraction(0.5).build();
        this.zStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(5.0).setLowValue(-100.0).setHighValue(100.0).setNullsFraction(0.1).build();
        this.leftOpenStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(15.0).setNullsFraction(0.1).build();
        this.rightOpenStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(-15.0).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
        this.unknownRangeStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
        this.emptyRangeStats = VariableStatsEstimate.builder().setAverageRowSize(0.0).setDistinctValuesCount(0.0).setLowValue(Double.NaN).setHighValue(Double.NaN).setNullsFraction(1.0).build();
        this.varcharStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
        this.standardInputStatistics = PlanNodeStatsEstimate.builder().addVariableStatistics(new VariableReferenceExpression("u", (Type)DoubleType.DOUBLE), this.uStats).addVariableStatistics(new VariableReferenceExpression("w", (Type)DoubleType.DOUBLE), this.wStats).addVariableStatistics(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), this.xStats).addVariableStatistics(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), this.yStats).addVariableStatistics(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), this.zStats).addVariableStatistics(new VariableReferenceExpression("leftOpen", (Type)DoubleType.DOUBLE), this.leftOpenStats).addVariableStatistics(new VariableReferenceExpression("rightOpen", (Type)DoubleType.DOUBLE), this.rightOpenStats).addVariableStatistics(new VariableReferenceExpression("unknownRange", (Type)DoubleType.DOUBLE), this.unknownRangeStats).addVariableStatistics(new VariableReferenceExpression("emptyRange", (Type)DoubleType.DOUBLE), this.emptyRangeStats).addVariableStatistics(new VariableReferenceExpression("varchar", (Type)VarcharType.createVarcharType((int)10)), this.varcharStats).setOutputRowCount(1000.0).build();
        this.types = TypeProvider.fromVariables((Collection)ImmutableList.builder().add((Object)new VariableReferenceExpression("u", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("w", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("leftOpen", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("rightOpen", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("unknownRange", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("emptyRange", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("varchar", (Type)VarcharType.createVarcharType((int)10))).build());
    }

    private Consumer<VariableStatsAssertion> equalTo(VariableStatsEstimate estimate) {
        return symbolAssert -> symbolAssert.lowValue(estimate.getLowValue()).highValue(estimate.getHighValue()).distinctValuesCount(estimate.getDistinctValuesCount()).nullsFraction(estimate.getNullsFraction());
    }

    private VariableStatsEstimate updateNDV(VariableStatsEstimate symbolStats, double delta) {
        return symbolStats.mapDistinctValuesCount(ndv -> ndv + delta);
    }

    private VariableStatsEstimate capNDV(VariableStatsEstimate symbolStats, double rowCount) {
        double ndv = symbolStats.getDistinctValuesCount();
        double nulls = symbolStats.getNullsFraction();
        if (Double.isNaN(ndv) || Double.isNaN(rowCount) || Double.isNaN(nulls)) {
            return symbolStats;
        }
        if (ndv <= rowCount * (1.0 - nulls)) {
            return symbolStats;
        }
        return symbolStats.mapDistinctValuesCount(n -> (Math.min(ndv, rowCount) + rowCount * (1.0 - nulls)) / 2.0).mapNullsFraction(n -> nulls / 2.0);
    }

    private VariableStatsEstimate zeroNullsFraction(VariableStatsEstimate symbolStats) {
        return symbolStats.mapNullsFraction(fraction -> 0.0);
    }

    private PlanNodeStatsAssertion assertCalculate(Expression comparisonExpression) {
        return PlanNodeStatsAssertion.assertThat(this.filterStatsCalculator.filterStats(this.standardInputStatistics, comparisonExpression, this.session, this.types));
    }

    @Test
    public void verifyTestInputConsistent() {
        TestComparisonStatsCalculator.checkConsistent(new StatsNormalizer(), "standardInputStatistics", this.standardInputStatistics, this.standardInputStatistics.getVariablesWithKnownStatistics(), this.types);
    }

    @Test
    public void symbolToLiteralEqualStats() {
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("y"), (Expression)new DoubleLiteral("2.5"))).outputRowsCount(25.0).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(2.5).highValue(2.5).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral("10.0"))).outputRowsCount(18.75).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(10.0).highValue(10.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("y"), (Expression)new DoubleLiteral("10.0"))).outputRowsCount(0.0).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(0.0).distinctValuesCount(0.0).emptyRange().nullsFraction(1.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("leftOpen"), (Expression)new DoubleLiteral("2.5"))).outputRowsCount(18.0).variableStats(new VariableReferenceExpression("leftOpen", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(2.5).highValue(2.5).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("rightOpen"), (Expression)new DoubleLiteral("-2.5"))).outputRowsCount(18.0).variableStats(new VariableReferenceExpression("rightOpen", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(-2.5).highValue(-2.5).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("unknownRange"), (Expression)new DoubleLiteral("0.0"))).outputRowsCount(18.0).variableStats(new VariableReferenceExpression("unknownRange", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(0.0).highValue(0.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("emptyRange"), (Expression)new DoubleLiteral("0.0"))).outputRowsCount(0.0).variableStats(new VariableReferenceExpression("emptyRange", (Type)DoubleType.DOUBLE), this.equalTo(this.emptyRangeStats));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("varchar"), (Expression)new StringLiteral("blah"))).outputRowsCount(18.0).variableStats(new VariableReferenceExpression("varchar", (Type)VarcharType.createVarcharType((int)10)), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY).nullsFraction(0.0));
    }

    @Test
    public void symbolToLiteralNotEqualStats() {
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("y"), (Expression)new DoubleLiteral("2.5"))).outputRowsCount(475.0).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(19.0).lowValue(0.0).highValue(5.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral("10.0"))).outputRowsCount(731.25).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(39.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("y"), (Expression)new DoubleLiteral("10.0"))).outputRowsCount(500.0).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(19.0).lowValue(0.0).highValue(5.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("leftOpen"), (Expression)new DoubleLiteral("2.5"))).outputRowsCount(882.0).variableStats(new VariableReferenceExpression("leftOpen", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(49.0).lowValueUnknown().highValue(15.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("rightOpen"), (Expression)new DoubleLiteral("-2.5"))).outputRowsCount(882.0).variableStats(new VariableReferenceExpression("rightOpen", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(49.0).lowValue(-15.0).highValueUnknown().nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("unknownRange"), (Expression)new DoubleLiteral("0.0"))).outputRowsCount(882.0).variableStats(new VariableReferenceExpression("unknownRange", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(49.0).lowValueUnknown().highValueUnknown().nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("emptyRange"), (Expression)new DoubleLiteral("0.0"))).outputRowsCount(0.0).variableStats(new VariableReferenceExpression("emptyRange", (Type)DoubleType.DOUBLE), this.equalTo(this.emptyRangeStats));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("varchar"), (Expression)new StringLiteral("blah"))).outputRowsCount(882.0).variableStats(new VariableReferenceExpression("varchar", (Type)VarcharType.createVarcharType((int)10)), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(49.0).lowValueUnknown().highValueUnknown().nullsFraction(0.0));
    }

    @Test
    public void symbolToLiteralLessThanStats() {
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("y"), (Expression)new DoubleLiteral("2.5"))).outputRowsCount(250.0).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(10.0).lowValue(0.0).highValue(2.5).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral("10.0"))).outputRowsCount(750.0).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(40.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral("-10.0"))).outputRowsCount(18.75).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(-10.0).highValue(-10.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("y"), (Expression)new DoubleLiteral("-10.0"))).outputRowsCount(0.0).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(0.0).distinctValuesCount(0.0).emptyRange().nullsFraction(1.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("leftOpen"), (Expression)new DoubleLiteral("0.0"))).outputRowsCount(450.0).variableStats(new VariableReferenceExpression("leftOpen", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(25.0).lowValueUnknown().highValue(0.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("rightOpen"), (Expression)new DoubleLiteral("0.0"))).outputRowsCount(225.0).variableStats(new VariableReferenceExpression("rightOpen", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(12.5).lowValue(-15.0).highValue(0.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("unknownRange"), (Expression)new DoubleLiteral("0.0"))).outputRowsCount(450.0).variableStats(new VariableReferenceExpression("unknownRange", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(25.0).lowValueUnknown().highValue(0.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("emptyRange"), (Expression)new DoubleLiteral("0.0"))).outputRowsCount(0.0).variableStats(new VariableReferenceExpression("emptyRange", (Type)DoubleType.DOUBLE), this.equalTo(this.emptyRangeStats));
    }

    @Test
    public void symbolToLiteralGreaterThanStats() {
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("y"), (Expression)new DoubleLiteral("2.5"))).outputRowsCount(250.0).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(10.0).lowValue(2.5).highValue(5.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral("-10.0"))).outputRowsCount(750.0).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(40.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("x"), (Expression)new DoubleLiteral("10.0"))).outputRowsCount(18.75).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(1.0).lowValue(10.0).highValue(10.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("y"), (Expression)new DoubleLiteral("10.0"))).outputRowsCount(0.0).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(0.0).distinctValuesCount(0.0).emptyRange().nullsFraction(1.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("leftOpen"), (Expression)new DoubleLiteral("0.0"))).outputRowsCount(225.0).variableStats(new VariableReferenceExpression("leftOpen", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(12.5).lowValue(0.0).highValue(15.0).nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("rightOpen"), (Expression)new DoubleLiteral("0.0"))).outputRowsCount(450.0).variableStats(new VariableReferenceExpression("rightOpen", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(25.0).lowValue(0.0).highValueUnknown().nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("unknownRange"), (Expression)new DoubleLiteral("0.0"))).outputRowsCount(450.0).variableStats(new VariableReferenceExpression("unknownRange", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).distinctValuesCount(25.0).lowValue(0.0).highValueUnknown().nullsFraction(0.0));
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("emptyRange"), (Expression)new DoubleLiteral("0.0"))).outputRowsCount(0.0).variableStats(new VariableReferenceExpression("emptyRange", (Type)DoubleType.DOUBLE), this.equalTo(this.emptyRangeStats));
    }

    @Test
    public void symbolToSymbolEqualStats() {
        double rowCount = 2.7;
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("u"), (Expression)new SymbolReference("w"))).outputRowsCount(rowCount).variableStats(new VariableReferenceExpression("u", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zeroNullsFraction(this.uStats), rowCount))).variableStats(new VariableReferenceExpression("w", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zeroNullsFraction(this.wStats), rowCount))).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = 9.375;
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y"))).outputRowsCount(rowCount).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(9.375).nullsFraction(0.0)).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(0.0).highValue(5.0).distinctValuesCount(9.375).nullsFraction(0.0)).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = 16.875;
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("w"))).outputRowsCount(rowCount).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(6.0).lowValue(0.0).highValue(10.0).distinctValuesCount(16.875).nullsFraction(0.0)).variableStats(new VariableReferenceExpression("w", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(6.0).lowValue(0.0).highValue(10.0).distinctValuesCount(16.875).nullsFraction(0.0)).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = 2.25;
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("u"))).outputRowsCount(rowCount).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(6.0).lowValue(0.0).highValue(10.0).distinctValuesCount(2.25).nullsFraction(0.0)).variableStats(new VariableReferenceExpression("u", (Type)DoubleType.DOUBLE), symbolAssert -> symbolAssert.averageRowSize(6.0).lowValue(0.0).highValue(10.0).distinctValuesCount(2.25).nullsFraction(0.0)).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zStats, rowCount)));
    }

    @Test
    public void symbolToSymbolNotEqual() {
        double rowCount = 807.3;
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("u"), (Expression)new SymbolReference("w"))).outputRowsCount(rowCount).variableStats(new VariableReferenceExpression("u", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zeroNullsFraction(this.uStats), rowCount))).variableStats(new VariableReferenceExpression("w", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zeroNullsFraction(this.wStats), rowCount))).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = 365.625;
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("y"))).outputRowsCount(rowCount).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zeroNullsFraction(this.xStats), rowCount))).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zeroNullsFraction(this.yStats), rowCount))).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = 658.125;
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("w"))).outputRowsCount(rowCount).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zeroNullsFraction(this.xStats), rowCount))).variableStats(new VariableReferenceExpression("w", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zeroNullsFraction(this.wStats), rowCount))).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = 672.75;
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("x"), (Expression)new SymbolReference("u"))).outputRowsCount(rowCount).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zeroNullsFraction(this.xStats), rowCount))).variableStats(new VariableReferenceExpression("u", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zeroNullsFraction(this.uStats), rowCount))).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zStats, rowCount)));
    }

    @Test
    public void symbolToCastExpressionNotEqual() {
        double rowCount = 807.3;
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("u"), (Expression)new Cast((Expression)new SymbolReference("w"), "bigint"))).outputRowsCount(rowCount).variableStats(new VariableReferenceExpression("u", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zeroNullsFraction(this.uStats), rowCount))).variableStats(new VariableReferenceExpression("w", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.wStats, rowCount))).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zStats, rowCount)));
        rowCount = 897.0;
        this.assertCalculate((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("u"), (Expression)new Cast((Expression)new LongLiteral("10"), "bigint"))).outputRowsCount(rowCount).variableStats(new VariableReferenceExpression("u", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.updateNDV(this.zeroNullsFraction(this.uStats), -1.0), rowCount))).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), this.equalTo(this.capNDV(this.zStats, rowCount)));
    }

    private static void checkConsistent(StatsNormalizer normalizer, String source, PlanNodeStatsEstimate stats, Collection<VariableReferenceExpression> outputVariables, TypeProvider types) {
        PlanNodeStatsEstimate normalized = normalizer.normalize(stats, outputVariables);
        if (Objects.equals(stats, normalized)) {
            return;
        }
        ArrayList<String> problems = new ArrayList<String>();
        if (Double.compare(stats.getOutputRowCount(), normalized.getOutputRowCount()) != 0) {
            problems.add(String.format("Output row count is %s, should be normalized to %s", stats.getOutputRowCount(), normalized.getOutputRowCount()));
        }
        for (VariableReferenceExpression variable : stats.getVariablesWithKnownStatistics()) {
            if (Objects.equals(stats.getVariableStatistics(variable), normalized.getVariableStatistics(variable))) continue;
            problems.add(String.format("Variable stats for '%s' are \n\t\t\t\t\t%s, should be normalized to \n\t\t\t\t\t%s", variable, stats.getVariableStatistics(variable), normalized.getVariableStatistics(variable)));
        }
        if (problems.isEmpty()) {
            problems.add(stats.toString());
        }
        throw new IllegalStateException(String.format("Rule %s returned inconsistent stats: %s", source, problems.stream().collect(Collectors.joining("\n\t\t\t", "\n\t\t\t", ""))));
    }
}

