/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.BaseStatsCalculatorTest;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.FilterStatsCalculator;
import com.facebook.presto.cost.JoinStatsRule;
import com.facebook.presto.cost.PlanNodeStatsAssertion;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.ScalarStatsCalculator;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJoinStatsRule
extends BaseStatsCalculatorTest {
    private static final VariableReferenceExpression LEFT_JOIN_COLUMN = new VariableReferenceExpression("left_join_column", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression LEFT_JOIN_COLUMN_2 = new VariableReferenceExpression("left_join_column_2", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression RIGHT_JOIN_COLUMN = new VariableReferenceExpression("right_join_column", (Type)DoubleType.DOUBLE);
    private static final VariableReferenceExpression RIGHT_JOIN_COLUMN_2 = new VariableReferenceExpression("right_join_column_2", (Type)DoubleType.DOUBLE);
    private static final VariableReferenceExpression LEFT_OTHER_COLUMN = new VariableReferenceExpression("left_column", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression RIGHT_OTHER_COLUMN = new VariableReferenceExpression("right_column", (Type)DoubleType.DOUBLE);
    private static final double LEFT_ROWS_COUNT = 500.0;
    private static final double RIGHT_ROWS_COUNT = 1000.0;
    private static final double TOTAL_ROWS_COUNT = 1500.0;
    private static final double LEFT_JOIN_COLUMN_NULLS = 0.3;
    private static final double LEFT_JOIN_COLUMN_2_NULLS = 0.4;
    private static final double LEFT_JOIN_COLUMN_NON_NULLS = 0.7;
    private static final double LEFT_JOIN_COLUMN_2_NON_NULLS = 0.6;
    private static final int LEFT_JOIN_COLUMN_NDV = 20;
    private static final int LEFT_JOIN_COLUMN_2_NDV = 50;
    private static final double RIGHT_JOIN_COLUMN_NULLS = 0.6;
    private static final double RIGHT_JOIN_COLUMN_2_NULLS = 0.8;
    private static final double RIGHT_JOIN_COLUMN_NON_NULLS = 0.4;
    private static final double RIGHT_JOIN_COLUMN_2_NON_NULLS = 0.19999999999999996;
    private static final int RIGHT_JOIN_COLUMN_NDV = 15;
    private static final int RIGHT_JOIN_COLUMN_2_NDV = 15;
    private static final VariableStatistics LEFT_JOIN_COLUMN_STATS = TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, 0.3, 20.0);
    private static final VariableStatistics LEFT_JOIN_COLUMN_2_STATS = TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN_2, 0.0, 200.0, 0.4, 50.0);
    private static final VariableStatistics LEFT_OTHER_COLUMN_STATS = TestJoinStatsRule.variableStatistics(LEFT_OTHER_COLUMN, 42.0, 42.0, 0.42, 1.0);
    private static final VariableStatistics RIGHT_JOIN_COLUMN_STATS = TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.6, 15.0);
    private static final VariableStatistics RIGHT_JOIN_COLUMN_2_STATS = TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN_2, 100.0, 200.0, 0.8, 15.0);
    private static final VariableStatistics RIGHT_OTHER_COLUMN_STATS = TestJoinStatsRule.variableStatistics(RIGHT_OTHER_COLUMN, 24.0, 24.0, 0.24, 1.0);
    private static final PlanNodeStatsEstimate LEFT_STATS = TestJoinStatsRule.planNodeStats(500.0, LEFT_JOIN_COLUMN_STATS, LEFT_OTHER_COLUMN_STATS);
    private static final PlanNodeStatsEstimate RIGHT_STATS = TestJoinStatsRule.planNodeStats(1000.0, RIGHT_JOIN_COLUMN_STATS, RIGHT_OTHER_COLUMN_STATS);
    private static final MetadataManager METADATA = MetadataManager.createTestMetadataManager();
    private static final StatsNormalizer NORMALIZER = new StatsNormalizer();
    private static final JoinStatsRule JOIN_STATS_RULE = new JoinStatsRule(new FilterStatsCalculator((Metadata)METADATA, new ScalarStatsCalculator((Metadata)METADATA), NORMALIZER), NORMALIZER, 1.0);

    @Test
    public void testStatsForInnerJoin() {
        double innerJoinRowCount = 7000.0;
        PlanNodeStatsEstimate innerJoinStats = TestJoinStatsRule.planNodeStats(innerJoinRowCount, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), LEFT_OTHER_COLUMN_STATS, RIGHT_OTHER_COLUMN_STATS);
        this.assertJoinStats(JoinNode.Type.INNER, LEFT_STATS, RIGHT_STATS, innerJoinStats);
    }

    @Test
    public void testStatsForInnerJoinWithRepeatedClause() {
        double innerJoinRowCount = 6300.0;
        PlanNodeStatsEstimate innerJoinStats = TestJoinStatsRule.planNodeStats(innerJoinRowCount, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), LEFT_OTHER_COLUMN_STATS, RIGHT_OTHER_COLUMN_STATS);
        this.tester().assertStatsFor(pb -> {
            VariableReferenceExpression leftJoinColumnVariable = pb.variable(LEFT_JOIN_COLUMN);
            VariableReferenceExpression rightJoinColumnVariable = pb.variable(RIGHT_JOIN_COLUMN);
            VariableReferenceExpression leftOtherColumnVariable = pb.variable(LEFT_OTHER_COLUMN);
            VariableReferenceExpression rightOtherColumnVariable = pb.variable(RIGHT_OTHER_COLUMN);
            return pb.join(JoinNode.Type.INNER, (PlanNode)pb.values(leftJoinColumnVariable, leftOtherColumnVariable), (PlanNode)pb.values(rightJoinColumnVariable, rightOtherColumnVariable), new JoinNode.EquiJoinClause(pb.variable(leftJoinColumnVariable), pb.variable(rightJoinColumnVariable)), new JoinNode.EquiJoinClause(pb.variable(leftJoinColumnVariable), pb.variable(rightJoinColumnVariable)));
        }).withSourceStats(0, LEFT_STATS).withSourceStats(1, RIGHT_STATS).check(stats -> stats.equalTo(innerJoinStats));
    }

    @Test
    public void testStatsForInnerJoinWithTwoEquiClauses() {
        double innerJoinRowCount = 1079.9999999999998;
        PlanNodeStatsEstimate innerJoinStats = TestJoinStatsRule.planNodeStats(innerJoinRowCount, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN_2, 100.0, 200.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN_2, 100.0, 200.0, 0.0, 15.0));
        this.tester().assertStatsFor(pb -> {
            VariableReferenceExpression leftJoinColumnVariable = pb.variable(LEFT_JOIN_COLUMN);
            VariableReferenceExpression rightJoinColumnVariable = pb.variable(RIGHT_JOIN_COLUMN);
            VariableReferenceExpression leftJoinColumnVariable2 = pb.variable(LEFT_JOIN_COLUMN_2);
            VariableReferenceExpression rightJoinColumnVariable2 = pb.variable(RIGHT_JOIN_COLUMN_2);
            return pb.join(JoinNode.Type.INNER, (PlanNode)pb.values(leftJoinColumnVariable, leftJoinColumnVariable2), (PlanNode)pb.values(rightJoinColumnVariable, rightJoinColumnVariable2), new JoinNode.EquiJoinClause(pb.variable(leftJoinColumnVariable2), pb.variable(rightJoinColumnVariable2)), new JoinNode.EquiJoinClause(pb.variable(leftJoinColumnVariable), pb.variable(rightJoinColumnVariable)));
        }).withSourceStats(0, TestJoinStatsRule.planNodeStats(500.0, LEFT_JOIN_COLUMN_STATS, LEFT_JOIN_COLUMN_2_STATS)).withSourceStats(1, TestJoinStatsRule.planNodeStats(1000.0, RIGHT_JOIN_COLUMN_STATS, RIGHT_JOIN_COLUMN_2_STATS)).check(stats -> stats.equalTo(innerJoinStats));
    }

    @Test
    public void testStatsForInnerJoinWithTwoEquiClausesAndNonEqualityFunction() {
        double innerJoinRowCount = 359.9999999639999;
        PlanNodeStatsEstimate innerJoinStats = TestJoinStatsRule.planNodeStats(innerJoinRowCount, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 5.0, 10.0, 0.0, 4.9999999995), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN_2, 100.0, 200.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN_2, 100.0, 200.0, 0.0, 15.0));
        this.tester().assertStatsFor(pb -> {
            VariableReferenceExpression leftJoinColumn = pb.variable(LEFT_JOIN_COLUMN);
            VariableReferenceExpression rightJoinColumn = pb.variable(RIGHT_JOIN_COLUMN);
            VariableReferenceExpression leftJoinColumn2 = pb.variable(LEFT_JOIN_COLUMN_2);
            VariableReferenceExpression rightJoinColumn2 = pb.variable(RIGHT_JOIN_COLUMN_2);
            ComparisonExpression leftJoinColumnLessThanTen = new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference(leftJoinColumn.getName()), (Expression)new LongLiteral("10"));
            return pb.join(JoinNode.Type.INNER, (PlanNode)pb.values(leftJoinColumn, leftJoinColumn2), (PlanNode)pb.values(rightJoinColumn, rightJoinColumn2), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(leftJoinColumn2, rightJoinColumn2), (Object)new JoinNode.EquiJoinClause(leftJoinColumn, rightJoinColumn)), (List<VariableReferenceExpression>)ImmutableList.of((Object)leftJoinColumn, (Object)leftJoinColumn2, (Object)rightJoinColumn, (Object)rightJoinColumn2), Optional.of(OriginalExpressionUtils.castToRowExpression((Expression)leftJoinColumnLessThanTen)));
        }).withSourceStats(0, TestJoinStatsRule.planNodeStats(500.0, LEFT_JOIN_COLUMN_STATS, LEFT_JOIN_COLUMN_2_STATS)).withSourceStats(1, TestJoinStatsRule.planNodeStats(1000.0, RIGHT_JOIN_COLUMN_STATS, RIGHT_JOIN_COLUMN_2_STATS)).check(stats -> stats.equalTo(innerJoinStats));
    }

    @Test
    public void testJoinComplementStats() {
        PlanNodeStatsEstimate expected = TestJoinStatsRule.planNodeStats(237.5, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, 0.631578947368421, 5.0), LEFT_OTHER_COLUMN_STATS);
        PlanNodeStatsEstimate actual = JOIN_STATS_RULE.calculateJoinComplementStats(Optional.empty(), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(LEFT_JOIN_COLUMN, RIGHT_JOIN_COLUMN)), LEFT_STATS, RIGHT_STATS);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testRightJoinComplementStats() {
        PlanNodeStatsEstimate expected = NORMALIZER.normalize(TestJoinStatsRule.planNodeStats(600.0, TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, Double.NaN, Double.NaN, 1.0, 0.0), RIGHT_OTHER_COLUMN_STATS));
        PlanNodeStatsEstimate actual = JOIN_STATS_RULE.calculateJoinComplementStats(Optional.empty(), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(RIGHT_JOIN_COLUMN, LEFT_JOIN_COLUMN)), RIGHT_STATS, LEFT_STATS);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testLeftJoinComplementStatsWithNoClauses() {
        PlanNodeStatsEstimate expected = NORMALIZER.normalize(LEFT_STATS.mapOutputRowCount(rowCount -> 0.0));
        PlanNodeStatsEstimate actual = JOIN_STATS_RULE.calculateJoinComplementStats(Optional.empty(), (List)ImmutableList.of(), LEFT_STATS, RIGHT_STATS);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testLeftJoinComplementStatsWithMultipleClauses() {
        PlanNodeStatsEstimate expected = TestJoinStatsRule.planNodeStats(237.5, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, 0.631578947368421, 5.0), LEFT_OTHER_COLUMN_STATS).mapOutputRowCount(rowCount -> rowCount / 0.9);
        PlanNodeStatsEstimate actual = JOIN_STATS_RULE.calculateJoinComplementStats(Optional.empty(), (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(LEFT_JOIN_COLUMN, RIGHT_JOIN_COLUMN), (Object)new JoinNode.EquiJoinClause(LEFT_OTHER_COLUMN, RIGHT_OTHER_COLUMN)), LEFT_STATS, RIGHT_STATS);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testStatsForLeftAndRightJoin() {
        double innerJoinRowCount = 7000.0;
        double joinComplementRowCount = 237.5;
        double joinComplementColumnNulls = 0.631578947368421;
        double totalRowCount = innerJoinRowCount + joinComplementRowCount;
        PlanNodeStatsEstimate leftJoinStats = TestJoinStatsRule.planNodeStats(totalRowCount, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, joinComplementColumnNulls * joinComplementRowCount / totalRowCount, 20.0), LEFT_OTHER_COLUMN_STATS, TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, joinComplementRowCount / totalRowCount, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_OTHER_COLUMN, 24.0, 24.0, (0.24 * innerJoinRowCount + joinComplementRowCount) / totalRowCount, 1.0));
        this.assertJoinStats(JoinNode.Type.LEFT, LEFT_STATS, RIGHT_STATS, leftJoinStats);
        this.assertJoinStats(JoinNode.Type.RIGHT, RIGHT_JOIN_COLUMN, RIGHT_OTHER_COLUMN, LEFT_JOIN_COLUMN, LEFT_OTHER_COLUMN, RIGHT_STATS, LEFT_STATS, leftJoinStats);
    }

    @Test
    public void testLeftJoinMissingStats() {
        PlanNodeStatsEstimate leftStats = TestJoinStatsRule.planNodeStats(1.0, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(LEFT_OTHER_COLUMN, VariableStatsEstimate.unknown()));
        PlanNodeStatsEstimate rightStats = TestJoinStatsRule.planNodeStats(1.0, new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_OTHER_COLUMN, VariableStatsEstimate.unknown()));
        this.assertJoinStats(JoinNode.Type.LEFT, leftStats, rightStats, PlanNodeStatsEstimate.unknown());
    }

    @Test
    public void testStatsForFullJoin() {
        double innerJoinRowCount = 7000.0;
        double leftJoinComplementRowCount = 237.5;
        double leftJoinComplementColumnNulls = 0.631578947368421;
        double rightJoinComplementRowCount = 600.0;
        double rightJoinComplementColumnNulls = 1.0;
        double totalRowCount = innerJoinRowCount + leftJoinComplementRowCount + rightJoinComplementRowCount;
        PlanNodeStatsEstimate leftJoinStats = TestJoinStatsRule.planNodeStats(totalRowCount, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, (leftJoinComplementColumnNulls * leftJoinComplementRowCount + rightJoinComplementRowCount) / totalRowCount, 20.0), TestJoinStatsRule.variableStatistics(LEFT_OTHER_COLUMN, 42.0, 42.0, (0.42 * (innerJoinRowCount + leftJoinComplementRowCount) + rightJoinComplementRowCount) / totalRowCount, 1.0), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, (rightJoinComplementColumnNulls * rightJoinComplementRowCount + leftJoinComplementRowCount) / totalRowCount, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_OTHER_COLUMN, 24.0, 24.0, (0.24 * (innerJoinRowCount + rightJoinComplementRowCount) + leftJoinComplementRowCount) / totalRowCount, 1.0));
        this.assertJoinStats(JoinNode.Type.FULL, LEFT_STATS, RIGHT_STATS, leftJoinStats);
    }

    @Test
    public void testAddJoinComplementStats() {
        double statsToAddNdv = 5.0;
        PlanNodeStatsEstimate statsToAdd = TestJoinStatsRule.planNodeStats(1000.0, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 5.0, 0.2, statsToAddNdv));
        PlanNodeStatsEstimate addedStats = TestJoinStatsRule.planNodeStats(1500.0, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, 0.23333333333333334, 20.0), TestJoinStatsRule.variableStatistics(LEFT_OTHER_COLUMN, 42.0, 42.0, 0.8066666666666666, 1.0));
        PlanNodeStatsAssertion.assertThat(JOIN_STATS_RULE.addJoinComplementStats(LEFT_STATS, LEFT_STATS, statsToAdd)).equalTo(addedStats);
    }

    private void assertJoinStats(JoinNode.Type joinType, PlanNodeStatsEstimate leftStats, PlanNodeStatsEstimate rightStats, PlanNodeStatsEstimate resultStats) {
        this.assertJoinStats(joinType, LEFT_JOIN_COLUMN, LEFT_OTHER_COLUMN, RIGHT_JOIN_COLUMN, RIGHT_OTHER_COLUMN, leftStats, rightStats, resultStats);
    }

    private void assertJoinStats(JoinNode.Type joinType, VariableReferenceExpression leftJoinColumn, VariableReferenceExpression leftOtherColumn, VariableReferenceExpression rightJoinColumn, VariableReferenceExpression rightOtherColumn, PlanNodeStatsEstimate leftStats, PlanNodeStatsEstimate rightStats, PlanNodeStatsEstimate resultStats) {
        this.tester().assertStatsFor(pb -> {
            VariableReferenceExpression leftJoinColumnVariable = pb.variable(leftJoinColumn);
            VariableReferenceExpression rightJoinColumnVariable = pb.variable(rightJoinColumn);
            VariableReferenceExpression leftOtherColumnVariable = pb.variable(leftOtherColumn);
            VariableReferenceExpression rightOtherColumnVariable = pb.variable(rightOtherColumn);
            return pb.join(joinType, (PlanNode)pb.values(leftJoinColumnVariable, leftOtherColumnVariable), (PlanNode)pb.values(rightJoinColumnVariable, rightOtherColumnVariable), new JoinNode.EquiJoinClause(leftJoinColumnVariable, rightJoinColumnVariable));
        }).withSourceStats(0, leftStats).withSourceStats(1, rightStats).check((ComposableStatsCalculator.Rule<?>)JOIN_STATS_RULE, stats -> stats.equalTo(resultStats));
    }

    private static PlanNodeStatsEstimate planNodeStats(double rowCount, VariableStatistics ... variableStatistics) {
        PlanNodeStatsEstimate.Builder builder = PlanNodeStatsEstimate.builder().setOutputRowCount(rowCount);
        for (VariableStatistics symbolStatistic : variableStatistics) {
            builder.addVariableStatistics(symbolStatistic.variable, symbolStatistic.estimate);
        }
        return builder.build();
    }

    private static VariableStatistics variableStatistics(VariableReferenceExpression variable, double low, double high, double nullsFraction, double ndv) {
        return new VariableStatistics(variable, VariableStatsEstimate.builder().setLowValue(low).setHighValue(high).setNullsFraction(nullsFraction).setDistinctValuesCount(ndv).build());
    }

    private static class VariableStatistics {
        final VariableReferenceExpression variable;
        final VariableStatsEstimate estimate;

        VariableStatistics(String variableName, VariableStatsEstimate estimate) {
            this(new VariableReferenceExpression(variableName, (Type)BigintType.BIGINT), estimate);
        }

        VariableStatistics(VariableReferenceExpression variable, VariableStatsEstimate estimate) {
            this.variable = variable;
            this.estimate = estimate;
        }
    }
}

