/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.BaseStatsCalculatorTest;
import com.facebook.presto.cost.PlanNodeStatsAssertion;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestRowNumberStatsRule
extends BaseStatsCalculatorTest {
    private VariableStatsEstimate xStats = VariableStatsEstimate.builder().setDistinctValuesCount(5.0).setNullsFraction(0.0).build();
    private VariableStatsEstimate yStats = VariableStatsEstimate.builder().setDistinctValuesCount(5.0).setNullsFraction(0.5).build();

    @Test
    public void testSingleGroupingKey() {
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("x", (Type)BigintType.BIGINT)), Optional.empty(), pb.variable("z", (Type)BigintType.BIGINT), (PlanNode)pb.values(pb.variable("x", (Type)BigintType.BIGINT), pb.variable("y", (Type)BigintType.BIGINT)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), this.xStats).addVariableStatistics(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), this.yStats).build()).check(check -> check.outputRowsCount(10.0).variableStats(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), assertion -> assertion.isEqualTo(this.xStats)).variableStats(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), assertion -> assertion.isEqualTo(this.yStats)).variableStats(new VariableReferenceExpression("z", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(1.0).distinctValuesCount(2.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("x", (Type)BigintType.BIGINT)), Optional.of(1), pb.variable("z", (Type)BigintType.BIGINT), (PlanNode)pb.values(pb.variable("x", (Type)BigintType.BIGINT), pb.variable("y", (Type)BigintType.BIGINT)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), this.xStats).addVariableStatistics(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), this.yStats).build()).check(check -> check.outputRowsCount(5.0).variableStats(new VariableReferenceExpression("z", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(1.0).distinctValuesCount(1.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("y", (Type)BigintType.BIGINT)), Optional.empty(), pb.variable("z", (Type)BigintType.BIGINT), (PlanNode)pb.values(pb.variable("x", (Type)BigintType.BIGINT), pb.variable("y", (Type)BigintType.BIGINT)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(60.0).addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), this.xStats).addVariableStatistics(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), this.yStats).build()).check(check -> check.outputRowsCount(60.0).variableStats(new VariableReferenceExpression("z", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(1.0).distinctValuesCount(10.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("x", (Type)BigintType.BIGINT)), Optional.of(1), pb.variable("z", (Type)BigintType.BIGINT), (PlanNode)pb.values(pb.variable("x", (Type)BigintType.BIGINT), pb.variable("y", (Type)BigintType.BIGINT)))).withSourceStats(0, PlanNodeStatsEstimate.builder().addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), this.xStats).addVariableStatistics(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), this.yStats).build()).check(PlanNodeStatsAssertion::outputRowsCountUnknown);
    }

    @Test
    public void testMultipleGroupingKeys() {
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("x", (Type)BigintType.BIGINT), (Object)pb.variable("y", (Type)BigintType.BIGINT)), Optional.empty(), pb.variable("z", (Type)BigintType.BIGINT), (PlanNode)pb.values(pb.variable("x", (Type)BigintType.BIGINT), pb.variable("y", (Type)BigintType.BIGINT)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(60.0).addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), this.xStats).addVariableStatistics(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), this.yStats).build()).check(check -> check.outputRowsCount(60.0).variableStats(new VariableReferenceExpression("z", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(1.0).distinctValuesCount(2.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("x", (Type)BigintType.BIGINT), (Object)pb.variable("y", (Type)BigintType.BIGINT)), Optional.empty(), pb.variable("z", (Type)BigintType.BIGINT), (PlanNode)pb.values(pb.variable("x", (Type)BigintType.BIGINT), pb.variable("y", (Type)BigintType.BIGINT)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(20.0).addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), this.xStats).addVariableStatistics(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), this.yStats).build()).check(check -> check.outputRowsCount(20.0).variableStats(new VariableReferenceExpression("z", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(1.0).distinctValuesCount(1.0).nullsFraction(0.0).averageRowSize(BigintType.BIGINT.getFixedSize())));
        this.tester().assertStatsFor(pb -> pb.rowNumber((List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("x", (Type)BigintType.BIGINT), (Object)pb.variable("y", (Type)BigintType.BIGINT)), Optional.empty(), pb.variable("z", (Type)BigintType.BIGINT), (PlanNode)pb.values(pb.variable("x", (Type)BigintType.BIGINT), pb.variable("y", (Type)BigintType.BIGINT)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(20.0).addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), this.xStats).addVariableStatistics(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), VariableStatsEstimate.unknown()).build()).check(PlanNodeStatsAssertion::outputRowsCountUnknown);
    }
}

