/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.assertions.PlanAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.annotations.Test;

public class TestStatsCalculator {
    private final LocalQueryRunner queryRunner = new LocalQueryRunner(TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("task_concurrency", "1").build());

    public TestStatsCalculator() {
        this.queryRunner.createCatalog((String)this.queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @Test
    public void testStatsCalculatorUsesLayout() {
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderstatus = 'P'", PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).withOutputRowCount(363.0)));
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderkey = 42", PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).withOutputRowCount(15000.0)));
    }

    private void assertPlan(String sql, PlanMatchPattern pattern) {
        this.assertPlan(sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, pattern);
    }

    private void assertPlan(String sql, LogicalPlanner.Stage stage, PlanMatchPattern pattern) {
        this.queryRunner.inTransaction(transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql, stage, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, this.queryRunner.getMetadata(), this.queryRunner.getStatsCalculator(), actualPlan, pattern);
            return null;
        });
    }
}

