/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.Session;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.dispatcher.LocalDispatchQuery;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.event.QueryMonitorConfig;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.ClusterSizeMonitor;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.resourceGroups.QueryQueueFullException;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.spi.eventlistener.EventListenerFactory;
import com.facebook.presto.spi.eventlistener.QueryCompletedEvent;
import com.facebook.presto.spi.eventlistener.QueryCreatedEvent;
import com.facebook.presto.spi.eventlistener.QueryFailureInfo;
import com.facebook.presto.spi.eventlistener.SplitCompletedEvent;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLocalDispatchQuery {
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testSimpleExecutionCreationFailure() {
        CountingEventListener eventListener = new CountingEventListener();
        LocalDispatchQuery query = new LocalDispatchQuery(this.createStateMachine(), this.createQueryMonitor(eventListener), Futures.immediateFailedFuture((Throwable)new IllegalStateException("abc")), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), execution -> {});
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().isPresent());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().get().getFailureInfo().isPresent());
        Assert.assertEquals((Object)((QueryFailureInfo)eventListener.getQueryCompletedEvent().get().getFailureInfo().get()).getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
    }

    @Test
    public void testQueryQueuedExceptionBeforeDispatch() {
        QueryStateMachine stateMachine = this.createStateMachine();
        stateMachine.transitionToFailed((Throwable)new QueryQueueFullException(new ResourceGroupId("global")));
        CountingEventListener eventListener = new CountingEventListener();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFailedFuture((Throwable)new IllegalStateException("abc")), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), execution -> {});
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getErrorCode(), (Object)StandardErrorCode.QUERY_QUEUE_FULL.toErrorCode());
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
    }

    @Test
    public void testErrorInQuerySubmitter() {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFuture(null), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), execution -> {
            throw new AccessDeniedException("sdf");
        });
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.QUEUED);
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
        query.startWaitingForResources();
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getErrorCode(), (Object)StandardErrorCode.PERMISSION_DENIED.toErrorCode());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().isPresent());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().get().getFailureInfo().isPresent());
        Assert.assertEquals((Object)((QueryFailureInfo)eventListener.getQueryCompletedEvent().get().getFailureInfo().get()).getErrorCode(), (Object)StandardErrorCode.PERMISSION_DENIED.toErrorCode());
    }

    @Test
    public void testTimeOutWaitingForClusterResources() throws Exception {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFuture(null), this.createClusterSizeMonitor(1), MoreExecutors.directExecutor(), execution -> {});
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.QUEUED);
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
        query.startWaitingForResources();
        Thread.sleep(300L);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getErrorCode(), (Object)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES.toErrorCode());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().isPresent());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().get().getFailureInfo().isPresent());
        Assert.assertEquals((Object)((QueryFailureInfo)eventListener.getQueryCompletedEvent().get().getFailureInfo().get()).getErrorCode(), (Object)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES.toErrorCode());
    }

    @Test
    public void testQueryCancellation() {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFuture(null), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), execution -> {});
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.QUEUED);
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
        query.cancel();
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((Object)query.getBasicQueryInfo().getErrorCode(), (Object)StandardErrorCode.USER_CANCELED.toErrorCode());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().isPresent());
        Assert.assertTrue((boolean)eventListener.getQueryCompletedEvent().get().getFailureInfo().isPresent());
        Assert.assertEquals((Object)((QueryFailureInfo)eventListener.getQueryCompletedEvent().get().getFailureInfo().get()).getErrorCode(), (Object)StandardErrorCode.USER_CANCELED.toErrorCode());
    }

    @Test
    public void testQueryDispatched() {
        QueryStateMachine stateMachine = this.createStateMachine();
        CountingEventListener eventListener = new CountingEventListener();
        LocalDispatchQuery query = new LocalDispatchQuery(stateMachine, this.createQueryMonitor(eventListener), Futures.immediateFuture(null), this.createClusterSizeMonitor(0), MoreExecutors.directExecutor(), execution -> {});
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.QUEUED);
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
        query.startWaitingForResources();
        Assert.assertEquals((Object)query.getBasicQueryInfo().getState(), (Object)QueryState.DISPATCHING);
        Assert.assertNull((Object)query.getBasicQueryInfo().getErrorCode());
        Assert.assertFalse((boolean)eventListener.getQueryCompletedEvent().isPresent());
    }

    private ClusterSizeMonitor createClusterSizeMonitor(int minimumNodes) {
        return new ClusterSizeMonitor((InternalNodeManager)new InMemoryNodeManager(), true, minimumNodes, new Duration(10.0, TimeUnit.MILLISECONDS), 1, new Duration(1.0, TimeUnit.SECONDS));
    }

    private QueryMonitor createQueryMonitor(CountingEventListener eventListener) {
        EventListenerManager eventListenerManager = this.createEventListenerManager(eventListener);
        return new QueryMonitor(JsonCodec.jsonCodec(StageInfo.class), JsonCodec.jsonCodec(ExecutionFailureInfo.class), JsonCodec.jsonCodec(OperatorInfo.class), eventListenerManager, new NodeInfo("test"), NodeVersion.UNKNOWN, new SessionPropertyManager(), (Metadata)this.metadata, new QueryMonitorConfig());
    }

    private EventListenerManager createEventListenerManager(CountingEventListener countingEventListener) {
        EventListenerManager eventListenerManager = new EventListenerManager();
        eventListenerManager.addEventListenerFactory((EventListenerFactory)new TestEventListenerFactory(countingEventListener));
        eventListenerManager.loadConfiguredEventListener((Map)ImmutableMap.of((Object)"event-listener.name", (Object)"name"));
        return eventListenerManager;
    }

    private QueryStateMachine createStateMachine() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").setTransactionId(transactionManager.beginTransaction(false)).build();
        return QueryStateMachine.begin((String)"COMMIT", (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), Optional.empty(), (boolean)true, (TransactionManager)transactionManager, (AccessControl)new AccessControlManager(transactionManager), (Executor)MoreExecutors.directExecutor(), (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP);
    }

    private static class CountingEventListener
    implements EventListener {
        private final AtomicReference<QueryCompletedEvent> queryCompletedEvent = new AtomicReference();

        private CountingEventListener() {
        }

        public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
            Assert.fail((String)"Query creation events should not be created in this test");
        }

        public void queryCompleted(QueryCompletedEvent event) {
            Assert.assertTrue((boolean)this.queryCompletedEvent.compareAndSet(null, Objects.requireNonNull(event, "event is null")), (String)"Duplicate completion event sent");
        }

        public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
            Assert.fail((String)"splitCompleted should never be called");
        }

        public Optional<QueryCompletedEvent> getQueryCompletedEvent() {
            return Optional.ofNullable(this.queryCompletedEvent.get());
        }
    }

    private static class TestEventListenerFactory
    implements EventListenerFactory {
        public static final String NAME = "name";
        private final CountingEventListener countingEventListener;

        public TestEventListenerFactory(CountingEventListener countingEventListener) {
            this.countingEventListener = Objects.requireNonNull(countingEventListener, "countingEventListener is null");
        }

        public String getName() {
            return NAME;
        }

        public EventListener create(Map<String, String> config) {
            return this.countingEventListener;
        }
    }
}

