/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.ManagedQueryExecution;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.BasicQueryStats;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class MockManagedQueryExecution
implements ManagedQueryExecution {
    private final List<StateMachine.StateChangeListener<QueryState>> listeners = new ArrayList<StateMachine.StateChangeListener<QueryState>>();
    private final DataSize memoryUsage;
    private final Duration cpuUsage;
    private final Session session;
    private QueryState state = QueryState.QUEUED;
    private Throwable failureCause;

    public MockManagedQueryExecution(long memoryUsage) {
        this(memoryUsage, "query_id", 1);
    }

    public MockManagedQueryExecution(long memoryUsage, String queryId, int priority) {
        this(memoryUsage, queryId, priority, new Duration(0.0, TimeUnit.MILLISECONDS));
    }

    public MockManagedQueryExecution(long memoryUsage, String queryId, int priority, Duration cpuUsage) {
        this.memoryUsage = DataSize.succinctBytes((long)memoryUsage);
        this.cpuUsage = cpuUsage;
        this.session = TestingSession.testSessionBuilder().setSystemProperty("query_priority", String.valueOf(priority)).build();
    }

    public void complete() {
        this.state = QueryState.FINISHED;
        this.fireStateChange();
    }

    public Throwable getThrowable() {
        return this.failureCause;
    }

    public Session getSession() {
        return this.session;
    }

    public Optional<ErrorCode> getErrorCode() {
        return Optional.empty();
    }

    public BasicQueryInfo getBasicQueryInfo() {
        return new BasicQueryInfo(new QueryId("test"), this.session.toSessionRepresentation(), Optional.empty(), this.state, new MemoryPoolId("test"), !this.state.isDone(), URI.create("http://test"), "SELECT 1", new BasicQueryStats(new DateTime(1L), new DateTime(2L), new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), 5, 6, 7, 8, 9, new DataSize(14.0, DataSize.Unit.BYTE), 15L, 16.0, new DataSize(17.0, DataSize.Unit.BYTE), new DataSize(18.0, DataSize.Unit.BYTE), new DataSize(19.0, DataSize.Unit.BYTE), new DataSize(20.0, DataSize.Unit.BYTE), new DataSize(21.0, DataSize.Unit.BYTE), new DataSize(42.0, DataSize.Unit.BYTE), new Duration(22.0, TimeUnit.NANOSECONDS), new Duration(23.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), new DataSize(24.0, DataSize.Unit.BYTE), OptionalDouble.empty()), null, Optional.empty(), (List)ImmutableList.of());
    }

    public DataSize getUserMemoryReservation() {
        return this.memoryUsage;
    }

    public DataSize getTotalMemoryReservation() {
        return this.memoryUsage;
    }

    public Duration getTotalCpuTime() {
        return this.cpuUsage;
    }

    public QueryState getState() {
        return this.state;
    }

    public void startWaitingForResources() {
        this.state = QueryState.RUNNING;
        this.fireStateChange();
    }

    public void fail(Throwable cause) {
        this.state = QueryState.FAILED;
        this.failureCause = cause;
        this.fireStateChange();
    }

    public boolean isDone() {
        return this.getState().isDone();
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.listeners.add(stateChangeListener);
    }

    private void fireStateChange() {
        for (StateMachine.StateChangeListener<QueryState> listener : this.listeners) {
            listener.stateChanged((Object)this.state);
        }
    }
}

