/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.execution.ClusterSizeMonitor;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.ConnectorId;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestClusterSizeMonitor {
    public static final ConnectorId CONNECTOR_ID = new ConnectorId("dummy");
    public static final int DESIRED_WORKER_COUNT = 10;
    public static final int DESIRED_COORDINATOR_COUNT = 3;
    private InMemoryNodeManager nodeManager;
    private ClusterSizeMonitor monitor;
    private CountDownLatch minWorkersLatch;
    private CountDownLatch minCoordinatorsLatch;
    private AtomicInteger numWorkers;
    private AtomicInteger numCoordinators;
    private AtomicBoolean workersTimeout;
    private AtomicBoolean coordinatorsTimeout;

    @BeforeMethod
    public void setUp() {
        this.numWorkers = new AtomicInteger(0);
        this.numCoordinators = new AtomicInteger(0);
        this.workersTimeout = new AtomicBoolean();
        this.coordinatorsTimeout = new AtomicBoolean();
        this.nodeManager = new InMemoryNodeManager();
        this.monitor = new ClusterSizeMonitor((InternalNodeManager)this.nodeManager, false, 10, new Duration(4.0, TimeUnit.SECONDS), 3, new Duration(4.0, TimeUnit.SECONDS));
        this.minWorkersLatch = new CountDownLatch(1);
        this.minCoordinatorsLatch = new CountDownLatch(1);
        this.monitor.start();
    }

    @AfterMethod
    public void tearDown() {
        this.monitor.stop();
    }

    @Test(timeOut=60000L)
    public void testWaitForMinimumCoordinatorsAndWorkers() throws InterruptedException {
        int i;
        ListenableFuture<?> workersFuture = this.waitForMinimumWorkers();
        ListenableFuture<?> coordinatorsFuture = this.waitForMinimumCoordinators();
        for (i = this.numWorkers.get(); i < 9; ++i) {
            Assert.assertFalse((boolean)this.workersTimeout.get());
            this.addWorker(this.nodeManager);
        }
        Assert.assertFalse((boolean)this.workersTimeout.get());
        Assert.assertEquals((long)this.minWorkersLatch.getCount(), (long)1L);
        this.addWorker(this.nodeManager);
        this.minWorkersLatch.await(1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)workersFuture.isDone());
        Assert.assertFalse((boolean)this.workersTimeout.get());
        for (i = this.numCoordinators.get(); i < 2; ++i) {
            Assert.assertFalse((boolean)this.coordinatorsTimeout.get());
            this.addCoordinator(this.nodeManager);
        }
        Assert.assertFalse((boolean)this.coordinatorsTimeout.get());
        Assert.assertEquals((long)this.minCoordinatorsLatch.getCount(), (long)1L);
        this.addCoordinator(this.nodeManager);
        this.minCoordinatorsLatch.await(2L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)coordinatorsFuture.isDone());
        Assert.assertFalse((boolean)this.coordinatorsTimeout.get());
    }

    @Test(timeOut=10000L)
    public void testTimeoutWaitingForWorkers() throws InterruptedException {
        this.waitForMinimumWorkers();
        Assert.assertFalse((boolean)this.workersTimeout.get());
        this.addWorker(this.nodeManager);
        Assert.assertFalse((boolean)this.workersTimeout.get());
        Assert.assertEquals((long)this.minWorkersLatch.getCount(), (long)1L);
        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        Assert.assertTrue((boolean)this.workersTimeout.get());
        Assert.assertEquals((long)this.minWorkersLatch.getCount(), (long)0L);
    }

    @Test(timeOut=10000L)
    public void testTimeoutWaitingForCoordinators() throws InterruptedException {
        this.waitForMinimumCoordinators();
        Assert.assertFalse((boolean)this.coordinatorsTimeout.get());
        this.addCoordinator(this.nodeManager);
        Assert.assertFalse((boolean)this.coordinatorsTimeout.get());
        Assert.assertEquals((long)this.minCoordinatorsLatch.getCount(), (long)1L);
        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        Assert.assertTrue((boolean)this.coordinatorsTimeout.get());
        Assert.assertEquals((long)this.minCoordinatorsLatch.getCount(), (long)0L);
    }

    private ListenableFuture<?> waitForMinimumWorkers() {
        ListenableFuture workersFuture = this.monitor.waitForMinimumWorkers();
        MoreFutures.addSuccessCallback((ListenableFuture)workersFuture, () -> {
            Assert.assertFalse((boolean)this.workersTimeout.get());
            this.minWorkersLatch.countDown();
        });
        MoreFutures.addExceptionCallback((ListenableFuture)workersFuture, () -> {
            Assert.assertTrue((boolean)this.workersTimeout.compareAndSet(false, true));
            this.minWorkersLatch.countDown();
        });
        return workersFuture;
    }

    private ListenableFuture<?> waitForMinimumCoordinators() {
        ListenableFuture coordinatorsFuture = this.monitor.waitForMinimumCoordinators();
        MoreFutures.addSuccessCallback((ListenableFuture)coordinatorsFuture, () -> {
            Assert.assertFalse((boolean)this.coordinatorsTimeout.get());
            this.minCoordinatorsLatch.countDown();
        });
        MoreFutures.addExceptionCallback((ListenableFuture)coordinatorsFuture, () -> {
            Assert.assertTrue((boolean)this.coordinatorsTimeout.compareAndSet(false, true));
            this.minCoordinatorsLatch.countDown();
        });
        return coordinatorsFuture;
    }

    private void addWorker(InMemoryNodeManager nodeManager) {
        String identifier = "worker/" + this.numWorkers.incrementAndGet();
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode(identifier, URI.create("localhost/" + identifier), new NodeVersion("1"), false)});
    }

    private void addCoordinator(InMemoryNodeManager nodeManager) {
        String identifier = "coordinator/" + this.numCoordinators.incrementAndGet();
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode(identifier, URI.create("localhost/" + identifier), new NodeVersion("1"), true)});
    }
}

