/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.execution.CommitTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestCommitTask {
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stage-executor-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testCommit() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestCommitTask.sessionBuilder().setTransactionId(transactionManager.beginTransaction(false)).build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("COMMIT", session, transactionManager);
        Assert.assertTrue((boolean)stateMachine.getSession().getTransactionId().isPresent());
        Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
        MoreFutures.getFutureValue((Future)new CommitTask().execute(new Commit(), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
        Assert.assertTrue((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
    }

    @Test
    public void testNoTransactionCommit() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestCommitTask.sessionBuilder().build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("COMMIT", session, transactionManager);
        try {
            MoreFutures.getFutureValue((Future)new CommitTask().execute(new Commit(), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
            Assert.fail();
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_IN_TRANSACTION.toErrorCode());
        }
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
    }

    @Test
    public void testUnknownTransactionCommit() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestCommitTask.sessionBuilder().setTransactionId(TransactionId.create()).build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("COMMIT", session, transactionManager);
        try {
            MoreFutures.getFutureValue((Future)new CommitTask().execute(new Commit(), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
            Assert.fail();
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.UNKNOWN_TRANSACTION.toErrorCode());
        }
        Assert.assertTrue((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
    }

    private QueryStateMachine createQueryStateMachine(String query, Session session, TransactionManager transactionManager) {
        return QueryStateMachine.begin((String)query, (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), Optional.empty(), (boolean)true, (TransactionManager)transactionManager, (AccessControl)new AccessControlManager(transactionManager), (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP);
    }

    private static Session.SessionBuilder sessionBuilder() {
        return TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny");
    }
}

