/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.execution.MockRemoteTaskFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.NetworkLocation;
import com.facebook.presto.execution.scheduler.NetworkLocationCache;
import com.facebook.presto.execution.scheduler.NetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.SplitPlacementResult;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelectionStats;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelector;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.util.FinalizerService;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestNodeScheduler {
    private static final ConnectorId CONNECTOR_ID = new ConnectorId("connector_id");
    private FinalizerService finalizerService;
    private NodeTaskMap nodeTaskMap;
    private InMemoryNodeManager nodeManager;
    private NodeSelector nodeSelector;
    private Map<InternalNode, RemoteTask> taskMap;
    private ExecutorService remoteTaskExecutor;
    private ScheduledExecutorService remoteTaskScheduledExecutor;

    @BeforeMethod
    public void setUp() {
        this.finalizerService = new FinalizerService();
        this.nodeTaskMap = new NodeTaskMap(this.finalizerService);
        this.nodeManager = new InMemoryNodeManager();
        ImmutableList.Builder nodeBuilder = ImmutableList.builder();
        nodeBuilder.add((Object)new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false));
        nodeBuilder.add((Object)new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false));
        nodeBuilder.add((Object)new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false));
        ImmutableList nodes = nodeBuilder.build();
        this.nodeManager.addNode(CONNECTOR_ID, (Iterable)nodes);
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)this.nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, this.nodeTaskMap);
        this.taskMap = new HashMap<InternalNode, RemoteTask>();
        this.nodeSelector = nodeScheduler.createNodeSelector(CONNECTOR_ID);
        this.remoteTaskExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"remoteTaskExecutor-%s"));
        this.remoteTaskScheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"remoteTaskScheduledExecutor-%s"));
        this.finalizerService.start();
    }

    @AfterMethod
    public void tearDown() {
        this.remoteTaskExecutor.shutdown();
        this.remoteTaskScheduledExecutor.shutdown();
        this.finalizerService.destroy();
    }

    @Test
    public void testScheduleLocal() {
        Split split = new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitLocal());
        ImmutableSet splits = ImmutableSet.of((Object)split);
        Map.Entry assignment = (Map.Entry)Iterables.getOnlyElement((Iterable)this.nodeSelector.computeAssignments((Set)splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments().entries());
        Assert.assertEquals((Object)((InternalNode)assignment.getKey()).getHostAndPort(), split.getPreferredNodes((List)ImmutableList.of()).get(0));
        Assert.assertEquals(assignment.getValue(), (Object)split);
    }

    @Test(timeOut=60000L)
    public void testTopologyAwareScheduling() throws Exception {
        int i;
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        ImmutableList.Builder nodeBuilder = ImmutableList.builder();
        nodeBuilder.add((Object)new InternalNode("node1", URI.create("http://host1.rack1:11"), NodeVersion.UNKNOWN, false));
        nodeBuilder.add((Object)new InternalNode("node2", URI.create("http://host2.rack1:12"), NodeVersion.UNKNOWN, false));
        nodeBuilder.add((Object)new InternalNode("node3", URI.create("http://host3.rack2:13"), NodeVersion.UNKNOWN, false));
        ImmutableList nodes = nodeBuilder.build();
        nodeManager.addNode(CONNECTOR_ID, (Iterable)nodes);
        HashMap<InternalNode, MockRemoteTaskFactory.MockRemoteTask> taskMap = new HashMap<InternalNode, MockRemoteTaskFactory.MockRemoteTask>();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(25).setIncludeCoordinator(false).setNetworkTopology("test").setMaxPendingSplitsPerTask(20);
        final TestNetworkTopology topology = new TestNetworkTopology();
        NetworkLocationCache locationCache = new NetworkLocationCache(topology){

            public NetworkLocation get(HostAddress host) {
                if (host.getHostText().startsWith("host")) {
                    return topology.locate(host);
                }
                return super.get(host);
            }
        };
        NodeScheduler nodeScheduler = new NodeScheduler(locationCache, (NetworkTopology)topology, (InternalNodeManager)nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap, new Duration(5.0, TimeUnit.SECONDS));
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(CONNECTOR_ID);
        ImmutableSet.Builder nonRackLocalBuilder = ImmutableSet.builder();
        for (int i2 = 0; i2 < 108; ++i2) {
            nonRackLocalBuilder.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"data.other_rack", (int)1))));
        }
        ImmutableSet nonRackLocalSplits = nonRackLocalBuilder.build();
        Multimap assignments = nodeSelector.computeAssignments((Set)nonRackLocalSplits, (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        int task = 0;
        for (InternalNode node : assignments.keySet()) {
            TaskId taskId = new TaskId("test", 1, 0, task);
            ++task;
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)ImmutableList.copyOf((Collection)assignments.get((Object)node)), nodeTaskMap.createPartitionedSplitCountTracker(node, taskId));
            remoteTask.startSplits(25);
            nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            taskMap.put(node, remoteTask);
        }
        nonRackLocalSplits = Sets.difference((Set)nonRackLocalSplits, new HashSet(assignments.values()));
        assignments = nodeSelector.computeAssignments((Set)nonRackLocalSplits, (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        for (InternalNode node : assignments.keySet()) {
            RemoteTask remoteTask = (RemoteTask)taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments.get((Object)node)).build());
        }
        nonRackLocalSplits = Sets.difference((Set)nonRackLocalSplits, new HashSet(assignments.values()));
        Assert.assertEquals((int)nonRackLocalSplits.size(), (int)3);
        ImmutableSet.Builder rackLocalSplits = ImmutableSet.builder();
        HostAddress dataHost1 = HostAddress.fromParts((String)"data.rack1", (int)1);
        HostAddress dataHost2 = HostAddress.fromParts((String)"data.rack2", (int)1);
        for (i = 0; i < 12; ++i) {
            rackLocalSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(dataHost1)));
        }
        for (i = 0; i < 6; ++i) {
            rackLocalSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(dataHost2)));
        }
        assignments = nodeSelector.computeAssignments((Set)rackLocalSplits.build(), (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        for (InternalNode node : assignments.keySet()) {
            RemoteTask remoteTask = (RemoteTask)taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments.get((Object)node)).build());
        }
        Sets.SetView unassigned = Sets.difference((Set)rackLocalSplits.build(), new HashSet(assignments.values()));
        boolean cacheRefreshed = false;
        while (!cacheRefreshed) {
            cacheRefreshed = true;
            if (locationCache.get(dataHost1).equals((Object)NetworkLocation.ROOT_LOCATION)) {
                cacheRefreshed = false;
            }
            if (locationCache.get(dataHost2).equals((Object)NetworkLocation.ROOT_LOCATION)) {
                cacheRefreshed = false;
            }
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        assignments = nodeSelector.computeAssignments((Set)unassigned, (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        for (InternalNode node : assignments.keySet()) {
            RemoteTask remoteTask = (RemoteTask)taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments.get((Object)node)).build());
        }
        unassigned = Sets.difference((Set)unassigned, new HashSet(assignments.values()));
        Assert.assertEquals((int)unassigned.size(), (int)3);
        int rack1 = 0;
        int rack2 = 0;
        block16: for (Split split : unassigned) {
            String rack;
            switch (rack = (String)topology.locate((HostAddress)split.getPreferredNodes((List)ImmutableList.of()).get(0)).getSegments().get(0)) {
                case "rack1": {
                    ++rack1;
                    continue block16;
                }
                case "rack2": {
                    ++rack2;
                    continue block16;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((int)rack1, (int)2);
        Assert.assertEquals((int)rack2, (int)1);
        ImmutableSet.Builder localSplits = ImmutableSet.builder();
        localSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"host1.rack1", (int)1))));
        localSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"host2.rack1", (int)1))));
        localSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"host3.rack2", (int)1))));
        assignments = nodeSelector.computeAssignments((Set)localSplits.build(), (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.size(), (int)3);
        Assert.assertEquals((int)assignments.keySet().size(), (int)3);
    }

    @Test
    public void testScheduleRemote() {
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()));
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.size(), (int)1);
    }

    @Test
    public void testBasicAssignment() {
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < 3; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.entries().size(), (int)3);
        for (InternalNode node : this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID)) {
            Assert.assertTrue((boolean)assignments.keySet().contains(node));
        }
    }

    @Test
    public void testAffinityAssignmentNotSupported() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)this.nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap);
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(CONNECTOR_ID, 2);
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(HostAddress.fromString((String)"127.0.0.1:10"))));
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(HostAddress.fromString((String)"127.0.0.1:10"))));
        SplitPlacementResult splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Set internalNodes = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodes.size(), (int)2);
    }

    @Test
    public void testAffinityAssignment() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)this.nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap);
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(CONNECTOR_ID, 3);
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestAffinitySplitRemote(1)));
        SplitPlacementResult splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Set internalNodes = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodes.size(), (int)1);
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestAffinitySplitRemote(2)));
        splitPlacementResult = nodeSelector.computeAssignments(splits, this.getRemoteTableScanTask(splitPlacementResult));
        Set internalNodesSecondCall = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodesSecondCall.size(), (int)2);
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestAffinitySplitRemote(4)));
        splitPlacementResult = nodeSelector.computeAssignments(splits, this.getRemoteTableScanTask(splitPlacementResult));
        Assert.assertEquals((int)splitPlacementResult.getAssignments().keySet().size(), (int)2);
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestAffinitySplitRemote(3)));
        splitPlacementResult = nodeSelector.computeAssignments(splits, this.getRemoteTableScanTask(splitPlacementResult));
        Assert.assertEquals((int)splitPlacementResult.getAssignments().keySet().size(), (int)3);
    }

    @Test
    public void testHardAffinityAssignment() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)this.nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap);
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(CONNECTOR_ID, 3);
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestHardAffinitySplitRemote()));
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestHardAffinitySplitRemote()));
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestHardAffinitySplitRemote()));
        SplitPlacementResult splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        for (Split split : splitPlacementResult.getAssignments().values()) {
            Assert.assertTrue((boolean)split.getSplitContext().isCacheable());
        }
    }

    @Test
    public void testMaxSplitsPerNode() {
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        InternalNode newNode = new InternalNode("other4", URI.create("http://127.0.0.1:14"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{newNode});
        ImmutableList.Builder initialSplits = ImmutableList.builder();
        for (int i = 0; i < 10; ++i) {
            initialSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        }
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        TaskId taskId1 = new TaskId("test", 1, 0, 1);
        MockRemoteTaskFactory.MockRemoteTask remoteTask1 = remoteTaskFactory.createTableScanTask(taskId1, newNode, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(newNode, taskId1));
        this.nodeTaskMap.addTask(newNode, (RemoteTask)remoteTask1);
        TaskId taskId2 = new TaskId("test", 1, 0, 2);
        MockRemoteTaskFactory.MockRemoteTask remoteTask2 = remoteTaskFactory.createTableScanTask(taskId2, newNode, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(newNode, taskId2));
        this.nodeTaskMap.addTask(newNode, (RemoteTask)remoteTask2);
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < 5; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertFalse((boolean)assignments.keySet().contains(newNode));
        remoteTask1.abort();
        remoteTask2.abort();
        Assert.assertEquals((int)this.nodeTaskMap.getPartitionedSplitsOnNode(newNode), (int)0);
    }

    @Test
    public void testMaxSplitsPerNodePerTask() {
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        InternalNode newNode = new InternalNode("other4", URI.create("http://127.0.0.1:14"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{newNode});
        ImmutableList.Builder initialSplits = ImmutableList.builder();
        for (int i = 0; i < 20; ++i) {
            initialSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        }
        ArrayList<MockRemoteTaskFactory.MockRemoteTask> tasks = new ArrayList<MockRemoteTaskFactory.MockRemoteTask>();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        for (InternalNode node : this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID)) {
            TaskId taskId = new TaskId("test", 1, 0, 1);
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(node, taskId));
            this.nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            tasks.add(remoteTask);
        }
        TaskId taskId = new TaskId("test", 1, 0, 2);
        MockRemoteTaskFactory.MockRemoteTask newRemoteTask = remoteTaskFactory.createTableScanTask(taskId, newNode, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(newNode, taskId));
        this.taskMap.put(newNode, newRemoteTask);
        this.nodeTaskMap.addTask(newNode, (RemoteTask)newRemoteTask);
        tasks.add(newRemoteTask);
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < 5; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.keySet().size(), (int)3);
        Assert.assertFalse((boolean)assignments.keySet().contains(newNode));
        for (RemoteTask remoteTask : tasks) {
            remoteTask.abort();
        }
        Assert.assertEquals((int)this.nodeTaskMap.getPartitionedSplitsOnNode(newNode), (int)0);
    }

    @Test
    public void testTaskCompletion() throws Exception {
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        InternalNode chosenNode = (InternalNode)Iterables.get((Iterable)this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID), (int)0);
        TaskId taskId = new TaskId("test", 1, 0, 1);
        MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createPartitionedSplitCountTracker(chosenNode, taskId));
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask);
        Assert.assertEquals((int)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (int)1);
        remoteTask.abort();
        TimeUnit.MILLISECONDS.sleep(100L);
        Assert.assertEquals((int)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (int)0);
        remoteTask.abort();
        Assert.assertEquals((int)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (int)0);
    }

    @Test
    public void testSplitCount() {
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        InternalNode chosenNode = (InternalNode)Iterables.get((Iterable)this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID), (int)0);
        TaskId taskId1 = new TaskId("test", 1, 0, 1);
        MockRemoteTaskFactory.MockRemoteTask remoteTask1 = remoteTaskFactory.createTableScanTask(taskId1, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()), (Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createPartitionedSplitCountTracker(chosenNode, taskId1));
        TaskId taskId2 = new TaskId("test", 1, 0, 2);
        MockRemoteTaskFactory.MockRemoteTask remoteTask2 = remoteTaskFactory.createTableScanTask(taskId2, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createPartitionedSplitCountTracker(chosenNode, taskId2));
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask1);
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask2);
        Assert.assertEquals((int)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (int)3);
        remoteTask1.abort();
        Assert.assertEquals((int)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (int)1);
        remoteTask2.abort();
        Assert.assertEquals((int)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (int)0);
    }

    @Test
    public void testMaxTasksPerStageWittLimit() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)this.nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap);
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(CONNECTOR_ID, 2);
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        SplitPlacementResult splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Set internalNodes = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodes.size(), (int)1);
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        splitPlacementResult = nodeSelector.computeAssignments(splits, this.getRemoteTableScanTask(splitPlacementResult));
        Set internalNodesSecondCall = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodesSecondCall.size(), (int)2);
        Assert.assertTrue((boolean)internalNodesSecondCall.containsAll(internalNodes));
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        splitPlacementResult = nodeSelector.computeAssignments(splits, this.getRemoteTableScanTask(splitPlacementResult));
        Assert.assertEquals((int)splitPlacementResult.getAssignments().keySet().size(), (int)2);
        Assert.assertEquals((Set)splitPlacementResult.getAssignments().keySet(), (Set)internalNodesSecondCall);
    }

    @Test
    public void testMaxTasksPerStageAddingNewNodes() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        LegacyNetworkTopology networkTopology = new LegacyNetworkTopology();
        NodeScheduler nodeScheduler = new NodeScheduler(new NetworkLocationCache((NetworkTopology)networkTopology), (NetworkTopology)networkTopology, (InternalNodeManager)nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap, Duration.valueOf((String)"0s"));
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(CONNECTOR_ID, 2);
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        nodeManager.addNode(CONNECTOR_ID, (Iterable)ImmutableList.of((Object)new InternalNode("node1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false)));
        SplitPlacementResult splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Set internalNodes = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodes.size(), (int)1);
        nodeManager.addNode(CONNECTOR_ID, (Iterable)ImmutableList.of((Object)new InternalNode("node2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false)));
        splitPlacementResult = nodeSelector.computeAssignments(splits, this.getRemoteTableScanTask(splitPlacementResult));
        Set internalNodesSecondCall = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodesSecondCall.size(), (int)2);
        Assert.assertTrue((boolean)internalNodesSecondCall.containsAll(internalNodes));
        nodeManager.addNode(CONNECTOR_ID, (Iterable)ImmutableList.of((Object)new InternalNode("node2", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)));
        internalNodes = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodes.size(), (int)2);
        Assert.assertTrue((boolean)internalNodesSecondCall.containsAll(internalNodes));
    }

    private List<RemoteTask> getRemoteTableScanTask(SplitPlacementResult splitPlacementResult) {
        HashMap<InternalNode, MockRemoteTaskFactory.MockRemoteTask> taskMap = new HashMap<InternalNode, MockRemoteTaskFactory.MockRemoteTask>();
        Multimap assignments = splitPlacementResult.getAssignments();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        int task = 0;
        for (InternalNode node : assignments.keySet()) {
            TaskId taskId = new TaskId("test", 1, 1, task);
            ++task;
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)ImmutableList.copyOf((Collection)assignments.get((Object)node)), this.nodeTaskMap.createPartitionedSplitCountTracker(node, taskId));
            remoteTask.startSplits(25);
            this.nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            taskMap.put(node, remoteTask);
        }
        return ImmutableList.copyOf(taskMap.values());
    }

    private static class TestNetworkTopology
    implements NetworkTopology {
        private TestNetworkTopology() {
        }

        public NetworkLocation locate(HostAddress address) {
            ArrayList parts = new ArrayList(ImmutableList.copyOf((Iterable)Splitter.on((String)".").split((CharSequence)address.getHostText())));
            Collections.reverse(parts);
            return NetworkLocation.create(parts);
        }

        public List<String> getLocationSegmentNames() {
            return ImmutableList.of((Object)"rack", (Object)"machine");
        }
    }

    private static class TestHardAffinitySplitRemote
    extends TestSplitRemote {
        @Override
        public NodeSelectionStrategy getNodeSelectionStrategy() {
            return NodeSelectionStrategy.HARD_AFFINITY;
        }

        @Override
        public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
            return ImmutableList.of((Object)sortedCandidates.get(new Random().nextInt(sortedCandidates.size())));
        }
    }

    private static class TestAffinitySplitRemote
    extends TestSplitRemote {
        private int scheduleIdentifierId;

        public TestAffinitySplitRemote(int scheduleIdentifierId) {
            this.scheduleIdentifierId = scheduleIdentifierId;
        }

        @Override
        public NodeSelectionStrategy getNodeSelectionStrategy() {
            return NodeSelectionStrategy.SOFT_AFFINITY;
        }

        @Override
        public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
            return ImmutableList.of((Object)sortedCandidates.get(this.scheduleIdentifierId % sortedCandidates.size()));
        }
    }

    private static class TestSplitRemote
    implements ConnectorSplit {
        private final List<HostAddress> hosts;

        public TestSplitRemote() {
            this(HostAddress.fromString((String)("127.0.0.1:" + ThreadLocalRandom.current().nextInt(5000))));
        }

        public TestSplitRemote(HostAddress host) {
            this.hosts = ImmutableList.of((Object)Objects.requireNonNull(host, "host is null"));
        }

        public NodeSelectionStrategy getNodeSelectionStrategy() {
            return NodeSelectionStrategy.NO_PREFERENCE;
        }

        public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
            return this.hosts;
        }

        public Object getInfo() {
            return this;
        }
    }

    private static class TestSplitLocal
    implements ConnectorSplit {
        private TestSplitLocal() {
        }

        public NodeSelectionStrategy getNodeSelectionStrategy() {
            return NodeSelectionStrategy.HARD_AFFINITY;
        }

        public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
            return ImmutableList.of((Object)HostAddress.fromString((String)"127.0.0.1:11"));
        }

        public Object getInfo() {
            return this;
        }
    }
}

