/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.QueryPreparer;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.testing.TestingSession;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryPreparer {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final QueryPreparer QUERY_PREPARER = new QueryPreparer(SQL_PARSER);

    @Test
    public void testSelectStatement() {
        QueryPreparer.PreparedQuery preparedQuery = QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "SELECT * FROM foo", WarningCollector.NOOP);
        Assert.assertEquals((Object)preparedQuery.getStatement(), (Object)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo"))));
    }

    @Test
    public void testExecuteStatement() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT * FROM foo").build();
        QueryPreparer.PreparedQuery preparedQuery = QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query", WarningCollector.NOOP);
        Assert.assertEquals((Object)preparedQuery.getStatement(), (Object)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo"))));
    }

    @Test
    public void testExecuteStatementDoesNotExist() {
        try {
            QUERY_PREPARER.prepareQuery(SessionTestUtils.TEST_SESSION, "execute my_query", WarningCollector.NOOP);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_FOUND.toErrorCode());
        }
    }

    @Test
    public void testTooManyParameters() {
        try {
            Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT * FROM foo where col1 = ?").build();
            QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1,2", WarningCollector.NOOP);
            Assert.fail((String)"expected exception");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.INVALID_PARAMETER_USAGE);
        }
    }

    @Test
    public void testTooFewParameters() {
        try {
            Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT ? FROM foo where col1 = ?").build();
            QUERY_PREPARER.prepareQuery(session, "EXECUTE my_query USING 1", WarningCollector.NOOP);
            Assert.fail((String)"expected exception");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.INVALID_PARAMETER_USAGE);
        }
    }
}

