/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.stats.GcMonitor;
import com.facebook.airlift.stats.TestingGcMonitor;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.execution.SqlTask;
import com.facebook.presto.execution.SqlTaskExecutionFactory;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.execution.TestSqlTaskManager;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.executor.TaskExecutor;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.operator.FragmentResultCacheManager;
import com.facebook.presto.operator.NoOpFragmentResultCacheManager;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.testing.TestingSession;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSqlTask {
    public static final OutputBuffers.OutputBufferId OUT = new OutputBuffers.OutputBufferId(0);
    private final TaskExecutor taskExecutor;
    private final ScheduledExecutorService taskNotificationExecutor;
    private final ScheduledExecutorService driverYieldExecutor;
    private final SqlTaskExecutionFactory sqlTaskExecutionFactory;
    private final AtomicInteger nextTaskId = new AtomicInteger();

    public TestSqlTask() {
        this.taskExecutor = new TaskExecutor(8, 16, 3, 4, TaskManagerConfig.TaskPriorityTracking.TASK_FAIR, Ticker.systemTicker());
        this.taskExecutor.start();
        this.taskNotificationExecutor = Executors.newScheduledThreadPool(10, Threads.threadsNamed((String)"task-notification-%s"));
        this.driverYieldExecutor = Executors.newScheduledThreadPool(2, Threads.threadsNamed((String)"driver-yield-%s"));
        LocalExecutionPlanner planner = TaskTestUtils.createTestingPlanner();
        this.sqlTaskExecutionFactory = new SqlTaskExecutionFactory((Executor)this.taskNotificationExecutor, this.taskExecutor, planner, (BlockEncodingSerde)new BlockEncodingManager(new BlockEncoding[0]), new OrderingCompiler(), TaskTestUtils.createTestSplitMonitor(), (FragmentResultCacheManager)new NoOpFragmentResultCacheManager(), new TaskManagerConfig());
    }

    @AfterClass(alwaysRun=true)
    public void destroy() {
        this.taskExecutor.stop();
        this.taskNotificationExecutor.shutdownNow();
        this.driverYieldExecutor.shutdown();
    }

    @Test
    public void testEmptyQuery() {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds(), Optional.of(new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty())));
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds(), Optional.of(new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty())));
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
    }

    @Test
    public void testSimpleQuery() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), Optional.of(new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty())));
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        BufferResult results = (BufferResult)sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE)).get();
        Assert.assertEquals((boolean)results.isBufferComplete(), (boolean)false);
        Assert.assertEquals((int)results.getSerializedPages().size(), (int)1);
        Assert.assertEquals((int)((SerializedPage)results.getSerializedPages().get(0)).getPositionCount(), (int)1);
        boolean moreResults = true;
        while (moreResults) {
            moreResults = !(results = (BufferResult)sqlTask.getTaskResults(OUT, results.getToken() + (long)results.getSerializedPages().size(), new DataSize(1.0, DataSize.Unit.MEGABYTE)).get()).isBufferComplete();
        }
        Assert.assertEquals((int)results.getSerializedPages().size(), (int)0);
        TaskInfo info = sqlTask.abortTaskResults(OUT);
        Assert.assertEquals((Object)info.getOutputBuffers().getState(), (Object)BufferState.FINISHED);
        taskInfo = (TaskInfo)sqlTask.getTaskInfo(taskInfo.getTaskStatus().getState()).get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
    }

    @Test
    public void testCancel() {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), Optional.of(new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty())));
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        Assert.assertNull((Object)taskInfo.getStats().getEndTime());
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        Assert.assertNull((Object)taskInfo.getStats().getEndTime());
        taskInfo = sqlTask.cancel();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
        Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
        Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
    }

    @Test
    public void testAbort() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), Optional.of(new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty())));
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        sqlTask.abortTaskResults(OUT);
        taskInfo = (TaskInfo)sqlTask.getTaskInfo(taskInfo.getTaskStatus().getState()).get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
    }

    @Test
    public void testBufferCloseOnFinish() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SOURCES, outputBuffers);
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE));
        Assert.assertFalse((boolean)bufferResult.isDone());
        TaskTestUtils.updateTask(sqlTask, (List<TaskSource>)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), outputBuffers);
        sqlTask.abortTaskResults(OUT);
        bufferResult.get(1L, TimeUnit.SECONDS);
        bufferResult = sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE));
        Assert.assertTrue((boolean)bufferResult.isDone());
        Assert.assertTrue((boolean)((BufferResult)bufferResult.get()).isBufferComplete());
    }

    @Test
    public void testBufferCloseOnCancel() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SOURCES, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE));
        Assert.assertFalse((boolean)bufferResult.isDone());
        sqlTask.cancel();
        Assert.assertEquals((Object)sqlTask.getTaskInfo().getTaskStatus().getState(), (Object)TaskState.CANCELED);
        bufferResult.get(1L, TimeUnit.SECONDS);
        bufferResult = sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE));
        Assert.assertTrue((boolean)bufferResult.isDone());
        Assert.assertTrue((boolean)((BufferResult)bufferResult.get()).isBufferComplete());
    }

    @Test
    public void testBufferNotCloseOnFail() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SOURCES, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE));
        Assert.assertFalse((boolean)bufferResult.isDone());
        TaskState taskState = sqlTask.getTaskInfo().getTaskStatus().getState();
        sqlTask.failed((Throwable)new Exception("test"));
        Assert.assertEquals((Object)((TaskInfo)sqlTask.getTaskInfo(taskState).get(1L, TimeUnit.SECONDS)).getTaskStatus().getState(), (Object)TaskState.FAILED);
        try {
            Assert.assertTrue((boolean)((BufferResult)bufferResult.get(1L, TimeUnit.SECONDS)).isBufferComplete());
            Assert.fail((String)"expected TimeoutException");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)sqlTask.getTaskResults(OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE)).isDone());
    }

    public SqlTask createInitialTask() {
        TaskId taskId = new TaskId("query", 0, 0, this.nextTaskId.incrementAndGet());
        URI location = URI.create("fake://task/" + taskId);
        QueryContext queryContext = new QueryContext(new QueryId("query"), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(2.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new MemoryPool(new MemoryPoolId("test"), new DataSize(1.0, DataSize.Unit.GIGABYTE)), (GcMonitor)new TestingGcMonitor(), (Executor)this.taskNotificationExecutor, this.driverYieldExecutor, new DataSize(1.0, DataSize.Unit.MEGABYTE), new SpillSpaceTracker(new DataSize(1.0, DataSize.Unit.GIGABYTE)));
        queryContext.addTaskContext(new TaskStateMachine(taskId, (Executor)this.taskNotificationExecutor), TestingSession.testSessionBuilder().build(), false, false, false, false, false, Optional.empty());
        return SqlTask.createSqlTask((TaskId)taskId, (URI)location, (String)"fake", (QueryContext)queryContext, (SqlTaskExecutionFactory)this.sqlTaskExecutionFactory, (ExchangeClientSupplier)new TestSqlTaskManager.MockExchangeClientSupplier(), (ExecutorService)this.taskNotificationExecutor, (Function)Functions.identity(), (DataSize)new DataSize(32.0, DataSize.Unit.MEGABYTE), (CounterStat)new CounterStat());
    }
}

