/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.node.NodeInfo;
import com.facebook.airlift.stats.GcMonitor;
import com.facebook.airlift.stats.TestingGcMonitor;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.execution.SqlTaskManager;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagementExecutor;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.executor.TaskExecutor;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.operator.FragmentResultCacheManager;
import com.facebook.presto.operator.NoOpFragmentResultCacheManager;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spiller.LocalSpillManager;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.testing.TestingSession;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestSqlTaskManager {
    private static final TaskId TASK_ID = new TaskId("query", 0, 0, 1);
    public static final OutputBuffers.OutputBufferId OUT = new OutputBuffers.OutputBufferId(0);
    private final TaskExecutor taskExecutor;
    private final TaskManagementExecutor taskManagementExecutor;
    private final LocalMemoryManager localMemoryManager = new LocalMemoryManager(new NodeMemoryConfig());
    private final LocalSpillManager localSpillManager = new LocalSpillManager(new NodeSpillConfig());

    public TestSqlTaskManager() {
        this.taskExecutor = new TaskExecutor(8, 16, 3, 4, TaskManagerConfig.TaskPriorityTracking.TASK_FAIR, Ticker.systemTicker());
        this.taskExecutor.start();
        this.taskManagementExecutor = new TaskManagementExecutor();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.taskExecutor.stop();
        this.taskManagementExecutor.close();
    }

    @Test
    public void testEmptyQuery() {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = this.createTask(sqlTaskManager, taskId, (ImmutableSet<ScheduledSplit>)ImmutableSet.of(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test
    public void testSimpleQuery() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, (ImmutableSet<ScheduledSplit>)ImmutableSet.of((Object)TaskTestUtils.SPLIT), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            BufferResult results = (BufferResult)sqlTaskManager.getTaskResults(taskId, OUT, 0L, new DataSize(1.0, DataSize.Unit.MEGABYTE)).get();
            Assert.assertEquals((boolean)results.isBufferComplete(), (boolean)false);
            Assert.assertEquals((int)results.getSerializedPages().size(), (int)1);
            Assert.assertEquals((int)((SerializedPage)results.getSerializedPages().get(0)).getPositionCount(), (int)1);
            boolean moreResults = true;
            while (moreResults) {
                moreResults = !(results = (BufferResult)sqlTaskManager.getTaskResults(taskId, OUT, results.getToken() + (long)results.getSerializedPages().size(), new DataSize(1.0, DataSize.Unit.MEGABYTE)).get()).isBufferComplete();
            }
            Assert.assertEquals((boolean)results.isBufferComplete(), (boolean)true);
            Assert.assertEquals((int)results.getSerializedPages().size(), (int)0);
            TaskInfo info = sqlTaskManager.abortTaskResults(taskId, OUT);
            Assert.assertEquals((Object)info.getOutputBuffers().getState(), (Object)BufferState.FINISHED);
            taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, taskInfo.getTaskStatus().getState()).get(1L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test
    public void testCancel() {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.cancelTask(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        }
    }

    @Test
    public void testAbort() {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.abortTask(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.ABORTED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.ABORTED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        }
    }

    @Test
    public void testAbortResults() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, (ImmutableSet<ScheduledSplit>)ImmutableSet.of((Object)TaskTestUtils.SPLIT), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            sqlTaskManager.abortTaskResults(taskId, OUT);
            taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, taskInfo.getTaskStatus().getState()).get(1L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test
    public void testRemoveOldTasks() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig().setInfoMaxAge(new Duration(5.0, TimeUnit.MILLISECONDS)));){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.cancelTask(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            Thread.sleep(100L);
            sqlTaskManager.removeOldTasks();
            for (TaskInfo info : sqlTaskManager.getAllTaskInfo()) {
                Assert.assertNotEquals((Object)info.getTaskId(), (Object)taskId);
            }
        }
    }

    public SqlTaskManager createSqlTaskManager(TaskManagerConfig config) {
        return new SqlTaskManager(TaskTestUtils.createTestingPlanner(), (LocationFactory)new MockLocationFactory(), this.taskExecutor, TaskTestUtils.createTestSplitMonitor(), new NodeInfo("test"), this.localMemoryManager, this.taskManagementExecutor, config, new NodeMemoryConfig(), this.localSpillManager, (ExchangeClientSupplier)new MockExchangeClientSupplier(), new NodeSpillConfig(), (GcMonitor)new TestingGcMonitor(), (BlockEncodingSerde)new BlockEncodingManager(new BlockEncoding[0]), new OrderingCompiler(), (FragmentResultCacheManager)new NoOpFragmentResultCacheManager());
    }

    private TaskInfo createTask(SqlTaskManager sqlTaskManager, TaskId taskId, ImmutableSet<ScheduledSplit> splits, OutputBuffers outputBuffers) {
        return sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, splits, true)), outputBuffers, Optional.of(new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty())));
    }

    private TaskInfo createTask(SqlTaskManager sqlTaskManager, TaskId taskId, OutputBuffers outputBuffers) {
        sqlTaskManager.getQueryContext(taskId.getQueryId()).addTaskContext(new TaskStateMachine(taskId, MoreExecutors.directExecutor()), TestingSession.testSessionBuilder().build(), false, false, false, false, false, Optional.empty());
        return sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of(), outputBuffers, Optional.of(new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty())));
    }

    public static class MockLocationFactory
    implements LocationFactory {
        public URI createQueryLocation(QueryId queryId) {
            return URI.create("http://fake.invalid/query/" + queryId);
        }

        public URI createStageLocation(StageId stageId) {
            return URI.create("http://fake.invalid/stage/" + stageId);
        }

        public URI createLocalTaskLocation(TaskId taskId) {
            return URI.create("http://fake.invalid/task/" + taskId);
        }

        public URI createLegacyTaskLocation(InternalNode node, TaskId taskId) {
            return URI.create("http://fake.invalid/task/" + node.getNodeIdentifier() + "/" + taskId);
        }

        public URI createTaskLocation(InternalNode node, TaskId taskId) {
            return this.createLegacyTaskLocation(node, taskId);
        }

        public URI createMemoryInfoLocation(InternalNode node) {
            return URI.create("http://fake.invalid/" + node.getNodeIdentifier() + "/memory");
        }
    }

    public static class MockExchangeClientSupplier
    implements ExchangeClientSupplier {
        public ExchangeClient get(LocalMemoryContext systemMemoryContext) {
            throw new UnsupportedOperationException();
        }
    }
}

