/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StartTransactionTask;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Isolation;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.TransactionAccessMode;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionInfo;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.transaction.TransactionManagerConfig;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestStartTransactionTask {
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stage-executor-%s"));
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"scheduled-executor-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testNonTransactionalClient() {
        Session session = TestStartTransactionTask.sessionBuilder().build();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        Assert.assertFalse((boolean)stateMachine.getSession().getTransactionId().isPresent());
        try {
            MoreFutures.getFutureValue((Future)new StartTransactionTask().execute(new StartTransaction((List)ImmutableList.of()), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
            Assert.fail();
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INCOMPATIBLE_CLIENT.toErrorCode());
        }
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
    }

    @Test
    public void testNestedTransaction() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestStartTransactionTask.sessionBuilder().setTransactionId(TransactionId.create()).setClientTransactionSupport().build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        try {
            MoreFutures.getFutureValue((Future)new StartTransactionTask().execute(new StartTransaction((List)ImmutableList.of()), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
            Assert.fail();
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode());
        }
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
    }

    @Test
    public void testStartTransaction() {
        Session session = TestStartTransactionTask.sessionBuilder().setClientTransactionSupport().build();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        Assert.assertFalse((boolean)stateMachine.getSession().getTransactionId().isPresent());
        MoreFutures.getFutureValue((Future)new StartTransactionTask().execute(new StartTransaction((List)ImmutableList.of()), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertTrue((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
        TransactionInfo transactionInfo = transactionManager.getTransactionInfo((TransactionId)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().get());
        Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
    }

    @Test
    public void testStartTransactionExplicitModes() {
        Session session = TestStartTransactionTask.sessionBuilder().setClientTransactionSupport().build();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        Assert.assertFalse((boolean)stateMachine.getSession().getTransactionId().isPresent());
        MoreFutures.getFutureValue((Future)new StartTransactionTask().execute(new StartTransaction((List)ImmutableList.of((Object)new Isolation(Isolation.Level.SERIALIZABLE), (Object)new TransactionAccessMode(true))), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertTrue((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
        TransactionInfo transactionInfo = transactionManager.getTransactionInfo((TransactionId)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().get());
        Assert.assertEquals((Object)transactionInfo.getIsolationLevel(), (Object)IsolationLevel.SERIALIZABLE);
        Assert.assertTrue((boolean)transactionInfo.isReadOnly());
        Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
    }

    @Test
    public void testStartTransactionTooManyIsolationLevels() {
        Session session = TestStartTransactionTask.sessionBuilder().setClientTransactionSupport().build();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        Assert.assertFalse((boolean)stateMachine.getSession().getTransactionId().isPresent());
        try {
            MoreFutures.getFutureValue((Future)new StartTransactionTask().execute(new StartTransaction((List)ImmutableList.of((Object)new Isolation(Isolation.Level.READ_COMMITTED), (Object)new Isolation(Isolation.Level.READ_COMMITTED))), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
            Assert.fail();
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.INVALID_TRANSACTION_MODE);
        }
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
    }

    @Test
    public void testStartTransactionTooManyAccessModes() {
        Session session = TestStartTransactionTask.sessionBuilder().setClientTransactionSupport().build();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        Assert.assertFalse((boolean)stateMachine.getSession().getTransactionId().isPresent());
        try {
            MoreFutures.getFutureValue((Future)new StartTransactionTask().execute(new StartTransaction((List)ImmutableList.of((Object)new TransactionAccessMode(true), (Object)new TransactionAccessMode(true))), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
            Assert.fail();
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.INVALID_TRANSACTION_MODE);
        }
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
    }

    @Test
    public void testStartTransactionIdleExpiration() throws Exception {
        Session session = TestStartTransactionTask.sessionBuilder().setClientTransactionSupport().build();
        TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.MICROSECONDS)).setIdleCheckInterval(new Duration(10.0, TimeUnit.MILLISECONDS)), (ScheduledExecutorService)this.scheduledExecutor, (CatalogManager)new CatalogManager(), (ExecutorService)this.executor);
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        Assert.assertFalse((boolean)stateMachine.getSession().getTransactionId().isPresent());
        MoreFutures.getFutureValue((Future)new StartTransactionTask().execute(new StartTransaction((List)ImmutableList.of()), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertTrue((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        long start = System.nanoTime();
        while (!transactionManager.getAllTransactionInfos().isEmpty()) {
            if (Duration.nanosSince((long)start).toMillis() > 10000L) {
                Assert.fail((String)"Transaction did not expire in the allotted time");
            }
            TimeUnit.MILLISECONDS.sleep(10L);
        }
    }

    private QueryStateMachine createQueryStateMachine(String query, Session session, TransactionManager transactionManager) {
        return QueryStateMachine.begin((String)query, (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), Optional.empty(), (boolean)true, (TransactionManager)transactionManager, (AccessControl)new AccessControlManager(transactionManager), (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP);
    }

    private static Session.SessionBuilder sessionBuilder() {
        return TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny");
    }
}

