/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.failureDetector;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.discovery.client.DiscoveryBinder;
import com.facebook.airlift.discovery.client.ServiceSelector;
import com.facebook.airlift.discovery.client.ServiceTypes;
import com.facebook.airlift.discovery.client.testing.TestingDiscoveryModule;
import com.facebook.airlift.http.server.testing.TestingHttpServerModule;
import com.facebook.airlift.jaxrs.JaxrsBinder;
import com.facebook.airlift.jaxrs.JaxrsModule;
import com.facebook.airlift.jmx.testing.TestingJmxModule;
import com.facebook.airlift.json.JsonModule;
import com.facebook.airlift.json.ObjectMapperProvider;
import com.facebook.airlift.node.testing.TestingNodeModule;
import com.facebook.airlift.tracetoken.TraceTokenModule;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.failureDetector.FailureDetectorModule;
import com.facebook.presto.failureDetector.HeartbeatFailureDetector;
import com.facebook.presto.server.InternalCommunicationConfig;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.lang.annotation.Annotation;
import java.net.SocketTimeoutException;
import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHeartbeatFailureDetector {
    @Test
    public void testExcludesCurrentNode() throws Exception {
        Bootstrap app = new Bootstrap(new Module[]{new TestingNodeModule(), new TestingJmxModule(), new TestingDiscoveryModule(), new TestingHttpServerModule(), new TraceTokenModule(), new JsonModule(), new JaxrsModule(true), new FailureDetectorModule(), new Module(){

            public void configure(Binder binder) {
                ConfigBinder.configBinder((Binder)binder).bindConfig(InternalCommunicationConfig.class);
                ConfigBinder.configBinder((Binder)binder).bindConfig(QueryManagerConfig.class);
                DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector("presto");
                DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("presto");
                JaxrsBinder.jaxrsBinder((Binder)binder).bind(FooResource.class);
            }
        }});
        Injector injector = app.strictConfig().doNotInitializeLogging().quiet().initialize();
        ServiceSelector selector = (ServiceSelector)injector.getInstance(Key.get(ServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"presto")));
        Assert.assertEquals((int)selector.selectAllServices().size(), (int)1);
        HeartbeatFailureDetector detector = (HeartbeatFailureDetector)injector.getInstance(HeartbeatFailureDetector.class);
        detector.updateMonitoredServices();
        Assert.assertEquals((int)detector.getTotalCount(), (int)0);
        Assert.assertEquals((int)detector.getActiveCount(), (int)0);
        Assert.assertEquals((int)detector.getFailedCount(), (int)0);
        Assert.assertTrue((boolean)detector.getFailed().isEmpty());
    }

    @Test
    public void testHeartbeatStatsSerialization() throws Exception {
        ObjectMapper objectMapper = new ObjectMapperProvider().get();
        HeartbeatFailureDetector.Stats stats = new HeartbeatFailureDetector.Stats(new URI("http://example.com"), 60);
        String serialized = objectMapper.writeValueAsString((Object)stats);
        JsonNode deserialized = objectMapper.readTree(serialized);
        Assert.assertFalse((boolean)deserialized.has("lastFailureInfo"));
        stats.recordFailure((Exception)new SocketTimeoutException("timeout"));
        serialized = objectMapper.writeValueAsString((Object)stats);
        deserialized = objectMapper.readTree(serialized);
        Assert.assertFalse((boolean)deserialized.get("lastFailureInfo").isNull());
        Assert.assertEquals((String)deserialized.get("lastFailureInfo").get("type").asText(), (String)SocketTimeoutException.class.getName());
    }

    @Path(value="/foo")
    public static class FooResource {
        @GET
        public static String hello() {
            return "hello";
        }
    }
}

