/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestMemoryManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((MemoryManagerConfig)ConfigAssertions.recordDefaults(MemoryManagerConfig.class)).setLowMemoryKillerPolicy("none").setKillOnOutOfMemoryDelay(new Duration(5.0, TimeUnit.MINUTES)).setMaxQueryMemory(new DataSize(20.0, DataSize.Unit.GIGABYTE)).setSoftMaxQueryMemory(new DataSize(20.0, DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemory(new DataSize(40.0, DataSize.Unit.GIGABYTE)).setSoftMaxQueryTotalMemory(new DataSize(40.0, DataSize.Unit.GIGABYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"query.low-memory-killer.policy", (Object)"total-reservation-on-blocked-nodes").put((Object)"query.low-memory-killer.delay", (Object)"20s").put((Object)"query.max-memory", (Object)"2GB").put((Object)"query.soft-max-memory", (Object)"1GB").put((Object)"query.max-total-memory", (Object)"3GB").put((Object)"query.soft-max-total-memory", (Object)"2GB").build();
        MemoryManagerConfig expected = new MemoryManagerConfig().setLowMemoryKillerPolicy("total-reservation-on-blocked-nodes").setKillOnOutOfMemoryDelay(new Duration(20.0, TimeUnit.SECONDS)).setMaxQueryMemory(new DataSize(2.0, DataSize.Unit.GIGABYTE)).setSoftMaxQueryMemory(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemory(new DataSize(3.0, DataSize.Unit.GIGABYTE)).setSoftMaxQueryTotalMemory(new DataSize(2.0, DataSize.Unit.GIGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

