/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.HyperLogLogType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInFunction;
import com.facebook.presto.metadata.BuiltInFunctionHandle;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.SignatureBuilder;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.CustomFunctions;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFunctionAndTypeManager {
    @Test
    public void testIdentityCast() {
        FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
        FunctionHandle exactOperator = functionAndTypeManager.lookupCast(CastType.CAST, HyperLogLogType.HYPER_LOG_LOG.getTypeSignature(), HyperLogLogType.HYPER_LOG_LOG.getTypeSignature());
        Assert.assertEquals((Object)exactOperator, (Object)new BuiltInFunctionHandle(new Signature(OperatorType.CAST.getFunctionName(), FunctionKind.SCALAR, HyperLogLogType.HYPER_LOG_LOG.getTypeSignature(), new TypeSignature[]{HyperLogLogType.HYPER_LOG_LOG.getTypeSignature()})));
    }

    @Test
    public void testExactMatchBeforeCoercion() {
        FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
        boolean foundOperator = false;
        for (SqlFunction function : functionAndTypeManager.listOperators()) {
            OperatorType operatorType = (OperatorType)OperatorType.tryGetOperatorType((QualifiedFunctionName)function.getSignature().getName()).get();
            if (operatorType == OperatorType.CAST || operatorType == OperatorType.SATURATED_FLOOR_CAST || !function.getSignature().getTypeVariableConstraints().isEmpty() || function.getSignature().getArgumentTypes().stream().anyMatch(TypeSignature::isCalculated)) continue;
            BuiltInFunctionHandle exactOperator = (BuiltInFunctionHandle)functionAndTypeManager.resolveOperator(operatorType, TypeSignatureProvider.fromTypeSignatures((List)function.getSignature().getArgumentTypes()));
            Assert.assertEquals((Object)exactOperator.getSignature(), (Object)function.getSignature());
            foundOperator = true;
        }
        Assert.assertTrue((boolean)foundOperator);
    }

    @Test
    public void testMagicLiteralFunction() {
        Signature signature = LiteralEncoder.getMagicLiteralFunctionSignature((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        Assert.assertEquals((String)signature.getNameSuffix(), (String)"$literal$timestamp with time zone");
        Assert.assertEquals((Collection)signature.getArgumentTypes(), (Collection)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"bigint")));
        Assert.assertEquals((String)signature.getReturnType().getBase(), (String)"timestamp with time zone");
        FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
        BuiltInFunctionHandle functionHandle = (BuiltInFunctionHandle)functionAndTypeManager.resolveFunction(SessionTestUtils.TEST_SESSION.getTransactionId(), signature.getName(), TypeSignatureProvider.fromTypeSignatures((List)signature.getArgumentTypes()));
        Assert.assertEquals((Collection)functionAndTypeManager.getFunctionMetadata((FunctionHandle)functionHandle).getArgumentTypes(), (Collection)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"bigint")));
        Assert.assertEquals((String)signature.getReturnType().getBase(), (String)"timestamp with time zone");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="\\QFunction already registered: presto.default.custom_add(bigint,bigint):bigint\\E")
    public void testDuplicateFunctions() {
        List functions = (List)new FunctionListBuilder().scalars(CustomFunctions.class).getFunctions().stream().filter(input -> input.getSignature().getNameSuffix().equals("custom_add")).collect(ImmutableList.toImmutableList());
        FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
        functionAndTypeManager.registerBuiltInFunctions(functions);
        functionAndTypeManager.registerBuiltInFunctions(functions);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="'presto.default.sum' is both an aggregation and a scalar function")
    public void testConflictingScalarAggregation() {
        List functions = new FunctionListBuilder().scalars(ScalarSum.class).getFunctions();
        FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
        functionAndTypeManager.registerBuiltInFunctions(functions);
    }

    @Test
    public void testListingVisibilityBetaFunctionsDisabled() {
        FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
        List functions = functionAndTypeManager.listFunctions(SessionTestUtils.TEST_SESSION);
        List names = Lists.transform((List)functions, input -> input.getSignature().getNameSuffix());
        Assert.assertTrue((boolean)names.contains("length"), (String)("Expected function names " + names + " to contain 'length'"));
        Assert.assertTrue((boolean)names.contains("stddev"), (String)("Expected function names " + names + " to contain 'stddev'"));
        Assert.assertTrue((boolean)names.contains("rank"), (String)("Expected function names " + names + " to contain 'rank'"));
        Assert.assertFalse((boolean)names.contains("tdigest_agg"), (String)("Expected function names " + names + " not to contain 'tdigest_agg'"));
        Assert.assertFalse((boolean)names.contains("quantiles_at_values"), (String)("Expected function names " + names + " not to contain 'quantiles_at_values'"));
        Assert.assertFalse((boolean)names.contains("like"), (String)("Expected function names " + names + " not to contain 'like'"));
        Assert.assertFalse((boolean)names.contains("$internal$sum_data_size_for_stats"), (String)("Expected function names " + names + " not to contain '$internal$sum_data_size_for_stats'"));
        Assert.assertFalse((boolean)names.contains("$internal$max_data_size_for_stats"), (String)("Expected function names " + names + " not to contain '$internal$max_data_size_for_stats'"));
    }

    @Test
    public void testListingVisibilityBetaFunctionsEnabled() {
        Session session = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").setSystemProperty("experimental_functions_enabled", "true").build();
        FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
        List functions = functionAndTypeManager.listFunctions(session);
        List names = Lists.transform((List)functions, input -> input.getSignature().getNameSuffix());
        Assert.assertTrue((boolean)names.contains("length"), (String)("Expected function names " + names + " to contain 'length'"));
        Assert.assertTrue((boolean)names.contains("stddev"), (String)("Expected function names " + names + " to contain 'stddev'"));
        Assert.assertTrue((boolean)names.contains("rank"), (String)("Expected function names " + names + " to contain 'rank'"));
        Assert.assertTrue((boolean)names.contains("tdigest_agg"), (String)("Expected function names " + names + " to contain 'tdigest_agg'"));
        Assert.assertTrue((boolean)names.contains("quantiles_at_values"), (String)("Expected function names " + names + " to contain 'tdigest_agg'"));
        Assert.assertFalse((boolean)names.contains("like"), (String)("Expected function names " + names + " not to contain 'like'"));
        Assert.assertFalse((boolean)names.contains("$internal$sum_data_size_for_stats"), (String)("Expected function names " + names + " not to contain '$internal$sum_data_size_for_stats'"));
        Assert.assertFalse((boolean)names.contains("$internal$max_data_size_for_stats"), (String)("Expected function names " + names + " not to contain '$internal$max_data_size_for_stats'"));
    }

    @Test
    public void testOperatorTypes() {
        FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
        FunctionResolution functionResolution = new FunctionResolution(functionAndTypeManager);
        Assert.assertTrue((boolean)functionAndTypeManager.getFunctionMetadata(functionResolution.arithmeticFunction(ArithmeticBinaryExpression.Operator.ADD, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).getOperatorType().map(OperatorType::isArithmeticOperator).orElse(false));
        Assert.assertFalse((boolean)functionAndTypeManager.getFunctionMetadata(functionResolution.arithmeticFunction(ArithmeticBinaryExpression.Operator.ADD, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).getOperatorType().map(OperatorType::isComparisonOperator).orElse(true));
        Assert.assertTrue((boolean)functionAndTypeManager.getFunctionMetadata(functionResolution.comparisonFunction(ComparisonExpression.Operator.GREATER_THAN, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).getOperatorType().map(OperatorType::isComparisonOperator).orElse(false));
        Assert.assertFalse((boolean)functionAndTypeManager.getFunctionMetadata(functionResolution.comparisonFunction(ComparisonExpression.Operator.GREATER_THAN, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).getOperatorType().map(OperatorType::isArithmeticOperator).orElse(true));
        Assert.assertFalse((boolean)functionAndTypeManager.getFunctionMetadata(functionResolution.notFunction()).getOperatorType().isPresent());
    }

    @Test
    public void testResolveFunctionByExactMatch() {
        TestFunctionAndTypeManager.assertThatResolveFunction().among(this.functionSignature("bigint", "bigint")).forParameters("bigint", "bigint").returns(this.functionSignature("bigint", "bigint"));
    }

    @Test
    public void testResolveTypeParametrizedFunction() {
        TestFunctionAndTypeManager.assertThatResolveFunction().among(TestFunctionAndTypeManager.functionSignature((List<String>)ImmutableList.of((Object)"T", (Object)"T"), "boolean", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T")))).forParameters("bigint", "bigint").returns(this.functionSignature("bigint", "bigint"));
    }

    @Test
    public void testResolveFunctionWithCoercion() {
        TestFunctionAndTypeManager.assertThatResolveFunction().among(this.functionSignature("decimal(p,s)", "double"), this.functionSignature("decimal(p,s)", "decimal(p,s)"), this.functionSignature("double", "double")).forParameters("bigint", "bigint").returns(this.functionSignature("decimal(19,0)", "decimal(19,0)"));
    }

    @Test
    public void testAmbiguousCallWithNoCoercion() {
        TestFunctionAndTypeManager.assertThatResolveFunction().among(this.functionSignature("decimal(p,s)", "decimal(p,s)"), TestFunctionAndTypeManager.functionSignature((List<String>)ImmutableList.of((Object)"T", (Object)"T"), "boolean", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T")))).forParameters("decimal(3,1)", "decimal(3,1)").returns(this.functionSignature("decimal(3,1)", "decimal(3,1)"));
    }

    @Test
    public void testAmbiguousCallWithCoercion() {
        TestFunctionAndTypeManager.assertThatResolveFunction().among(this.functionSignature("decimal(p,s)", "double"), this.functionSignature("double", "decimal(p,s)")).forParameters("bigint", "bigint").failsWithMessage("Could not choose a best candidate operator. Explicit type casts must be added.");
    }

    @Test
    public void testResolveFunctionWithCoercionInTypes() {
        TestFunctionAndTypeManager.assertThatResolveFunction().among(this.functionSignature("array(decimal(p,s))", "array(double)"), this.functionSignature("array(decimal(p,s))", "array(decimal(p,s))"), this.functionSignature("array(double)", "array(double)")).forParameters("array(bigint)", "array(bigint)").returns(this.functionSignature("array(decimal(19,0))", "array(decimal(19,0))"));
    }

    @Test
    public void testResolveFunctionWithVariableArity() {
        TestFunctionAndTypeManager.assertThatResolveFunction().among(this.functionSignature("double", "double", "double"), this.functionSignature("decimal(p,s)").setVariableArity(true)).forParameters("bigint", "bigint", "bigint").returns(this.functionSignature("decimal(19,0)", "decimal(19,0)", "decimal(19,0)"));
        TestFunctionAndTypeManager.assertThatResolveFunction().among(this.functionSignature("double", "double", "double"), this.functionSignature("bigint").setVariableArity(true)).forParameters("bigint", "bigint", "bigint").returns(this.functionSignature("bigint", "bigint", "bigint"));
    }

    @Test
    public void testResolveFunctionWithVariadicBound() {
        TestFunctionAndTypeManager.assertThatResolveFunction().among(this.functionSignature("bigint", "bigint", "bigint"), TestFunctionAndTypeManager.functionSignature((List<String>)ImmutableList.of((Object)"T1", (Object)"T2", (Object)"T3"), "boolean", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.withVariadicBound((String)"T1", (String)"decimal"), (Object)Signature.withVariadicBound((String)"T2", (String)"decimal"), (Object)Signature.withVariadicBound((String)"T3", (String)"decimal")))).forParameters("unknown", "bigint", "bigint").returns(this.functionSignature("bigint", "bigint", "bigint"));
    }

    @Test
    public void testResolveFunctionForUnknown() {
        TestFunctionAndTypeManager.assertThatResolveFunction().among(this.functionSignature("bigint")).forParameters("unknown").returns(this.functionSignature("bigint"));
        TestFunctionAndTypeManager.assertThatResolveFunction().among(this.functionSignature("bigint"), this.functionSignature("integer")).forParameters("unknown").returns(this.functionSignature("integer"));
        TestFunctionAndTypeManager.assertThatResolveFunction().among(this.functionSignature("bigint", "bigint"), this.functionSignature("integer", "integer")).forParameters("unknown", "bigint").returns(this.functionSignature("bigint", "bigint"));
        TestFunctionAndTypeManager.assertThatResolveFunction().among(TestFunctionAndTypeManager.functionSignature((List<String>)ImmutableList.of((Object)"JoniRegExp"), "boolean"), TestFunctionAndTypeManager.functionSignature((List<String>)ImmutableList.of((Object)"integer"), "boolean")).forParameters("unknown").returns(this.functionSignature("integer"));
        TestFunctionAndTypeManager.assertThatResolveFunction().among(TestFunctionAndTypeManager.functionSignature((List<String>)ImmutableList.of((Object)"JoniRegExp"), "JoniRegExp"), TestFunctionAndTypeManager.functionSignature((List<String>)ImmutableList.of((Object)"integer"), "integer")).forParameters("unknown").failsWithMessage("Could not choose a best candidate operator. Explicit type casts must be added.");
    }

    private SignatureBuilder functionSignature(String ... argumentTypes) {
        return TestFunctionAndTypeManager.functionSignature((List<String>)ImmutableList.copyOf((Object[])argumentTypes), "boolean");
    }

    private static SignatureBuilder functionSignature(List<String> arguments, String returnType) {
        return TestFunctionAndTypeManager.functionSignature(arguments, returnType, (List<TypeVariableConstraint>)ImmutableList.of());
    }

    private static SignatureBuilder functionSignature(List<String> arguments, String returnType, List<TypeVariableConstraint> typeVariableConstraints) {
        ImmutableSet literalParameters = ImmutableSet.of((Object)"p", (Object)"s", (Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2", (Object[])new String[]{"p3", "s3"});
        List argumentSignatures = (List)arguments.stream().map(signature -> TypeSignature.parseTypeSignature((String)signature, (Set)literalParameters)).collect(ImmutableList.toImmutableList());
        return new SignatureBuilder().returnType(TypeSignature.parseTypeSignature((String)returnType, (Set)literalParameters)).argumentTypes(argumentSignatures).typeVariableConstraints(typeVariableConstraints).kind(FunctionKind.SCALAR);
    }

    private static ResolveFunctionAssertion assertThatResolveFunction() {
        return new ResolveFunctionAssertion();
    }

    public static final class ScalarSum {
        private ScalarSum() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long sum(@SqlType(value="bigint") long a, @SqlType(value="bigint") long b) {
            return a + b;
        }
    }

    private static class ResolveFunctionAssertion {
        private static final String TEST_FUNCTION_NAME = "TEST_FUNCTION_NAME";
        private List<SignatureBuilder> functionSignatures = ImmutableList.of();
        private List<TypeSignature> parameterTypes = ImmutableList.of();

        private ResolveFunctionAssertion() {
        }

        public ResolveFunctionAssertion among(SignatureBuilder ... functionSignatures) {
            this.functionSignatures = ImmutableList.copyOf((Object[])functionSignatures);
            return this;
        }

        public ResolveFunctionAssertion forParameters(String ... parameters) {
            this.parameterTypes = ResolveFunctionAssertion.parseTypeSignatures(parameters);
            return this;
        }

        public ResolveFunctionAssertion returns(SignatureBuilder functionSignature) {
            BuiltInFunctionHandle expectedFunction = new BuiltInFunctionHandle(functionSignature.name(TEST_FUNCTION_NAME).build());
            FunctionHandle actualFunction = this.resolveFunctionHandle();
            Assert.assertEquals((Object)expectedFunction, (Object)actualFunction);
            return this;
        }

        public ResolveFunctionAssertion failsWithMessage(String ... messages) {
            try {
                this.resolveFunctionHandle();
                Assert.fail((String)"didn't fail as expected");
            }
            catch (RuntimeException e) {
                String actualMessage = e.getMessage();
                for (String expectedMessage : messages) {
                    if (actualMessage.contains(expectedMessage)) continue;
                    Assert.fail((String)String.format("%s doesn't contain %s", actualMessage, expectedMessage));
                }
            }
            return this;
        }

        private FunctionHandle resolveFunctionHandle() {
            FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
            functionAndTypeManager.registerBuiltInFunctions(this.createFunctionsFromSignatures());
            return functionAndTypeManager.resolveFunction(SessionTestUtils.TEST_SESSION.getTransactionId(), FunctionAndTypeManager.qualifyFunctionName((QualifiedName)QualifiedName.of((String)TEST_FUNCTION_NAME)), TypeSignatureProvider.fromTypeSignatures(this.parameterTypes));
        }

        private List<BuiltInFunction> createFunctionsFromSignatures() {
            ImmutableList.Builder functions = ImmutableList.builder();
            for (SignatureBuilder functionSignature : this.functionSignatures) {
                Signature signature = functionSignature.name(TEST_FUNCTION_NAME).build();
                functions.add((Object)new SqlScalarFunction(signature){

                    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
                        return new BuiltInScalarFunctionImplementation(false, Collections.nCopies(arity, BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((BuiltInScalarFunctionImplementation.NullConvention)BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), MethodHandles.identity(Void.class));
                    }

                    public SqlFunctionVisibility getVisibility() {
                        return SqlFunctionVisibility.PUBLIC;
                    }

                    public boolean isDeterministic() {
                        return false;
                    }

                    public String getDescription() {
                        return "testing function that does nothing";
                    }
                });
            }
            return functions.build();
        }

        private static List<TypeSignature> parseTypeSignatures(String ... signatures) {
            return ImmutableList.copyOf((Object[])signatures).stream().map(TypeSignature::parseTypeSignature).collect(Collectors.toList());
        }
    }
}

