/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.FunctionType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SignatureBuilder;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSignatureBinder {
    private final FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();

    @Test
    public void testBindLiteralForDecimal() {
        TypeSignature leftType = TypeSignature.parseTypeSignature((String)"decimal(p1,s1)", (Set)ImmutableSet.of((Object)"p1", (Object)"s1"));
        TypeSignature rightType = TypeSignature.parseTypeSignature((String)"decimal(p2,s2)", (Set)ImmutableSet.of((Object)"p2", (Object)"s2"));
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{leftType, rightType}).build();
        this.assertThat(function).boundTo("decimal(2,1)", "decimal(1,0)").produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p1", (Object)2L, (Object)"s1", (Object)1L, (Object)"p2", (Object)1L, (Object)"s2", (Object)0L)));
    }

    @Test
    public void testBindPartialDecimal() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"decimal(4,s)", (Set)ImmutableSet.of((Object)"s"))}).build();
        this.assertThat(function).boundTo("decimal(2,1)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"s", (Object)1L)));
        function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"decimal(p,1)", (Set)ImmutableSet.of((Object)"p"))}).build();
        this.assertThat(function).boundTo("decimal(2,0)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)3L)));
        this.assertThat(function).boundTo("decimal(2,1)").produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)2L)));
        this.assertThat(function).boundTo("bigint").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)20L)));
    }

    @Test
    public void testBindLiteralForVarchar() {
        TypeSignature leftType = TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"));
        TypeSignature rightType = TypeSignature.parseTypeSignature((String)"varchar(y)", (Set)ImmutableSet.of((Object)"y"));
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{leftType, rightType}).build();
        this.assertThat(function).boundTo("varchar(42)", "varchar(44)").produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)42L, (Object)"y", (Object)44L)));
        this.assertThat(function).boundTo("unknown", "varchar(44)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)0L, (Object)"y", (Object)44L)));
    }

    @Test
    public void testBindLiteralForRepeatedVarcharWithReturn() {
        TypeSignature leftType = TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"));
        TypeSignature rightType = TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"));
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{leftType, rightType}).build();
        this.assertThat(function).boundTo("varchar(44)", "varchar(44)").produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)44L)));
        this.assertThat(function).boundTo("varchar(44)", "varchar(42)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)44L)));
        this.assertThat(function).boundTo("varchar(42)", "varchar(44)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)44L)));
        this.assertThat(function).boundTo("unknown", "varchar(44)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)44L)));
    }

    @Test
    public void testBindLiteralForRepeatedDecimal() {
        TypeSignature leftType = TypeSignature.parseTypeSignature((String)"decimal(p,s)", (Set)ImmutableSet.of((Object)"p", (Object)"s"));
        TypeSignature rightType = TypeSignature.parseTypeSignature((String)"decimal(p,s)", (Set)ImmutableSet.of((Object)"p", (Object)"s"));
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{leftType, rightType}).build();
        this.assertThat(function).boundTo("decimal(10,5)", "decimal(10,5)").produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)10L, (Object)"s", (Object)5L)));
        this.assertThat(function).boundTo("decimal(10,8)", "decimal(9,8)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)10L, (Object)"s", (Object)8L)));
        this.assertThat(function).boundTo("decimal(10,2)", "decimal(10,8)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)16L, (Object)"s", (Object)8L)));
        this.assertThat(function).boundTo("unknown", "decimal(10,5)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)10L, (Object)"s", (Object)5L)));
    }

    @Test
    public void testBindLiteralForRepeatedVarchar() {
        ImmutableSet literalParameters = ImmutableSet.of((Object)"x");
        TypeSignature leftType = TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)literalParameters);
        TypeSignature rightType = TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)literalParameters);
        TypeSignature returnType = TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)literalParameters);
        Signature function = TestSignatureBinder.functionSignature().returnType(returnType).argumentTypes(new TypeSignature[]{leftType, rightType}).build();
        this.assertThat(function).withCoercion().boundTo((List<String>)ImmutableList.of((Object)"varchar(3)", (Object)"varchar(5)"), "varchar(5)").produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)5L)));
        this.assertThat(function).withCoercion().boundTo((List<String>)ImmutableList.of((Object)"varchar(3)", (Object)"varchar(5)"), "varchar(6)").produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)6L)));
    }

    @Test
    public void testBindUnknown() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))}).build();
        this.assertThat(function).boundTo("unknown").fails();
        this.assertThat(function).boundTo("unknown").withCoercion().succeeds();
    }

    @Test
    public void testBindMixedLiteralAndTypeVariables() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"array(T)"), TypeSignature.parseTypeSignature((String)"array(decimal(p,s))", (Set)ImmutableSet.of((Object)"p", (Object)"s"))}).build();
        this.assertThat(function).boundTo("array(decimal(2,1))", "array(decimal(3,1))").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("decimal(2,1)")), (Map)ImmutableMap.of((Object)"p", (Object)3L, (Object)"s", (Object)1L)));
    }

    @Test
    public void testBindDifferentLiteralParameters() {
        TypeSignature argType = TypeSignature.parseTypeSignature((String)"decimal(p,s)", (Set)ImmutableSet.of((Object)"p", (Object)"s"));
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{argType, argType}).build();
        this.assertThat(function).boundTo("decimal(2,1)", "decimal(3,1)").fails();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testNoVariableReuseAcrossTypes() {
        ImmutableSet literalParameters = ImmutableSet.of((Object)"p1", (Object)"p2", (Object)"s");
        TypeSignature leftType = TypeSignature.parseTypeSignature((String)"decimal(p1,s)", (Set)literalParameters);
        TypeSignature rightType = TypeSignature.parseTypeSignature((String)"decimal(p2,s)", (Set)literalParameters);
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{leftType, rightType}).build();
        this.assertThat(function).boundTo("decimal(2,1)", "decimal(3,1)").produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
    }

    @Test
    public void testBindUnknownToDecimal() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"decimal(p,s)", (Set)ImmutableSet.of((Object)"p", (Object)"s"))}).build();
        this.assertThat(function).boundTo("unknown").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)1L, (Object)"s", (Object)0L)));
    }

    @Test
    public void testBindUnknownToConcreteArray() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"array(boolean)")}).build();
        this.assertThat(function).boundTo("unknown").withCoercion().succeeds();
    }

    @Test
    public void testBindTypeVariablesBasedOnTheSecondArgument() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"T")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"array(T)"), TypeSignature.parseTypeSignature((String)"T")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(function).boundTo("unknown", "decimal(2,1)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("decimal(2,1)")), (Map)ImmutableMap.of()));
    }

    @Test
    public void testBindParametricTypeParameterToUnknown() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"T")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"array(T)")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(function).boundTo("unknown").fails();
        this.assertThat(function).withCoercion().boundTo("unknown").succeeds();
    }

    @Test
    public void testBindUnknownToTypeParameter() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"T")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(function).boundTo("unknown").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("unknown")), (Map)ImmutableMap.of()));
    }

    @Test
    public void testBindDoubleToBigint() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double"), TypeSignature.parseTypeSignature((String)"double")}).build();
        this.assertThat(function).boundTo("double", "bigint").withCoercion().succeeds();
    }

    @Test
    public void testBindVarcharTemplateStyle() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"T2")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T1")}).typeVariableConstraints((List)ImmutableList.of((Object)new TypeVariableConstraint("T1", true, false, "varchar"), (Object)new TypeVariableConstraint("T2", true, false, "varchar"))).build();
        this.assertThat(function).boundTo((List<String>)ImmutableList.of((Object)"varchar(42)"), "varchar(1)").produces(new BoundVariables((Map)ImmutableMap.of((Object)"T1", (Object)this.type("varchar(42)"), (Object)"T2", (Object)this.type("varchar(1)")), (Map)ImmutableMap.of()));
    }

    @Test
    public void testBindVarchar() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"varchar(42)")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar(42)")}).build();
        this.assertThat(function).boundTo((List<String>)ImmutableList.of((Object)"varchar(1)"), "varchar(1)").fails();
        this.assertThat(function).boundTo((List<String>)ImmutableList.of((Object)"varchar(1)"), "varchar(1)").withCoercion().fails();
        this.assertThat(function).boundTo((List<String>)ImmutableList.of((Object)"varchar(1)"), "varchar(42)").withCoercion().succeeds();
        this.assertThat(function).boundTo((List<String>)ImmutableList.of((Object)"varchar(44)"), "varchar(44)").withCoercion().fails();
    }

    @Test
    public void testBindUnparametrizedVarchar() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))}).build();
        this.assertThat(function).boundTo("varchar").produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)Integer.MAX_VALUE)));
    }

    @Test
    public void testBindToUnparametrizedVarcharIsImpossible() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}).build();
        this.assertThat(function).boundTo("varchar(3)").withCoercion().succeeds();
        this.assertThat(function).boundTo("unknown").withCoercion().succeeds();
    }

    @Test
    public void testBasic() {
        Signature function = TestSignatureBinder.functionSignature().typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).returnType(TypeSignature.parseTypeSignature((String)"T")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T")}).build();
        this.assertThat(function).boundTo("bigint").produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("bigint")), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo("varchar").produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("varchar")), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo("varchar", "bigint").fails();
        this.assertThat(function).boundTo("array(bigint)").produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("array(bigint)")), (Map)ImmutableMap.of()));
    }

    @Test
    public void testMismatchedArgumentCount() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint"), TypeSignature.parseTypeSignature((String)"bigint")}).build();
        this.assertThat(function).boundTo("bigint", "bigint", "bigint").fails();
        this.assertThat(function).boundTo("bigint").fails();
    }

    @Test
    public void testNonParametric() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint")}).build();
        this.assertThat(function).boundTo("bigint").succeeds();
        this.assertThat(function).boundTo("varchar").withCoercion().fails();
        this.assertThat(function).boundTo("varchar", "bigint").withCoercion().fails();
        this.assertThat(function).boundTo("array(bigint)").withCoercion().fails();
    }

    @Test
    public void testArray() {
        Signature getFunction = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"T")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"array(T)")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(getFunction).boundTo("array(bigint)").produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("bigint")), (Map)ImmutableMap.of()));
        this.assertThat(getFunction).boundTo("bigint").withCoercion().fails();
        this.assertThat(getFunction).boundTo("row(bigint)").withCoercion().fails();
        Signature containsFunction = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"T")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"array(T)"), TypeSignature.parseTypeSignature((String)"T")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.comparableTypeParameter((String)"T"))).build();
        this.assertThat(containsFunction).boundTo("array(bigint)", "bigint").produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("bigint")), (Map)ImmutableMap.of()));
        this.assertThat(containsFunction).boundTo("array(bigint)", "varchar").withCoercion().fails();
        this.assertThat(containsFunction).boundTo("array(HyperLogLog)", "HyperLogLog").withCoercion().fails();
        Signature castFunction = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"array(T2)")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"array(T1)"), TypeSignature.parseTypeSignature((String)"array(T2)")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T1"), (Object)Signature.typeVariable((String)"T2"))).build();
        this.assertThat(castFunction).boundTo("array(unknown)", "array(decimal(2,1))").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T1", (Object)this.type("unknown"), (Object)"T2", (Object)this.type("decimal(2,1)")), (Map)ImmutableMap.of()));
        Signature fooFunction = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"T")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"array(T)"), TypeSignature.parseTypeSignature((String)"array(T)")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(fooFunction).boundTo("array(bigint)", "array(bigint)").produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("bigint")), (Map)ImmutableMap.of()));
        this.assertThat(fooFunction).boundTo("array(bigint)", "array(varchar)").withCoercion().fails();
    }

    @Test
    public void testMap() {
        Signature getValueFunction = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"V")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"map(K,V)"), TypeSignature.parseTypeSignature((String)"K")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"K"), (Object)Signature.typeVariable((String)"V"))).build();
        this.assertThat(getValueFunction).boundTo("map(bigint,varchar)", "bigint").produces(new BoundVariables((Map)ImmutableMap.of((Object)"K", (Object)this.type("bigint"), (Object)"V", (Object)this.type("varchar")), (Map)ImmutableMap.of()));
        this.assertThat(getValueFunction).boundTo("map(bigint,varchar)", "varchar").withCoercion().fails();
    }

    @Test
    public void testRow() {
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"row(integer)")}).build();
        this.assertThat(function).boundTo("row(tinyint)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo("row(integer)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo("row(bigint)").withCoercion().fails();
        Signature biFunction = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"row(T)"), TypeSignature.parseTypeSignature((String)"row(T)")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(biFunction).boundTo("row(bigint)", "row(bigint)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("bigint")), (Map)ImmutableMap.of()));
        this.assertThat(biFunction).boundTo("row(integer)", "row(bigint)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("bigint")), (Map)ImmutableMap.of()));
    }

    @Test
    public void testVariadic() {
        Signature mapVariadicBoundFunction = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"bigint")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.withVariadicBound((String)"T", (String)"map"))).build();
        this.assertThat(mapVariadicBoundFunction).boundTo("map(bigint,bigint)").produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("map(bigint,bigint)")), (Map)ImmutableMap.of()));
        this.assertThat(mapVariadicBoundFunction).boundTo("array(bigint)").fails();
        this.assertThat(mapVariadicBoundFunction).boundTo("array(bigint)").withCoercion().fails();
        Signature decimalVariadicBoundFunction = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"bigint")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.withVariadicBound((String)"T", (String)"decimal"))).build();
        this.assertThat(decimalVariadicBoundFunction).boundTo("decimal(2,1)").produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("decimal(2,1)")), (Map)ImmutableMap.of()));
        this.assertThat(decimalVariadicBoundFunction).boundTo("bigint").fails();
    }

    @Test
    public void testBindUnknownToVariadic() {
        Signature rowFunction = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T"), TypeSignature.parseTypeSignature((String)"T")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.withVariadicBound((String)"T", (String)"row"))).build();
        this.assertThat(rowFunction).boundTo("unknown", "row(a bigint)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("row(a bigint)")), (Map)ImmutableMap.of()));
        Signature arrayFunction = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T"), TypeSignature.parseTypeSignature((String)"T")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.withVariadicBound((String)"T", (String)"array"))).build();
        this.assertThat(arrayFunction).boundTo("unknown", "array(bigint)").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("array(bigint)")), (Map)ImmutableMap.of()));
    }

    @Test
    public void testVarArgs() {
        Signature variableArityFunction = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).setVariableArity(true).build();
        this.assertThat(variableArityFunction).boundTo("bigint").produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("bigint")), (Map)ImmutableMap.of()));
        this.assertThat(variableArityFunction).boundTo("varchar").produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("varchar")), (Map)ImmutableMap.of()));
        this.assertThat(variableArityFunction).boundTo("bigint", "bigint").produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("bigint")), (Map)ImmutableMap.of()));
        this.assertThat(variableArityFunction).boundTo("bigint", "varchar").withCoercion().fails();
    }

    @Test
    public void testCoercion() {
        Signature function = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T"), TypeSignature.parseTypeSignature((String)"double")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(function).boundTo("double", "double").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("double")), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo("bigint", "bigint").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("bigint")), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo("varchar", "bigint").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("varchar")), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo("bigint", "varchar").withCoercion().fails();
    }

    @Test
    public void testUnknownCoercion() {
        Signature foo = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T"), TypeSignature.parseTypeSignature((String)"T")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(foo).boundTo("unknown", "unknown").produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("unknown")), (Map)ImmutableMap.of()));
        this.assertThat(foo).boundTo("unknown", "bigint").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("bigint")), (Map)ImmutableMap.of()));
        this.assertThat(foo).boundTo("varchar", "bigint").withCoercion().fails();
        Signature bar = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T"), TypeSignature.parseTypeSignature((String)"T")}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.comparableTypeParameter((String)"T"))).build();
        this.assertThat(bar).boundTo("unknown", "bigint").withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)this.type("bigint")), (Map)ImmutableMap.of()));
        this.assertThat(bar).boundTo("varchar", "bigint").withCoercion().fails();
        this.assertThat(bar).boundTo("HyperLogLog", "HyperLogLog").withCoercion().fails();
    }

    @Test
    public void testFunction() {
        Signature simple = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"boolean")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"function(integer,integer)")}).build();
        this.assertThat(simple).boundTo("integer").fails();
        this.assertThat(simple).boundTo("function(integer,integer)").succeeds();
        this.assertThat(simple).boundTo("function(integer,smallint)").withCoercion().fails();
        this.assertThat(simple).boundTo("function(integer,bigint)").withCoercion().fails();
        Signature applyTwice = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"V")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T"), TypeSignature.parseTypeSignature((String)"function(T,U)"), TypeSignature.parseTypeSignature((String)"function(U,V)")}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.typeVariable((String)"T"), Signature.typeVariable((String)"U"), Signature.typeVariable((String)"V")}).build();
        this.assertThat(applyTwice).boundTo("integer", "integer", "integer").fails();
        this.assertThat(applyTwice).boundTo("integer", "function(integer,varchar)", "function(varchar,double)").produces(BoundVariables.builder().setTypeVariable("T", (Type)IntegerType.INTEGER).setTypeVariable("U", (Type)VarcharType.VARCHAR).setTypeVariable("V", (Type)DoubleType.DOUBLE).build());
        this.assertThat(applyTwice).boundTo("integer", new TypeSignatureProvider(functionArgumentTypes -> TypeSignature.parseTypeSignature((String)"function(integer,varchar)")), new TypeSignatureProvider(functionArgumentTypes -> TypeSignature.parseTypeSignature((String)"function(varchar,double)"))).produces(BoundVariables.builder().setTypeVariable("T", (Type)IntegerType.INTEGER).setTypeVariable("U", (Type)VarcharType.VARCHAR).setTypeVariable("V", (Type)DoubleType.DOUBLE).build());
        this.assertThat(applyTwice).boundTo(new TypeSignatureProvider(functionArgumentTypes -> TypeSignature.parseTypeSignature((String)"function(integer,varchar)")), new TypeSignatureProvider(functionArgumentTypes -> TypeSignature.parseTypeSignature((String)"function(integer,varchar)")), new TypeSignatureProvider(functionArgumentTypes -> TypeSignature.parseTypeSignature((String)"function(varchar,double)"))).fails();
        this.assertThat(applyTwice).boundTo(new TypeSignatureProvider(functionArgumentTypes -> TypeSignature.parseTypeSignature((String)"function(integer,varchar)")), "integer", new TypeSignatureProvider(functionArgumentTypes -> TypeSignature.parseTypeSignature((String)"function(varchar,double)"))).fails();
        Signature flatMap = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"array(T)")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"array(T)"), TypeSignature.parseTypeSignature((String)"function(T, array(T))")}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.typeVariable((String)"T")}).build();
        this.assertThat(flatMap).boundTo("array(integer)", "function(integer, array(integer))").produces(BoundVariables.builder().setTypeVariable("T", (Type)IntegerType.INTEGER).build());
        Signature varargApply = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"T")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T"), TypeSignature.parseTypeSignature((String)"function(T, T)")}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.typeVariable((String)"T")}).setVariableArity(true).build();
        this.assertThat(varargApply).boundTo("integer", "function(integer, integer)", "function(integer, integer)", "function(integer, integer)").produces(BoundVariables.builder().setTypeVariable("T", (Type)IntegerType.INTEGER).build());
        this.assertThat(varargApply).boundTo("integer", "function(integer, integer)", "function(integer, double)", "function(double, double)").fails();
        Signature loop = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"T")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"T"), TypeSignature.parseTypeSignature((String)"function(T, T)")}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.typeVariable((String)"T")}).build();
        this.assertThat(loop).boundTo("integer", new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)BigintType.BIGINT).getTypeSignature())).fails();
        this.assertThat(loop).boundTo("integer", new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)BigintType.BIGINT).getTypeSignature())).withCoercion().produces(BoundVariables.builder().setTypeVariable("T", (Type)BigintType.BIGINT).build());
        this.assertThat(loop).withCoercion().boundTo("integer", new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)SmallintType.SMALLINT).getTypeSignature())).fails();
        Signature varcharApply = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"varchar")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar"), TypeSignature.parseTypeSignature((String)"function(varchar, varchar(x))", (Set)ImmutableSet.of((Object)"x"))}).build();
        this.assertThat(varcharApply).withCoercion().boundTo("varchar(10)", new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)VarcharType.createVarcharType((int)1)).getTypeSignature())).succeeds();
        Signature sortByKey = TestSignatureBinder.functionSignature().returnType(TypeSignature.parseTypeSignature((String)"array(T)")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"array(T)"), TypeSignature.parseTypeSignature((String)"function(T,E)")}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.typeVariable((String)"T"), Signature.orderableTypeParameter((String)"E")}).build();
        this.assertThat(sortByKey).boundTo("array(integer)", new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)VarcharType.VARCHAR).getTypeSignature())).produces(BoundVariables.builder().setTypeVariable("T", (Type)IntegerType.INTEGER).setTypeVariable("E", (Type)VarcharType.VARCHAR).build());
    }

    @Test
    public void testBindParameters() {
        BoundVariables boundVariables = BoundVariables.builder().setTypeVariable("T1", (Type)DoubleType.DOUBLE).setTypeVariable("T2", (Type)BigintType.BIGINT).setTypeVariable("T3", (Type)DecimalType.createDecimalType((int)5, (int)3)).setLongVariable("p", Long.valueOf(1L)).setLongVariable("s", Long.valueOf(2L)).build();
        TestSignatureBinder.assertThat("bigint", boundVariables, "bigint");
        TestSignatureBinder.assertThat("T1", boundVariables, "double");
        TestSignatureBinder.assertThat("T2", boundVariables, "bigint");
        TestSignatureBinder.assertThat("array(T1)", boundVariables, "array(double)");
        TestSignatureBinder.assertThat("array(T3)", boundVariables, "array(decimal(5,3))");
        TestSignatureBinder.assertThat("array<T1>", boundVariables, "array(double)");
        TestSignatureBinder.assertThat("map(T1,T2)", boundVariables, "map(double,bigint)");
        TestSignatureBinder.assertThat("map<T1,T2>", boundVariables, "map(double,bigint)");
        TestSignatureBinder.assertThat("bla(T1,42,T2)", boundVariables, "bla(double,42,bigint)");
        TestSignatureBinder.assertThat("varchar(p)", boundVariables, "varchar(1)");
        TestSignatureBinder.assertThat("char(p)", boundVariables, "char(1)");
        TestSignatureBinder.assertThat("decimal(p,s)", boundVariables, "decimal(1,2)");
        TestSignatureBinder.assertThat("array(decimal(p,s))", boundVariables, "array(decimal(1,2))");
        TestSignatureBinder.assertBindVariablesFails("T1(bigint)", boundVariables, "Unbounded parameters can not have parameters");
    }

    private static void assertBindVariablesFails(String typeSignature, BoundVariables boundVariables, String reason) {
        try {
            SignatureBinder.applyBoundVariables((TypeSignature)TypeSignature.parseTypeSignature((String)typeSignature, (Set)ImmutableSet.of((Object)"p", (Object)"s")), (BoundVariables)boundVariables);
            Assert.fail((String)reason);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static void assertThat(String typeSignature, BoundVariables boundVariables, String expectedTypeSignature) {
        Assert.assertEquals((String)SignatureBinder.applyBoundVariables((TypeSignature)TypeSignature.parseTypeSignature((String)typeSignature, (Set)ImmutableSet.of((Object)"p", (Object)"s")), (BoundVariables)boundVariables).toString(), (String)expectedTypeSignature);
    }

    private static SignatureBuilder functionSignature() {
        return new SignatureBuilder().name("function").kind(FunctionKind.SCALAR);
    }

    private Type type(String signature) {
        TypeSignature typeSignature = TypeSignature.parseTypeSignature((String)signature);
        return Objects.requireNonNull(this.functionAndTypeManager.getType(typeSignature));
    }

    private List<Type> types(String ... signatures) {
        return ImmutableList.copyOf((Object[])signatures).stream().map(this::type).collect(Collectors.toList());
    }

    private BindSignatureAssertion assertThat(Signature function) {
        return new BindSignatureAssertion(function);
    }

    private class BindSignatureAssertion {
        private final Signature function;
        private List<TypeSignatureProvider> argumentTypes;
        private Type returnType;
        private boolean allowCoercion;

        private BindSignatureAssertion(Signature function) {
            this.function = function;
        }

        public BindSignatureAssertion withCoercion() {
            this.allowCoercion = true;
            return this;
        }

        public BindSignatureAssertion boundTo(Object ... arguments) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object argument : arguments) {
                if (argument instanceof String) {
                    builder.add((Object)new TypeSignatureProvider(TypeSignature.parseTypeSignature((String)((String)argument))));
                    continue;
                }
                if (argument instanceof TypeSignatureProvider) {
                    builder.add((Object)((TypeSignatureProvider)argument));
                    continue;
                }
                throw new IllegalArgumentException(String.format("argument is of type %s. It should be String or TypeSignatureProvider", argument.getClass()));
            }
            this.argumentTypes = builder.build();
            return this;
        }

        public BindSignatureAssertion boundTo(List<String> arguments, String returnType) {
            this.argumentTypes = TypeSignatureProvider.fromTypes((List)TestSignatureBinder.this.types(arguments.toArray(new String[arguments.size()])));
            this.returnType = TestSignatureBinder.this.type(returnType);
            return this;
        }

        public BindSignatureAssertion succeeds() {
            Assert.assertTrue((boolean)this.bindVariables().isPresent());
            return this;
        }

        public BindSignatureAssertion fails() {
            Assert.assertFalse((boolean)this.bindVariables().isPresent());
            return this;
        }

        public BindSignatureAssertion produces(BoundVariables expected) {
            Optional<BoundVariables> actual = this.bindVariables();
            Assert.assertTrue((boolean)actual.isPresent());
            Assert.assertEquals((Object)actual.get(), (Object)expected);
            return this;
        }

        private Optional<BoundVariables> bindVariables() {
            Assert.assertNotNull(this.argumentTypes);
            SignatureBinder signatureBinder = new SignatureBinder((TypeManager)TestSignatureBinder.this.functionAndTypeManager, this.function, this.allowCoercion);
            if (this.returnType == null) {
                return signatureBinder.bindVariables(this.argumentTypes);
            }
            return signatureBinder.bindVariables(this.argumentTypes, this.returnType);
        }
    }
}

