/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.UncheckedByteArrays;
import com.google.common.primitives.Booleans;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import sun.misc.Unsafe;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkUncheckedByteArrays {
    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkUncheckedByteArrays.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @Benchmark
    public int sequentialCopyToByteArray(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            index = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.longValues[i]);
        }
        return index;
    }

    @Benchmark
    public int sequentialCopyToBasicSliceOutput(BenchmarkData data) {
        return this.sequentialCopyToSliceOutput(data.basicSliceOutput, data.longValues);
    }

    @Benchmark
    public int sequentialCopyToDynamicSliceOutput(BenchmarkData data) {
        return this.sequentialCopyToSliceOutput(data.dynamicSliceOutput, data.longValues);
    }

    @Benchmark
    public int sequentialCopyToTestingSliceOutput(BenchmarkData data) {
        TestingSliceOutput sliceOutput = data.testingSliceOutput;
        sliceOutput.reset();
        for (int i = 0; i < data.longValues.length; ++i) {
            sliceOutput.writeLong(data.longValues[i]);
        }
        return sliceOutput.size();
    }

    @Benchmark
    public int sequentialCopyWithNullsToByteArray(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            int newIndex = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.longValues[i]);
            if (!data.nulls[i]) continue;
            index = newIndex;
        }
        return index;
    }

    @Benchmark
    public int sequentialCopyWithNullsToByteArrayNaive(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            if (data.nulls[i]) continue;
            index = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)index, (long)data.longValues[i]);
        }
        return index;
    }

    @Benchmark
    public int sequentialCopyWithNullsToBasicSliceOutput(BenchmarkData data) {
        return this.sequentialCopyWithNullsToSliceOutput(data.basicSliceOutput, data.longValues, data.nulls);
    }

    @Benchmark
    public int sequentialCopyWithNullsToDynamicSliceOutput(BenchmarkData data) {
        return this.sequentialCopyWithNullsToSliceOutput(data.dynamicSliceOutput, data.longValues, data.nulls);
    }

    @Benchmark
    public int sequentialCopyWithNullsToTestingSliceOutputNaive(BenchmarkData data) {
        TestingSliceOutput sliceOutput = data.testingSliceOutput;
        sliceOutput.reset();
        for (int i = 0; i < data.longValues.length; ++i) {
            if (!data.nulls[i]) continue;
            sliceOutput.writeLong(data.longValues[i]);
        }
        return sliceOutput.size();
    }

    @Benchmark
    public int sequentialCopyWithNullsToTestingSliceOutput(BenchmarkData data) {
        TestingSliceOutput sliceOutput = data.testingSliceOutput;
        sliceOutput.reset();
        for (int i = 0; i < data.longValues.length; ++i) {
            sliceOutput.writeLong(data.longValues[i], data.nulls[i]);
        }
        return sliceOutput.size();
    }

    @Benchmark
    public int randomCopyToByteArray(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            index = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)(data.positions[i] * Unsafe.ARRAY_LONG_INDEX_SCALE), (long)data.longValues[i]);
        }
        return index;
    }

    @Benchmark
    public int randomCopyWithNullsToByteArray(BenchmarkData data) {
        int index = 0;
        for (int i = 0; i < data.longValues.length; ++i) {
            if (!data.nulls[i]) continue;
            index = UncheckedByteArrays.setLongUnchecked((byte[])data.bytes, (int)(data.positions[i] * Unsafe.ARRAY_LONG_INDEX_SCALE), (long)data.longValues[i]);
        }
        return index;
    }

    private int sequentialCopyToSliceOutput(SliceOutput sliceOutput, long[] values) {
        sliceOutput.reset();
        for (int i = 0; i < values.length; ++i) {
            sliceOutput.writeLong(values[i]);
        }
        return sliceOutput.size();
    }

    private int sequentialCopyWithNullsToSliceOutput(SliceOutput sliceOutput, long[] values, boolean[] nulls) {
        sliceOutput.reset();
        for (int i = 0; i < values.length; ++i) {
            if (nulls[i]) continue;
            sliceOutput.writeLong(values[i]);
        }
        return sliceOutput.size();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int POSITIONS_PER_PAGE = 10000;
        private final Random random = new Random(0L);
        private final long[] longValues = LongStream.range(0L, 10000L).map(i -> this.random.nextLong()).toArray();
        private final boolean[] nulls = Booleans.toArray((Collection)Stream.generate(() -> this.random.nextBoolean()).limit(10000L).collect(Collectors.toCollection(ArrayList::new)));
        private final int[] positions = IntStream.range(0, 10000).toArray();
        private final byte[] byteValues = new byte[10000 * Unsafe.ARRAY_LONG_INDEX_SCALE];
        private final byte[] bytes = new byte[10000 * Unsafe.ARRAY_LONG_INDEX_SCALE];
        private final SliceOutput basicSliceOutput = Slices.wrappedBuffer((byte[])new byte[10000 * Unsafe.ARRAY_LONG_INDEX_SCALE]).getOutput();
        private final SliceOutput dynamicSliceOutput = new DynamicSliceOutput(10000 * Unsafe.ARRAY_LONG_INDEX_SCALE);
        private final TestingSliceOutput testingSliceOutput = new TestingSliceOutput(10000 * Unsafe.ARRAY_LONG_INDEX_SCALE);

        @Setup
        public void setup() {
            this.random.nextBytes(this.byteValues);
        }
    }

    private static class TestingSliceOutput {
        private static Unsafe unsafe;
        public int size;
        private byte[] buffer;

        TestingSliceOutput(int initialSize) {
            this.buffer = new byte[initialSize];
        }

        public void writeLong(long value) {
            unsafe.putLong(this.buffer, (long)this.size + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value);
            this.size += Unsafe.ARRAY_LONG_INDEX_SCALE;
        }

        public void writeLong(long value, int address) {
            unsafe.putLong(this.buffer, (long)address + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value);
        }

        public void writeLong(long value, boolean isNull) {
            unsafe.putLong(this.buffer, (long)this.size + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, value);
            if (!isNull) {
                this.size += Unsafe.ARRAY_LONG_INDEX_SCALE;
            }
        }

        public int size() {
            return this.size;
        }

        public void reset() {
            this.size = 0;
        }

        static {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                unsafe = (Unsafe)field.get(null);
                if (unsafe == null) {
                    throw new RuntimeException("Unsafe access not available");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

