/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.TestAnnotationEngine;
import com.facebook.presto.operator.annotations.LiteralImplementationDependency;
import com.facebook.presto.operator.annotations.TypeImplementationDependency;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ParametricScalar;
import com.facebook.presto.operator.scalar.annotations.ParametricScalarImplementation;
import com.facebook.presto.operator.scalar.annotations.ScalarFromAnnotationsParser;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameters;
import com.facebook.presto.type.LiteralParameter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAnnotationEngineForScalars
extends TestAnnotationEngine {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = FunctionAndTypeManager.createTestFunctionAndTypeManager();

    @Test
    public void testSingleImplementationScalarParse() {
        Signature expectedSignature = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"single_implementation_parametric_scalar"), FunctionKind.SCALAR, DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(SingleImplementationScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        Assert.assertEquals((Object)scalar.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)scalar.isDeterministic());
        Assert.assertEquals((Object)scalar.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
        Assert.assertEquals((String)scalar.getDescription(), (String)"Simple scalar with single implementation based on class");
        this.assertImplementationCount(scalar, 1, 0, 0);
        BuiltInScalarFunctionImplementation specialized = scalar.specialize(BoundVariables.builder().build(), 1, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertFalse((boolean)specialized.getInstanceFactory().isPresent());
        Assert.assertEquals((Object)specialized.getArgumentProperty(0).getNullConvention(), (Object)BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL);
    }

    @Test
    public void testHiddenScalarParse() {
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(HiddenScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        Assert.assertTrue((boolean)scalar.isDeterministic());
        Assert.assertEquals((Object)scalar.getVisibility(), (Object)SqlFunctionVisibility.HIDDEN);
    }

    @Test
    public void testBetaScalarParse() {
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(BetaScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        Assert.assertTrue((boolean)scalar.isDeterministic());
        Assert.assertEquals((Object)scalar.getVisibility(), (Object)SqlFunctionVisibility.EXPERIMENTAL);
    }

    @Test
    public void testNonDeterministicScalarParse() {
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(NonDeterministicScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        Assert.assertFalse((boolean)scalar.isDeterministic());
        Assert.assertEquals((Object)scalar.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
    }

    @Test
    public void testWithNullablePrimitiveArgScalarParse() {
        Signature expectedSignature = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"scalar_with_nullable"), FunctionKind.SCALAR, DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature(), (Object)DoubleType.DOUBLE.getTypeSignature()));
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(WithNullablePrimitiveArgScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        Assert.assertEquals((Object)scalar.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)scalar.isDeterministic());
        Assert.assertEquals((Object)scalar.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
        Assert.assertEquals((String)scalar.getDescription(), (String)"Simple scalar with nullable primitive");
        BuiltInScalarFunctionImplementation specialized = scalar.specialize(BoundVariables.builder().build(), 2, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertFalse((boolean)specialized.getInstanceFactory().isPresent());
        Assert.assertEquals((Object)specialized.getArgumentProperty(0), (Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((BuiltInScalarFunctionImplementation.NullConvention)BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL));
        Assert.assertEquals((Object)specialized.getArgumentProperty(1), (Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((BuiltInScalarFunctionImplementation.NullConvention)BuiltInScalarFunctionImplementation.NullConvention.USE_NULL_FLAG));
    }

    @Test
    public void testWithNullableComplexArgScalarParse() {
        Signature expectedSignature = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"scalar_with_nullable_complex"), FunctionKind.SCALAR, DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature(), (Object)DoubleType.DOUBLE.getTypeSignature()));
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(WithNullableComplexArgScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        Assert.assertEquals((Object)scalar.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)scalar.isDeterministic());
        Assert.assertEquals((Object)scalar.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
        Assert.assertEquals((String)scalar.getDescription(), (String)"Simple scalar with nullable complex type");
        BuiltInScalarFunctionImplementation specialized = scalar.specialize(BoundVariables.builder().build(), 2, FUNCTION_AND_TYPE_MANAGER);
        Assert.assertFalse((boolean)specialized.getInstanceFactory().isPresent());
        Assert.assertEquals((Object)specialized.getArgumentProperty(0), (Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((BuiltInScalarFunctionImplementation.NullConvention)BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL));
        Assert.assertEquals((Object)specialized.getArgumentProperty(1), (Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((BuiltInScalarFunctionImplementation.NullConvention)BuiltInScalarFunctionImplementation.NullConvention.USE_BOXED_TYPE));
    }

    @Test
    public void testStaticMethodScalarParse() {
        Signature expectedSignature = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"static_method_scalar"), FunctionKind.SCALAR, DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinitions(StaticMethodScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        Assert.assertEquals((Object)scalar.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)scalar.isDeterministic());
        Assert.assertEquals((Object)scalar.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
        Assert.assertEquals((String)scalar.getDescription(), (String)"Simple scalar with single implementation based on method");
    }

    @Test
    public void testMultiScalarParse() {
        Signature expectedSignature1 = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"static_method_scalar_1"), FunctionKind.SCALAR, DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        Signature expectedSignature2 = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"static_method_scalar_2"), FunctionKind.SCALAR, BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature()));
        Signature expectedSignature3 = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"static_method_scalar_3"), FunctionKind.SCALAR, BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature()));
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinitions(MultiScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)3);
        ParametricScalar scalar1 = (ParametricScalar)((ImmutableList)functions.stream().filter(signature -> signature.getSignature().equals((Object)expectedSignature1)).collect(ImmutableList.toImmutableList())).get(0);
        ParametricScalar scalar2 = (ParametricScalar)((ImmutableList)functions.stream().filter(signature -> signature.getSignature().equals((Object)expectedSignature2)).collect(ImmutableList.toImmutableList())).get(0);
        ParametricScalar scalar3 = (ParametricScalar)((ImmutableList)functions.stream().filter(signature -> signature.getSignature().equals((Object)expectedSignature3)).collect(ImmutableList.toImmutableList())).get(0);
        this.assertImplementationCount(scalar1, 1, 0, 0);
        this.assertImplementationCount(scalar2, 1, 0, 0);
        Assert.assertEquals((Object)scalar1.getSignature(), (Object)expectedSignature1);
        Assert.assertTrue((boolean)scalar1.isDeterministic());
        Assert.assertEquals((Object)scalar1.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
        Assert.assertEquals((String)scalar1.getDescription(), (String)"Simple scalar with single implementation based on method 1");
        Assert.assertEquals((Object)scalar2.getSignature(), (Object)expectedSignature2);
        Assert.assertFalse((boolean)scalar2.isDeterministic());
        Assert.assertEquals((Object)scalar2.getVisibility(), (Object)SqlFunctionVisibility.HIDDEN);
        Assert.assertEquals((String)scalar2.getDescription(), (String)"Simple scalar with single implementation based on method 2");
        Assert.assertEquals((Object)scalar3.getSignature(), (Object)expectedSignature3);
        Assert.assertFalse((boolean)scalar3.isDeterministic());
        Assert.assertEquals((Object)scalar3.getVisibility(), (Object)SqlFunctionVisibility.EXPERIMENTAL);
        Assert.assertEquals((String)scalar3.getDescription(), (String)"Simple scalar with single implementation based on method 3");
    }

    @Test
    public void testParametricScalarParse() {
        Signature expectedSignature = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"parametric_scalar"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T")), false);
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(ParametricScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 0, 2, 0);
        Assert.assertEquals((Object)scalar.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)scalar.isDeterministic());
        Assert.assertEquals((Object)scalar.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
        Assert.assertEquals((String)scalar.getDescription(), (String)"Parametric scalar description");
    }

    @Test
    public void testComplexParametricScalarParse() {
        Signature expectedSignature = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"with_exact_scalar"), FunctionKind.SCALAR, (List)ImmutableList.of(), (List)ImmutableList.of(), BooleanType.BOOLEAN.getTypeSignature(), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(varchar(x))", (Set)ImmutableSet.of((Object)"x"))), false);
        Signature exactSignature = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"with_exact_scalar"), FunctionKind.SCALAR, (List)ImmutableList.of(), (List)ImmutableList.of(), BooleanType.BOOLEAN.getTypeSignature(), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(varchar(17))")), false);
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(ComplexParametricScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar.getImplementations(), 1, 0, 1);
        Assert.assertEquals((Object)Iterables.getOnlyElement(scalar.getImplementations().getExactImplementations().keySet()), (Object)exactSignature);
        Assert.assertEquals((Object)scalar.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)scalar.isDeterministic());
        Assert.assertEquals((Object)scalar.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
        Assert.assertEquals((String)scalar.getDescription(), (String)"Parametric scalar with exact and generic implementations");
    }

    @Test
    public void testSimpleInjectionScalarParse() {
        Signature expectedSignature = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"parametric_scalar_inject"), FunctionKind.SCALAR, (List)ImmutableList.of(), (List)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))), false);
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(SimpleInjectionScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 0, 0, 1);
        List parametricScalarImplementationChoices = ((ParametricScalarImplementation)scalar.getImplementations().getGenericImplementations().get(0)).getChoices();
        Assert.assertEquals((int)parametricScalarImplementationChoices.size(), (int)1);
        List dependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getDependencies();
        Assert.assertEquals((int)dependencies.size(), (int)1);
        Assert.assertTrue((boolean)(dependencies.get(0) instanceof LiteralImplementationDependency));
        Assert.assertEquals((Object)scalar.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)scalar.isDeterministic());
        Assert.assertEquals((Object)scalar.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
        Assert.assertEquals((String)scalar.getDescription(), (String)"Parametric scalar with literal injected");
    }

    @Test
    public void testConstructorInjectionScalarParse() {
        Signature expectedSignature = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"parametric_scalar_inject_constructor"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(T)")), false);
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(ConstructorInjectionScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 2, 0, 1);
        List parametricScalarImplementationChoices = ((ParametricScalarImplementation)scalar.getImplementations().getGenericImplementations().get(0)).getChoices();
        Assert.assertEquals((int)parametricScalarImplementationChoices.size(), (int)1);
        List dependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getDependencies();
        Assert.assertEquals((int)dependencies.size(), (int)0);
        List constructorDependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getConstructorDependencies();
        Assert.assertEquals((int)constructorDependencies.size(), (int)1);
        Assert.assertTrue((boolean)(constructorDependencies.get(0) instanceof TypeImplementationDependency));
        Assert.assertEquals((Object)scalar.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)scalar.isDeterministic());
        Assert.assertEquals((Object)scalar.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
        Assert.assertEquals((String)scalar.getDescription(), (String)"Parametric scalar with type injected though constructor");
    }

    @Test
    public void testFixedTypeParameterParse() {
        Signature expectedSignature = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"fixed_type_parameter_scalar_function"), FunctionKind.SCALAR, (List)ImmutableList.of(), (List)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature()), false);
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(FixedTypeParameterScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 1, 0, 0);
        Assert.assertEquals((Object)scalar.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)scalar.isDeterministic());
        Assert.assertEquals((Object)scalar.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
        Assert.assertEquals((String)scalar.getDescription(), (String)"Parametric scalar that uses TypeParameter with fixed type");
    }

    @Test
    public void testPartiallyFixedTypeParameterParse() {
        Signature expectedSignature = new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"partially_fixed_type_parameter_scalar_function"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T1"), (Object)Signature.typeVariable((String)"T2")), (List)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature()), false);
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(PartiallyFixedTypeParameterScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 0, 0, 1);
        List parametricScalarImplementationChoices = ((ParametricScalarImplementation)scalar.getImplementations().getGenericImplementations().get(0)).getChoices();
        Assert.assertEquals((int)parametricScalarImplementationChoices.size(), (int)1);
        List dependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getDependencies();
        Assert.assertEquals((int)dependencies.size(), (int)1);
        Assert.assertEquals((Object)scalar.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)scalar.isDeterministic());
        Assert.assertEquals((Object)scalar.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
        Assert.assertEquals((String)scalar.getDescription(), (String)"Parametric scalar that uses TypeParameter with partially fixed type");
    }

    @ScalarFunction(value="partially_fixed_type_parameter_scalar_function")
    @Description(value="Parametric scalar that uses TypeParameter with partially fixed type")
    public static final class PartiallyFixedTypeParameterScalarFunction {
        @SqlType(value="bigint")
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static long fun(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    @ScalarFunction(value="fixed_type_parameter_scalar_function")
    @Description(value="Parametric scalar that uses TypeParameter with fixed type")
    public static final class FixedTypeParameterScalarFunction {
        @SqlType(value="bigint")
        public static long fun(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    @ScalarFunction(value="parametric_scalar_inject_constructor")
    @Description(value="Parametric scalar with type injected though constructor")
    public static class ConstructorInjectionScalarFunction {
        private final Type type;

        @TypeParameter(value="T")
        public ConstructorInjectionScalarFunction(@TypeParameter(value="T") Type type) {
            this.type = type;
        }

        @SqlType(value="bigint")
        @TypeParameter(value="T")
        public long fun(@SqlType(value="array(T)") Block val) {
            return 17L;
        }

        @SqlType(value="bigint")
        public long funBigint(@SqlType(value="array(bigint)") Block val) {
            return 17L;
        }

        @SqlType(value="bigint")
        public long funDouble(@SqlType(value="array(double)") Block val) {
            return 17L;
        }
    }

    @ScalarFunction(value="parametric_scalar_inject")
    @Description(value="Parametric scalar with literal injected")
    public static class SimpleInjectionScalarFunction {
        @SqlType(value="bigint")
        @LiteralParameters(value={"x"})
        public static long fun(@LiteralParameter(value="x") Long literalParam, @SqlType(value="varchar(x)") Slice val) {
            return literalParam;
        }
    }

    @ScalarFunction(value="with_exact_scalar")
    @Description(value="Parametric scalar with exact and generic implementations")
    public static class ComplexParametricScalarFunction {
        @SqlType(value="boolean")
        @LiteralParameters(value={"x"})
        public static boolean fun1(@SqlType(value="array(varchar(x))") Block array) {
            return true;
        }

        @SqlType(value="boolean")
        public static boolean fun2(@SqlType(value="array(varchar(17))") Block array) {
            return true;
        }
    }

    @ScalarFunction(value="parametric_scalar")
    @Description(value="Parametric scalar description")
    public static class ParametricScalarFunction {
        @SqlType(value="T")
        @TypeParameter(value="T")
        public static double fun(@SqlType(value="T") double v) {
            return v;
        }

        @SqlType(value="T")
        @TypeParameter(value="T")
        public static long fun(@SqlType(value="T") long v) {
            return v;
        }
    }

    public static class MultiScalarFunction {
        @ScalarFunction(value="static_method_scalar_1")
        @Description(value="Simple scalar with single implementation based on method 1")
        @SqlType(value="double")
        public static double fun1(@SqlType(value="double") double v) {
            return v;
        }

        @ScalarFunction(value="static_method_scalar_2", visibility=SqlFunctionVisibility.HIDDEN, deterministic=false)
        @Description(value="Simple scalar with single implementation based on method 2")
        @SqlType(value="bigint")
        public static long fun2(@SqlType(value="bigint") long v) {
            return v;
        }

        @ScalarFunction(value="static_method_scalar_3", visibility=SqlFunctionVisibility.EXPERIMENTAL, deterministic=false)
        @Description(value="Simple scalar with single implementation based on method 3")
        @SqlType(value="bigint")
        public static long fun3(@SqlType(value="bigint") long v) {
            return v;
        }
    }

    public static class StaticMethodScalarFunction {
        @ScalarFunction(value="static_method_scalar")
        @Description(value="Simple scalar with single implementation based on method")
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    @ScalarFunction(value="scalar_with_nullable_complex", calledOnNullInput=true)
    @Description(value="Simple scalar with nullable complex type")
    public static class WithNullableComplexArgScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v, @SqlNullable @SqlType(value="double") Double v2) {
            return v;
        }
    }

    @ScalarFunction(value="scalar_with_nullable", calledOnNullInput=true)
    @Description(value="Simple scalar with nullable primitive")
    public static class WithNullablePrimitiveArgScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v, @SqlType(value="double") double v2, @IsNull boolean v2isNull) {
            return v;
        }
    }

    @ScalarFunction(value="non_deterministic_scalar_function", deterministic=false)
    @Description(value="Simple scalar with deterministic property reset")
    public static class NonDeterministicScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    @ScalarFunction(value="beta_scalar_function", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Simple scalar with visibility set to beta")
    public static class BetaScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    @ScalarFunction(value="hidden_scalar_function", visibility=SqlFunctionVisibility.HIDDEN)
    @Description(value="Simple scalar with visibility set to hidden")
    public static class HiddenScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    @ScalarFunction(value="single_implementation_parametric_scalar")
    @Description(value="Simple scalar with single implementation based on class")
    public static class SingleImplementationScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }
}

