/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.execution.FragmentResultCacheContext;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FileFragmentResultCacheManager;
import com.facebook.presto.operator.FragmentResultCacheManager;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.TableScanOperator;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.planner.CanonicalPlanFragment;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.PageConsumerOperator;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDriver {
    private static final TableHandle TESTING_TABLE_HANDLE = new TableHandle(new ConnectorId("test"), new ConnectorTableHandle(){}, new ConnectorTransactionHandle(){}, Optional.empty());
    private static final FragmentResultCacheContext TESTING_FRAGMENT_RESULT_CACHE_CONTEXT = (FragmentResultCacheContext)FragmentResultCacheContext.createFragmentResultCacheContext((FragmentResultCacheManager)new TestingFragmentResultCacheManager(), (PlanNode)new AggregationNode(new PlanNodeId("test-agg"), (PlanNode)new TableScanNode(new PlanNodeId("test-scan"), TESTING_TABLE_HANDLE, (List)ImmutableList.of(), (Map)ImmutableMap.of(), TupleDomain.all(), TupleDomain.all()), (Map)ImmutableMap.of(), AggregationNode.singleGroupingSet((List)ImmutableList.of()), (List)ImmutableList.of(), AggregationNode.Step.PARTIAL, Optional.empty(), Optional.empty()), (PartitioningScheme)new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (Collection)ImmutableList.of()), (List)ImmutableList.of()), (Session)TestingSession.testSessionBuilder().setSystemProperty("fragment_result_caching_enabled", "true").build()).get();
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;
    private DriverContext driverContextWithFragmentResultCacheContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        this.driverContextWithFragmentResultCacheContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (FragmentResultCacheContext)TESTING_FRAGMENT_RESULT_CACHE_CONTEXT).addPipelineContext(0, true, true, false).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testNormalFinish() {
        this.testNormalFinish(this.driverContext);
        this.testNormalFinish(this.driverContextWithFragmentResultCacheContext);
    }

    private void testNormalFinish(DriverContext driverContext) {
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        ValuesOperator source = new ValuesOperator(driverContext.addOperatorContext(0, new PlanNodeId("test"), "values"), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).addSequencePage(10, 20, 30, 40).build());
        PageConsumerOperator sink = this.createSinkOperator(driverContext, (List<Type>)types);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)source, (Operator[])new Operator[]{sink});
        Assert.assertSame((Object)driver.getDriverContext(), (Object)driverContext);
        Assert.assertFalse((boolean)driver.isFinished());
        ListenableFuture blocked = driver.processFor(new Duration(1.0, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)blocked.isDone());
        Assert.assertTrue((boolean)driver.isFinished());
        Assert.assertTrue((boolean)sink.isFinished());
        Assert.assertTrue((boolean)source.isFinished());
    }

    @Test(invocationCount=1000, timeOut=10000L)
    public void testConcurrentClose() {
        this.testConcurrentClose(this.driverContext);
        this.testConcurrentClose(this.driverContextWithFragmentResultCacheContext);
    }

    private void testConcurrentClose(DriverContext driverContext) {
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), "values");
        ValuesOperator source = new ValuesOperator(operatorContext, RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).addSequencePage(10, 20, 30, 40).build());
        PageConsumerOperator sink = this.createSinkOperator(driverContext, (List<Type>)types);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)source, (Operator[])new Operator[]{sink});
        this.scheduledExecutor.submit(() -> driver.processFor(new Duration(1.0, TimeUnit.NANOSECONDS)));
        this.scheduledExecutor.submit(() -> ((Driver)driver).close());
        while (!driverContext.isDone()) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    @Test
    public void testAbruptFinish() {
        this.testAbruptFinish(this.driverContext);
        this.testAbruptFinish(this.driverContextWithFragmentResultCacheContext);
    }

    private void testAbruptFinish(DriverContext driverContext) {
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        ValuesOperator source = new ValuesOperator(driverContext.addOperatorContext(0, new PlanNodeId("test"), "values"), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).addSequencePage(10, 20, 30, 40).build());
        PageConsumerOperator sink = this.createSinkOperator(driverContext, (List<Type>)types);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)source, (Operator[])new Operator[]{sink});
        Assert.assertSame((Object)driver.getDriverContext(), (Object)driverContext);
        Assert.assertFalse((boolean)driver.isFinished());
        driver.close();
        Assert.assertTrue((boolean)driver.isFinished());
        Assert.assertFalse((boolean)source.isFinished());
        Assert.assertFalse((boolean)sink.isFinished());
        Assert.assertTrue((boolean)sink.isClosed());
    }

    @Test
    public void testAddSourceFinish() {
        this.testAddSourceFinish(this.driverContext);
        this.testAddSourceFinish(this.driverContextWithFragmentResultCacheContext);
    }

    private void testAddSourceFinish(DriverContext driverContext) {
        PlanNodeId sourceId = new PlanNodeId("source");
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        TableScanOperator source = new TableScanOperator(driverContext.addOperatorContext(99, new PlanNodeId("test"), "values"), sourceId, (arg_0, arg_1, arg_2, arg_3) -> TestDriver.lambda$testAddSourceFinish$1((List)types, arg_0, arg_1, arg_2, arg_3), TESTING_TABLE_HANDLE, (Iterable)ImmutableList.of());
        PageConsumerOperator sink = this.createSinkOperator(driverContext, (List<Type>)types);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)source, (Operator[])new Operator[]{sink});
        Assert.assertSame((Object)driver.getDriverContext(), (Object)driverContext);
        Assert.assertFalse((boolean)driver.isFinished());
        Assert.assertFalse((boolean)driver.processFor(new Duration(1.0, TimeUnit.MILLISECONDS)).isDone());
        Assert.assertFalse((boolean)driver.isFinished());
        driver.updateSource(new TaskSource(sourceId, (Set)ImmutableSet.of((Object)new ScheduledSplit(0L, sourceId, TestDriver.newMockSplit())), true));
        Assert.assertFalse((boolean)driver.isFinished());
        Assert.assertTrue((boolean)driver.processFor(new Duration(1.0, TimeUnit.SECONDS)).isDone());
        Assert.assertTrue((boolean)driver.isFinished());
        Assert.assertTrue((boolean)sink.isFinished());
        Assert.assertTrue((boolean)source.isFinished());
    }

    @Test
    public void testBrokenOperatorCloseWhileProcessing() throws Exception {
        this.testBrokenOperatorCloseWhileProcessing(this.driverContext);
        this.testBrokenOperatorCloseWhileProcessing(this.driverContextWithFragmentResultCacheContext);
    }

    private void testBrokenOperatorCloseWhileProcessing(DriverContext driverContext) throws Exception {
        BrokenOperator brokenOperator = new BrokenOperator(driverContext.addOperatorContext(0, new PlanNodeId("test"), "source"), false);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)brokenOperator, (Operator[])new Operator[]{this.createSinkOperator(driverContext, (List<Type>)ImmutableList.of())});
        Assert.assertSame((Object)driver.getDriverContext(), (Object)driverContext);
        Future<Boolean> driverProcessFor = this.executor.submit(() -> driver.processFor(new Duration(1.0, TimeUnit.MILLISECONDS)).isDone());
        brokenOperator.waitForLocked();
        driver.close();
        Assert.assertTrue((boolean)driver.isFinished());
        try {
            driverProcessFor.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected InterruptedException");
        }
        catch (ExecutionException e) {
            this.assertDriverInterrupted(e.getCause());
        }
    }

    @Test
    public void testBrokenOperatorProcessWhileClosing() throws Exception {
        this.testBrokenOperatorProcessWhileClosing(this.driverContext);
        this.testBrokenOperatorProcessWhileClosing(this.driverContextWithFragmentResultCacheContext);
    }

    private void testBrokenOperatorProcessWhileClosing(DriverContext driverContext) throws Exception {
        BrokenOperator brokenOperator = new BrokenOperator(driverContext.addOperatorContext(0, new PlanNodeId("test"), "source"), true);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)brokenOperator, (Operator[])new Operator[]{this.createSinkOperator(driverContext, (List<Type>)ImmutableList.of())});
        Assert.assertSame((Object)driver.getDriverContext(), (Object)driverContext);
        Future<Boolean> driverClose = this.executor.submit(() -> {
            driver.close();
            return true;
        });
        brokenOperator.waitForLocked();
        Assert.assertTrue((boolean)driver.processFor(new Duration(1.0, TimeUnit.MILLISECONDS)).isDone());
        Assert.assertTrue((boolean)driver.isFinished());
        brokenOperator.unlock();
        Assert.assertTrue((boolean)driverClose.get());
    }

    @Test
    public void testMemoryRevocationRace() {
        this.testMemoryRevocationRace(this.driverContext);
        this.testMemoryRevocationRace(this.driverContextWithFragmentResultCacheContext);
    }

    private void testMemoryRevocationRace(DriverContext driverContext) {
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        AlwaysBlockedMemoryRevokingTableScanOperator source = new AlwaysBlockedMemoryRevokingTableScanOperator(driverContext.addOperatorContext(99, new PlanNodeId("test"), "scan"), new PlanNodeId("source"), (arg_0, arg_1, arg_2, arg_3) -> TestDriver.lambda$testMemoryRevocationRace$4((List)types, arg_0, arg_1, arg_2, arg_3), TESTING_TABLE_HANDLE, (Iterable<ColumnHandle>)ImmutableList.of());
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)source, (Operator[])new Operator[]{this.createSinkOperator(driverContext, (List<Type>)types)});
        Assert.assertTrue((boolean)driver.processFor(new Duration(100.0, TimeUnit.MILLISECONDS)).isDone());
    }

    @Test
    public void testBrokenOperatorAddSource() throws Exception {
        this.testBrokenOperatorAddSource(this.driverContext);
        this.testBrokenOperatorAddSource(this.driverContextWithFragmentResultCacheContext);
    }

    private void testBrokenOperatorAddSource(DriverContext driverContext) throws Exception {
        PlanNodeId sourceId = new PlanNodeId("source");
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        NotBlockedTableScanOperator source = new NotBlockedTableScanOperator(driverContext.addOperatorContext(99, new PlanNodeId("test"), "values"), sourceId, (arg_0, arg_1, arg_2, arg_3) -> TestDriver.lambda$testBrokenOperatorAddSource$5((List)types, arg_0, arg_1, arg_2, arg_3), TESTING_TABLE_HANDLE, (Iterable<ColumnHandle>)ImmutableList.of());
        BrokenOperator brokenOperator = new BrokenOperator(driverContext.addOperatorContext(0, new PlanNodeId("test"), "source"));
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)source, (Operator[])new Operator[]{brokenOperator});
        Future<Boolean> driverProcessFor = this.executor.submit(() -> driver.processFor(new Duration(1.0, TimeUnit.MILLISECONDS)).isDone());
        brokenOperator.waitForLocked();
        Assert.assertSame((Object)driver.getDriverContext(), (Object)driverContext);
        Assert.assertFalse((boolean)driver.isFinished());
        Assert.assertTrue((boolean)driver.processFor(new Duration(1.0, TimeUnit.MILLISECONDS)).isDone());
        Assert.assertFalse((boolean)driver.isFinished());
        driver.updateSource(new TaskSource(sourceId, (Set)ImmutableSet.of((Object)new ScheduledSplit(0L, sourceId, TestDriver.newMockSplit())), true));
        Assert.assertFalse((boolean)driver.isFinished());
        Assert.assertTrue((boolean)driver.processFor(new Duration(1.0, TimeUnit.SECONDS)).isDone());
        Assert.assertFalse((boolean)driver.isFinished());
        driver.close();
        Assert.assertTrue((boolean)driver.isFinished());
        try {
            driverProcessFor.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected InterruptedException");
        }
        catch (ExecutionException e) {
            this.assertDriverInterrupted(e.getCause());
        }
    }

    @Test
    public void testFragmentResultCache() {
        this.processSourceDriver(this.driverContextWithFragmentResultCacheContext);
        this.driverContextWithFragmentResultCacheContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (FragmentResultCacheContext)TESTING_FRAGMENT_RESULT_CACHE_CONTEXT).addPipelineContext(0, true, true, false).addDriverContext();
        this.processSourceDriver(this.driverContextWithFragmentResultCacheContext);
    }

    private void processSourceDriver(DriverContext driverContext) {
        PlanNodeId sourceId = new PlanNodeId("source");
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        TableScanOperator source = new TableScanOperator(driverContext.addOperatorContext(99, new PlanNodeId("test"), "values"), sourceId, (arg_0, arg_1, arg_2, arg_3) -> TestDriver.lambda$processSourceDriver$7((List)types, arg_0, arg_1, arg_2, arg_3), TESTING_TABLE_HANDLE, (Iterable)ImmutableList.of());
        PageConsumerOperator sink = this.createSinkOperator(driverContext, (List<Type>)types);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)source, (Operator[])new Operator[]{sink});
        Assert.assertSame((Object)driver.getDriverContext(), (Object)driverContext);
        Assert.assertFalse((boolean)driver.isFinished());
        Assert.assertFalse((boolean)driver.processFor(new Duration(1.0, TimeUnit.MILLISECONDS)).isDone());
        Assert.assertFalse((boolean)driver.isFinished());
        driver.updateSource(new TaskSource(sourceId, (Set)ImmutableSet.of((Object)new ScheduledSplit(0L, sourceId, TestDriver.newMockSplit())), true));
        Assert.assertFalse((boolean)driver.isFinished());
        Assert.assertTrue((boolean)driver.processFor(new Duration(1.0, TimeUnit.SECONDS)).isDone());
        Assert.assertTrue((boolean)driver.isFinished());
        Assert.assertTrue((boolean)sink.isFinished());
        Assert.assertTrue((boolean)source.isFinished());
    }

    private void assertDriverInterrupted(Throwable cause) {
        Preconditions.checkArgument((boolean)(cause instanceof PrestoException), (Object)"Expected root cause exception to be an instance of PrestoException");
        Assert.assertEquals((Object)((PrestoException)cause).getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
        Assert.assertEquals((String)cause.getMessage(), (String)"Driver was interrupted");
    }

    private static Split newMockSplit() {
        return new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new MockSplit(1));
    }

    private PageConsumerOperator createSinkOperator(DriverContext driverContext, List<Type> types) {
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((Session)driverContext.getSession(), types);
        return new PageConsumerOperator(driverContext.addOperatorContext(1, new PlanNodeId("test"), "sink"), arg_0 -> ((MaterializedResult.Builder)resultBuilder).page(arg_0), Function.identity());
    }

    private static /* synthetic */ ConnectorPageSource lambda$processSourceDriver$7(List types, Session session, Split split, TableHandle table, List columns) {
        return new FixedPageSource(RowPagesBuilder.rowPagesBuilder(types).addSequencePage(10, 20, 30, 40).build());
    }

    private static /* synthetic */ ConnectorPageSource lambda$testBrokenOperatorAddSource$5(List types, Session session, Split split, TableHandle table, List columns) {
        return new FixedPageSource(RowPagesBuilder.rowPagesBuilder(types).addSequencePage(10, 20, 30, 40).build());
    }

    private static /* synthetic */ ConnectorPageSource lambda$testMemoryRevocationRace$4(List types, Session session, Split split, TableHandle table, List columns) {
        return new FixedPageSource(RowPagesBuilder.rowPagesBuilder(types).addSequencePage(10, 20, 30, 40).build());
    }

    private static /* synthetic */ ConnectorPageSource lambda$testAddSourceFinish$1(List types, Session session, Split split, TableHandle table, List columns) {
        return new FixedPageSource(RowPagesBuilder.rowPagesBuilder(types).addSequencePage(10, 20, 30, 40).build());
    }

    private static class TestingFragmentResultCacheManager
    implements FragmentResultCacheManager {
        private final Map<FileFragmentResultCacheManager.CacheKey, List<Page>> cache = new HashMap<FileFragmentResultCacheManager.CacheKey, List<Page>>();

        private TestingFragmentResultCacheManager() {
        }

        public Future<?> put(CanonicalPlanFragment plan, Split split, List<Page> result) {
            this.cache.put(new FileFragmentResultCacheManager.CacheKey(plan, split.getSplitIdentifier()), result);
            return Futures.immediateFuture(null);
        }

        public Optional<Iterator<Page>> get(CanonicalPlanFragment plan, Split split) {
            FileFragmentResultCacheManager.CacheKey key = new FileFragmentResultCacheManager.CacheKey(plan, split.getSplitIdentifier());
            if (this.cache.containsKey(key)) {
                return Optional.of(this.cache.get(key).iterator());
            }
            return Optional.empty();
        }
    }

    private static class MockSplit
    implements ConnectorSplit {
        private final int identifier;

        public MockSplit(int identifier) {
            this.identifier = identifier;
        }

        public NodeSelectionStrategy getNodeSelectionStrategy() {
            return NodeSelectionStrategy.HARD_AFFINITY;
        }

        public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
            return ImmutableList.of();
        }

        public Object getInfo() {
            return null;
        }

        public Object getSplitIdentifier() {
            return this.identifier;
        }
    }

    private static class NotBlockedTableScanOperator
    extends TableScanOperator {
        public NotBlockedTableScanOperator(OperatorContext operatorContext, PlanNodeId planNodeId, PageSourceProvider pageSourceProvider, TableHandle table, Iterable<ColumnHandle> columns) {
            super(operatorContext, planNodeId, pageSourceProvider, table, columns);
        }

        public ListenableFuture<?> isBlocked() {
            return NOT_BLOCKED;
        }
    }

    private static class AlwaysBlockedMemoryRevokingTableScanOperator
    extends TableScanOperator {
        public AlwaysBlockedMemoryRevokingTableScanOperator(OperatorContext operatorContext, PlanNodeId planNodeId, PageSourceProvider pageSourceProvider, TableHandle table, Iterable<ColumnHandle> columns) {
            super(operatorContext, planNodeId, pageSourceProvider, table, columns);
        }

        public ListenableFuture<?> isBlocked() {
            LocalMemoryContext revocableMemoryContext = this.getOperatorContext().localRevocableMemoryContext();
            revocableMemoryContext.setBytes(100L);
            this.getOperatorContext().requestMemoryRevoking();
            return SettableFuture.create();
        }
    }

    private static class BrokenOperator
    implements Operator,
    Closeable {
        private final OperatorContext operatorContext;
        private final ReentrantLock lock = new ReentrantLock();
        private final CountDownLatch lockedLatch = new CountDownLatch(1);
        private final CountDownLatch unlockLatch = new CountDownLatch(1);
        private final boolean lockForClose;

        private BrokenOperator(OperatorContext operatorContext) {
            this(operatorContext, false);
        }

        private BrokenOperator(OperatorContext operatorContext, boolean lockForClose) {
            this.operatorContext = operatorContext;
            this.lockForClose = lockForClose;
        }

        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        public void unlock() {
            this.unlockLatch.countDown();
        }

        private void waitForLocked() {
            try {
                Assert.assertTrue((boolean)this.lockedLatch.await(10L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted", e);
            }
        }

        private void waitForUnlock() {
            try {
                Assert.assertTrue((boolean)this.lock.tryLock(1L, TimeUnit.SECONDS));
                try {
                    this.lockedLatch.countDown();
                    Assert.assertTrue((boolean)this.unlockLatch.await(5L, TimeUnit.SECONDS));
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted", e);
            }
        }

        public void finish() {
            this.waitForUnlock();
        }

        public boolean isFinished() {
            this.waitForUnlock();
            return true;
        }

        public ListenableFuture<?> isBlocked() {
            this.waitForUnlock();
            return NOT_BLOCKED;
        }

        public boolean needsInput() {
            this.waitForUnlock();
            return false;
        }

        public void addInput(Page page) {
            this.waitForUnlock();
        }

        public Page getOutput() {
            this.waitForUnlock();
            return null;
        }

        @Override
        public void close() {
            if (this.lockForClose) {
                this.waitForUnlock();
            }
        }
    }
}

