/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.testing.TestingHttpClient;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.Location;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.execution.buffer.TestingPagesSerdeFactory;
import com.facebook.presto.metadata.RemoteTransactionHandle;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.ExchangeClientConfig;
import com.facebook.presto.operator.ExchangeClientFactory;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.operator.ExchangeOperator;
import com.facebook.presto.operator.MergeOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.TaskExchangeClientManager;
import com.facebook.presto.operator.TestingDriftClient;
import com.facebook.presto.operator.TestingExchangeHttpClientHandler;
import com.facebook.presto.operator.TestingTaskBuffer;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.split.RemoteSplit;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMergeOperator {
    private static final String TASK_1_ID = "task1.0.0.0";
    private static final String TASK_2_ID = "task2.0.0.0";
    private static final String TASK_3_ID = "task3.0.0.0";
    private AtomicInteger operatorId = new AtomicInteger();
    private ScheduledExecutorService executor;
    private PagesSerdeFactory serdeFactory;
    private HttpClient httpClient;
    private ExchangeClientFactory exchangeClientFactory;
    private OrderingCompiler orderingCompiler;
    private LoadingCache<String, TestingTaskBuffer> taskBuffers;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"test-merge-operator-%s"));
        this.serdeFactory = new TestingPagesSerdeFactory();
        this.taskBuffers = CacheBuilder.newBuilder().build(CacheLoader.from(TestingTaskBuffer::new));
        this.httpClient = new TestingHttpClient((TestingHttpClient.Processor)new TestingExchangeHttpClientHandler(this.taskBuffers), (ExecutorService)this.executor);
        this.exchangeClientFactory = new ExchangeClientFactory(new ExchangeClientConfig(), this.httpClient, new TestingDriftClient(), this.executor);
        this.orderingCompiler = new OrderingCompiler();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.serdeFactory = null;
        this.orderingCompiler = null;
        this.httpClient.close();
        this.httpClient = null;
        this.executor.shutdownNow();
        this.executor = null;
        this.exchangeClientFactory.stop();
        this.exchangeClientFactory = null;
    }

    @Test
    public void testSingleStream() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        MergeOperator operator = this.createMergeOperator((List<Type>)types, (List<Integer>)ImmutableList.of((Object)1), (List<Integer>)ImmutableList.of((Object)0, (Object)1), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST, (Object)SortOrder.ASC_NULLS_FIRST));
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertFalse((boolean)operator.isBlocked().isDone());
        operator.addSplit(TestMergeOperator.createRemoteSplit(TASK_1_ID));
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertFalse((boolean)operator.isBlocked().isDone());
        operator.noMoreSplits();
        List<Page> input = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1, 1).row(2, 2).pageBreak().row(3, 3).row(4, 4).build();
        Assert.assertNull((Object)operator.getOutput());
        Assert.assertFalse((boolean)operator.isFinished());
        OperatorAssertion.assertOperatorIsBlocked((Operator)operator);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_1_ID)).addPage(input.get(0), false);
        OperatorAssertion.assertOperatorIsUnblocked((Operator)operator);
        Assert.assertNull((Object)operator.getOutput());
        OperatorAssertion.assertOperatorIsBlocked((Operator)operator);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_1_ID)).addPage(input.get(1), true);
        OperatorAssertion.assertOperatorIsUnblocked((Operator)operator);
        Page expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(1).row(2).row(3).row(4).build().get(0);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), (Page)Iterables.getOnlyElement(TestMergeOperator.pullAvailablePages((Operator)operator)), expected);
        operator.close();
    }

    @Test
    public void testMergeDifferentTypes() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER);
        MergeOperator operator = this.createMergeOperator((List<Type>)types, (List<Integer>)ImmutableList.of((Object)1, (Object)0), (List<Integer>)ImmutableList.of((Object)1, (Object)0), (List<SortOrder>)ImmutableList.of((Object)SortOrder.DESC_NULLS_FIRST, (Object)SortOrder.ASC_NULLS_FIRST));
        operator.addSplit(TestMergeOperator.createRemoteSplit(TASK_1_ID));
        operator.addSplit(TestMergeOperator.createRemoteSplit(TASK_2_ID));
        operator.noMoreSplits();
        List<Page> task1Pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(0, null).row(1, 4).row(2, 3).build();
        List<Page> task2Pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(null, 5).row(2, 5).row(4, 3).build();
        Assert.assertNull((Object)operator.getOutput());
        OperatorAssertion.assertOperatorIsBlocked((Operator)operator);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_1_ID)).addPages(task1Pages, true);
        OperatorAssertion.assertOperatorIsUnblocked((Operator)operator);
        Assert.assertNull((Object)operator.getOutput());
        OperatorAssertion.assertOperatorIsBlocked((Operator)operator);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_2_ID)).addPages(task2Pages, true);
        OperatorAssertion.assertOperatorIsUnblocked((Operator)operator);
        ImmutableList outputTypes = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT);
        Page expected = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row(null, 0).row(5, null).row(5, 2).row(4, 1).row(3, 2).row(3, 4).build().get(0);
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, (Page)Iterables.getOnlyElement(TestMergeOperator.pullAvailablePages((Operator)operator)), expected);
        operator.close();
    }

    @Test
    public void testMultipleStreamsSameOutputColumns() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        MergeOperator operator = this.createMergeOperator((List<Type>)types, (List<Integer>)ImmutableList.of((Object)0, (Object)1, (Object)2), (List<Integer>)ImmutableList.of((Object)0), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST));
        operator.addSplit(TestMergeOperator.createRemoteSplit(TASK_1_ID));
        operator.addSplit(TestMergeOperator.createRemoteSplit(TASK_2_ID));
        operator.addSplit(TestMergeOperator.createRemoteSplit(TASK_3_ID));
        operator.noMoreSplits();
        List<Page> source1Pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1, 1, 2).row(8, 1, 1).row(19, 1, 3).row(27, 1, 4).row(41, 2, 5).pageBreak().row(55, 1, 2).row(89, 1, 3).row(101, 1, 4).row(202, 1, 3).row(399, 2, 2).pageBreak().row(400, 1, 1).row(401, 1, 7).row(402, 1, 6).build();
        List<Page> source2Pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(2, 1, 2).row(8, 1, 1).row(19, 1, 3).row(25, 1, 4).row(26, 2, 5).pageBreak().row(56, 1, 2).row(66, 1, 3).row(77, 1, 4).row(88, 1, 3).row(99, 2, 2).pageBreak().row(99, 1, 1).row(100, 1, 7).row(100, 1, 6).build();
        List<Page> source3Pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(88, 1, 3).row(89, 1, 3).row(90, 1, 3).row(91, 1, 4).row(92, 2, 5).pageBreak().row(93, 1, 2).row(94, 1, 3).row(95, 1, 4).row(97, 1, 3).row(98, 2, 2).build();
        Assert.assertNull((Object)operator.getOutput());
        Assert.assertFalse((boolean)operator.isFinished());
        OperatorAssertion.assertOperatorIsBlocked((Operator)operator);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_1_ID)).addPage(source1Pages.get(0), false);
        OperatorAssertion.assertOperatorIsUnblocked((Operator)operator);
        Assert.assertNull((Object)operator.getOutput());
        OperatorAssertion.assertOperatorIsBlocked((Operator)operator);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_2_ID)).addPage(source2Pages.get(0), false);
        OperatorAssertion.assertOperatorIsUnblocked((Operator)operator);
        Assert.assertNull((Object)operator.getOutput());
        OperatorAssertion.assertOperatorIsBlocked((Operator)operator);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_3_ID)).addPage(source3Pages.get(0), false);
        OperatorAssertion.assertOperatorIsUnblocked((Operator)operator);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_1_ID)).addPage(source1Pages.get(1), false);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_2_ID)).addPage(source2Pages.get(1), false);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_3_ID)).addPage(source3Pages.get(1), true);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_2_ID)).addPage(source2Pages.get(2), true);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_1_ID)).addPage(source1Pages.get(2), true);
        Page expected = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1, 1, 2).row(2, 1, 2).row(8, 1, 1).row(8, 1, 1).row(19, 1, 3).row(19, 1, 3).row(25, 1, 4).row(26, 2, 5).row(27, 1, 4).row(41, 2, 5).row(55, 1, 2).row(56, 1, 2).row(66, 1, 3).row(77, 1, 4).row(88, 1, 3).row(88, 1, 3).row(89, 1, 3).row(89, 1, 3).row(90, 1, 3).row(91, 1, 4).row(92, 2, 5).row(93, 1, 2).row(94, 1, 3).row(95, 1, 4).row(97, 1, 3).row(98, 2, 2).row(99, 2, 2).row(99, 1, 1).row(100, 1, 7).row(100, 1, 6).row(101, 1, 4).row(202, 1, 3).row(399, 2, 2).row(400, 1, 1).row(401, 1, 7).row(402, 1, 6).build().get(0);
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)Iterables.getOnlyElement(TestMergeOperator.pullAvailablePages((Operator)operator)), expected);
        operator.close();
    }

    private MergeOperator createMergeOperator(List<Type> sourceTypes, List<Integer> outputChannels, List<Integer> sortChannels, List<SortOrder> sortOrder) {
        int mergeOperatorId = this.operatorId.getAndIncrement();
        MergeOperator.MergeOperatorFactory factory = new MergeOperator.MergeOperatorFactory(mergeOperatorId, new PlanNodeId("plan_node_id" + mergeOperatorId), new TaskExchangeClientManager((ExchangeClientSupplier)this.exchangeClientFactory), this.serdeFactory, this.orderingCompiler, sourceTypes, outputChannels, sortChannels, sortOrder);
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.executor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        return (MergeOperator)factory.createOperator(driverContext);
    }

    private static Split createRemoteSplit(String taskId) {
        return new Split(ExchangeOperator.REMOTE_CONNECTOR_ID, (ConnectorTransactionHandle)new RemoteTransactionHandle(), (ConnectorSplit)new RemoteSplit(new Location("http://localhost/" + taskId), TaskId.valueOf((String)taskId)));
    }

    private static List<Page> pullAvailablePages(Operator operator) throws InterruptedException {
        long endTime = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
        ArrayList<Page> outputPages = new ArrayList<Page>();
        OperatorAssertion.assertOperatorIsUnblocked(operator);
        while (!operator.isFinished() && System.nanoTime() - endTime < 0L) {
            Assert.assertFalse((boolean)operator.needsInput());
            Page outputPage = operator.getOutput();
            if (outputPage != null) {
                outputPages.add(outputPage);
                continue;
            }
            Thread.sleep(10L);
        }
        Assert.assertFalse((boolean)operator.needsInput(), (String)"Operator still wants input");
        Assert.assertTrue((boolean)operator.isFinished(), (String)"Expected operator to be finished");
        return outputPages;
    }
}

